/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.search.TextExpression;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.glossary.GlossaryEntryView;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossarySortCriteria;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.glossary.MergedGlossaryEntries;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class FindGlossaryThread
extends EntryInfoSearchThread<List<GlossaryEntryView>> {
    private final String src;
    private final GlossaryManager manager;

    public FindGlossaryThread(GlossaryTextArea pane, SourceTextEntry newEntry, GlossaryManager manager) {
        super(pane, newEntry);
        this.src = Preferences.isPreferenceDefault("glossary_remove_tags", false) ? newEntry.getSrcText().replaceAll("</?\\w+/?>", "") : newEntry.getSrcText();
        this.manager = manager;
    }

    @Override
    protected List<GlossaryEntryView> search() {
        SearchModeBox dummyBox = new SearchModeBox(0, ITokenizer.StemmingMode.GLOSSARY, null);
        dummyBox.loadPreferences("transtips_");
        List<GlossaryEntryStore> entries = this.manager.getGlossaryEntries(this.src);
        if (entries == null) {
            return Collections.emptyList();
        }
        ArrayList<GlossaryEntryStore> result = new ArrayList<GlossaryEntryStore>();
        for (GlossaryEntryStore glosEntry : entries) {
            this.checkEntryChanged();
            TextExpression expr = dummyBox.buildExpression(glosEntry.getSrcText(), false, true);
            if (expr.matchesString(this.src)) {
                result.add(glosEntry);
                continue;
            }
            if (Core.getProject().getProjectProperties().getSourceLanguage().isSpaceDelimited() || !StringUtil.isCJK(glosEntry.getSrcText()) || !this.src.contains(glosEntry.getSrcText())) continue;
            result.add(glosEntry);
        }
        Collections.sort(result, GlossarySortCriteria.buildFullComparator(Preferences.getPreferenceDefault("glossary_pane_sort_order", "APL;apl")));
        return FindGlossaryThread.filterGlossary(result);
    }

    static List<GlossaryEntryView> filterGlossary(List<GlossaryEntryStore> result) {
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        GlossaryEntryStore replaceEntry = new GlossaryEntryStore("", "", "", null);
        boolean removedDuplicate = false;
        SearchModeBox dummyBox = null;
        if (Preferences.isPreferenceDefault("glossary_remove_subwords", false)) {
            dummyBox = new SearchModeBox(0, ITokenizer.StemmingMode.GLOSSARY, null);
            dummyBox.loadPreferences("transtips_");
        }
        for (int i = 0; i < result.size(); ++i) {
            GlossaryEntryStore nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            for (int j = i + 1; j < result.size(); ++j) {
                TextExpression expr;
                GlossaryEntryStore thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("")) continue;
                if (nowEntry.equals(thenEntry)) {
                    result.set(j, replaceEntry);
                    removedDuplicate = true;
                }
                if (!Preferences.isPreferenceDefault("glossary_remove_subwords", false) || (expr = dummyBox.buildExpression(thenEntry.getSrcText(), false, true)).searchString(nowEntry.getSrcText()) == null) continue;
                result.set(j, replaceEntry);
                removedDuplicate = true;
            }
        }
        if (removedDuplicate) {
            Iterator<GlossaryEntryStore> myIter = result.iterator();
            LinkedList<GlossaryEntryStore> newList = new LinkedList<GlossaryEntryStore>();
            while (myIter.hasNext()) {
                GlossaryEntryStore checkEntry = myIter.next();
                if (checkEntry.equals(replaceEntry)) {
                    myIter.remove();
                    continue;
                }
                newList.add(checkEntry);
            }
            result = newList;
        }
        LinkedList<GlossaryEntryView> returnList = new LinkedList<GlossaryEntryView>();
        if (!Preferences.isPreferenceDefault("glossary_pane_do_merge", true)) {
            returnList.addAll(result);
            return returnList;
        }
        for (int i = 0; i < result.size(); ++i) {
            LinkedList<GlossaryEntryStore> srcList = new LinkedList<GlossaryEntryStore>();
            GlossaryEntryStore nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            srcList.add(nowEntry);
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntryStore thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText())) continue;
                srcList.add(thenEntry);
                result.set(j, replaceEntry);
            }
            LinkedList<GlossaryEntryStore> sortList = new LinkedList<GlossaryEntryStore>();
            if (srcList.size() > 1) {
                for (int k = 0; k < srcList.size(); ++k) {
                    GlossaryEntryStore srcNow = (GlossaryEntryStore)srcList.get(k);
                    if (srcNow.getSrcText().equals("")) continue;
                    sortList.add(srcNow);
                    for (int l = k + 1; l < srcList.size(); ++l) {
                        GlossaryEntryStore srcThen = (GlossaryEntryStore)srcList.get(l);
                        if (srcThen.getSrcText().equals("") || !srcNow.getLocText().equals(srcThen.getLocText())) continue;
                        sortList.add(srcThen);
                        srcList.set(l, replaceEntry);
                    }
                }
            } else {
                sortList = srcList;
            }
            String srcTxt = ((GlossaryEntryStore)sortList.get(0)).getSrcText();
            if (sortList.size() > 1) {
                Collections.sort(sortList, GlossarySortCriteria.buildTargetComparator(Preferences.getPreferenceDefault("glossary_pane_sort_order", "APL;apl")));
                MergedGlossaryEntries combineEntry = new MergedGlossaryEntries(srcTxt, sortList);
                returnList.add(combineEntry);
                continue;
            }
            returnList.add((GlossaryEntryView)sortList.get(0));
        }
        return returnList;
    }
}

