/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.machinetranslators.dummy.SourceTranslate;
import org.omegat.core.matching.NearString;
import org.omegat.core.search.CrossSourceSearcher;
import org.omegat.core.search.PreTranslateSearcher;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.Searcher;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.editor.filter.CrossSourceFilter;
import org.omegat.gui.editor.filter.PreTranslateFilter;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.gui.search.SearchVarExpansion;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.omegat.util.TMXWriter2;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class PreTranslateDialog
extends ProjectSearchWindow {
    private static final Map<String, Set<String>> theMap = new HashMap<String, Set<String>>();
    private SearchWindow.SetRef searchRef;
    private SearchWindow.SetRef replaceRef;
    private GroupPopupMenuListener groupPopupMenuListener = new GroupPopupMenuListener();
    private static final String PRETRA_COPY_WHOLE = "WHOLE";
    private static final String PRETRA_COPY_EXACT = "EXACT";
    private static final String PRETRA_ONLY_TEXT = "ONLY_TEXT";
    private static final String PRETRA_SRC_FULL = "FULL";
    private static final String PRETRA_SRC_FOUND = "FOUND";
    private static final String PRETRA_TYPE_SOURCE = "SOURCE";
    private static final String PRETRA_TYPE_TEXT = "TEXT";
    private static final String PRETRA_TYPE_MATCH = "MATCH";
    private static final String PRETRA_TYPE_AUTO = "MT";
    private JLabel m_searchLabel;
    private JComboBox m_searchField;
    private JLabel m_translateLabel;
    private JComboBox m_translateField;
    private JTextField m_prefixField;
    private JRadioButton m_translateTxtEntire;
    private JRadioButton m_translateTxtWhole;
    private JRadioButton m_translateTxtFound;
    private JCheckBox m_translateTxtRegex;
    private JRadioButton m_translateSrcEntire;
    private JRadioButton m_translateSrcFound;
    private JCheckBox m_translateSrcGlos;
    private JCheckBox m_translateSrcGlosOnly;
    private JCheckBox m_transAsAlternative;
    private JButton m_translateInt;
    private JButton m_translateAll;
    private JRadioButton m_translateSource;
    private JRadioButton m_translateText;
    private JRadioButton m_translateMatch;
    private JRadioButton m_translateAuto;
    private JRadioButton m_searchTranslated;
    private JRadioButton m_searchUntranslated;
    private JRadioButton m_searchTranslatedUntranslated;
    private JRadioButton m_matchTM;
    private JRadioButton m_matchSource;
    private JTextField m_TMpath;
    private JSpinner m_groupSize;
    private Box bMatch;
    private JButton memTraBtn;
    private JComboBox<NearString.SORT_KEY> m_scoreSelector;
    private JSpinner m_minScore;
    private JComboBox m_preferredMt;

    public PreTranslateDialog(MainWindow par, String startText) {
        super(par, "");
        this.updateUIText();
        this.refreshLists(true);
        for (JComboBox box : new JComboBox[]{this.m_searchField, this.m_translateField}) {
            JTextComponent searchFieldArea = (JTextComponent)box.getEditor().getEditorComponent();
            searchFieldArea.addMouseListener(new SearchWindow.PopupFactory(searchFieldArea));
        }
        if (startText != null) {
            this.getMainSearchTextField().setSelectedItem(startText);
        }
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, (JTextComponent)this.m_searchField.getEditor().getEditorComponent()));
        this.m_translateTxtRegex.addActionListener(new ActionListener(){
            private JTextComponent receiver;
            private RegexHighlightListener listener;
            {
                this.receiver = (JTextComponent)PreTranslateDialog.this.m_translateField.getEditor().getEditorComponent();
                this.listener = new RegexHighlightListener(this.receiver, 24);
                this.actionPerformed(null);
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (PreTranslateDialog.this.m_translateTxtRegex.isSelected()) {
                    this.receiver.getDocument().addDocumentListener(this.listener);
                } else {
                    this.receiver.getDocument().removeDocumentListener(this.listener);
                }
            }
        });
        this.m_viewer.addMouseListener(this.groupPopupMenuListener);
    }

    @Override
    protected String getScopeText() {
        return OStrings.getString("SW_HELP_SCOPE_PRETRA");
    }

    @Override
    protected boolean isReplace() {
        return true;
    }

    @Override
    public void refreshLists(boolean removeContents) {
        String selected = removeContents ? "" : this.m_searchField.getSelectedItem().toString();
        this.m_searchField.removeAllItems();
        this.m_searchField.addItem(selected);
        this.searchRef.theSet = theMap.get("SW_SEARCH_TEXT:" + this.m_modePanel.searchTypeString());
        for (String item : this.searchRef.theSet) {
            this.m_searchField.addItem(SearchModeBox.MemorizedExpression.forString(item));
        }
        this.m_searchField.setSelectedItem(selected);
        selected = removeContents ? "" : this.m_translateField.getSelectedItem().toString();
        this.m_translateField.removeAllItems();
        this.m_translateField.addItem(selected);
        this.replaceRef.theSet = theMap.get("SW_REPLACE_BY:" + this.m_modePanel.searchTypeString());
        for (String item : this.replaceRef.theSet) {
            this.m_translateField.addItem(SearchModeBox.MemorizedExpression.forString(item));
        }
        this.m_translateField.setSelectedItem(selected);
    }

    @Override
    protected JComponent textPanel(String startText) {
        this.m_translateLabel = new JLabel();
        this.m_translateField = new JComboBox();
        this.m_translateField.setEditable(true);
        this.m_searchLabel = new JLabel();
        this.m_searchField = new JComboBox();
        this.m_searchField.setEditable(true);
        this.m_searchField.addActionListener(ev -> {
            try {
                SearchModeBox.MemorizedExpression item = (SearchModeBox.MemorizedExpression)this.m_searchField.getSelectedItem();
                item.applyTo(this.m_modePanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (startText != null) {
            this.m_searchField.setSelectedItem(startText);
        }
        Box bSearch = Box.createHorizontalBox();
        bSearch.add(this.m_searchLabel);
        bSearch.add(this.m_searchField);
        this.searchRef = new SearchWindow.SetRef(theMap.get("SW_SEARCH_TEXT:EXACT"));
        bSearch.add(this.createMemorizeButton(this.getY(), true, this.m_searchField, null, "SW_SEARCH_TEXT", this.searchRef));
        Box bReplace = Box.createVerticalBox();
        this.m_translateLabel = new JLabel();
        this.m_translateField = new JComboBox();
        this.m_translateField.setEditable(true);
        Box bReplaceLine1 = Box.createHorizontalBox();
        bReplace.add(bReplaceLine1);
        bReplaceLine1.add(this.m_translateLabel);
        this.m_translateSource = new JRadioButton(OStrings.getString("SW_PRETRA_REPLACEBY_SOURCE"));
        bReplaceLine1.add(this.m_translateSource);
        this.m_translateMatch = new JRadioButton(OStrings.getString("SW_PRETRA_REPLACEBY_MATCH"));
        bReplaceLine1.add(this.m_translateMatch);
        bReplaceLine1.add(new JLabel(OStrings.getString("SW_PRETRA_REPLACEBY_MATCH_MIN_SCORE")));
        this.m_scoreSelector = new JComboBox();
        bReplaceLine1.add(this.m_scoreSelector);
        this.m_scoreSelector.setModel(new DefaultComboBoxModel<NearString.SORT_KEY>(new NearString.SORT_KEY[]{NearString.SORT_KEY.SCORE, NearString.SORT_KEY.SCORE_NO_STEM, NearString.SORT_KEY.ADJUSTED_SCORE}));
        this.m_scoreSelector.setRenderer((ListCellRenderer<NearString.SORT_KEY>)new DelegatingComboBoxRenderer<NearString.SORT_KEY>(){

            @Override
            protected Object getDisplayText(NearString.SORT_KEY value) {
                return OStrings.getString("EXT_TMX_SORT_KEY_" + value.name());
            }
        });
        class ScoreKeyListener
        implements ItemListener {
            private String unselectedDefault;

            ScoreKeyListener() {
                this.unselectedDefault = this.defaultText((NearString.SORT_KEY)((Object)PreTranslateDialog.this.m_scoreSelector.getSelectedItem()));
            }

            private String defaultText(NearString.SORT_KEY key) {
                switch (key) {
                    case SCORE: {
                        return "[${score} %]";
                    }
                    case SCORE_NO_STEM: {
                        return "[${noStemScore} %]";
                    }
                    case ADJUSTED_SCORE: {
                        return "[${adjustedScore} %]";
                    }
                }
                return null;
            }

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 2) {
                    this.unselectedDefault = this.defaultText((NearString.SORT_KEY)((Object)ev.getItem()));
                }
                if (ev.getStateChange() == 1) {
                    if (PreTranslateDialog.this.m_prefixField.getText().equals(this.unselectedDefault)) {
                        PreTranslateDialog.this.m_prefixField.setText(this.defaultText((NearString.SORT_KEY)((Object)ev.getItem())));
                    }
                    if (PreTranslateDialog.this.m_prefixField.getText().equals("")) {
                        PreTranslateDialog.this.m_prefixField.setText(this.defaultText((NearString.SORT_KEY)((Object)ev.getItem())));
                    }
                }
            }
        }
        ScoreKeyListener skListener = new ScoreKeyListener();
        this.m_scoreSelector.addItemListener(skListener);
        this.m_minScore = new JSpinner();
        bReplaceLine1.add(this.m_minScore);
        this.m_minScore.setModel(new SpinnerNumberModel(80, 0, 100, 1));
        this.m_translateAuto = new JRadioButton(OStrings.getString("SW_PRETRA_REPLACEBY_MT"));
        bReplaceLine1.add(this.m_translateAuto);
        this.m_preferredMt = new JComboBox();
        bReplaceLine1.add(this.m_preferredMt);
        this.m_preferredMt.setModel(new DefaultComboBoxModel<IMachineTranslation>(Core.getMachineTranslatePane().translators));
        this.m_preferredMt.setRenderer(new DelegatingComboBoxRenderer<IMachineTranslation>(){

            @Override
            protected Object getDisplayText(IMachineTranslation value) {
                return value.getName();
            }
        });
        for (IMachineTranslation tra : Core.getMachineTranslatePane().translators) {
            if (!tra.getClass().getName().equals(Preferences.getPreference("wf_preferredMt"))) continue;
            this.m_preferredMt.setSelectedItem(tra);
        }
        if (Core.getMachineTranslatePane().translators.length == 1) {
            this.m_preferredMt.setVisible(false);
        }
        bReplaceLine1.add(Box.createHorizontalStrut(10));
        bReplaceLine1.add(new JLabel(OStrings.getString("WF_OPTION_INSERT_FUZZY_PREFIX").replace("&", "")));
        this.m_prefixField = new JTextField();
        bReplaceLine1.add(this.m_prefixField);
        Box bReplaceLine2 = Box.createHorizontalBox();
        bReplace.add(bReplaceLine2);
        this.m_translateText = new JRadioButton("\t" + OStrings.getString("SW_PRETRA_REPLACEBY_TEXT"));
        bReplaceLine2.add(this.m_translateText);
        bReplaceLine2.add(this.m_translateField);
        this.replaceRef = new SearchWindow.SetRef(theMap.get("SW_REPLACE_BY:EXACT"));
        this.memTraBtn = this.createMemorizeButton(this.getY(), true, this.m_translateField, null, "SW_REPLACE_BY", this.replaceRef);
        bReplaceLine2.add(this.memTraBtn);
        Box bBoth = Box.createVerticalBox();
        bBoth.add(bSearch);
        bBoth.add(bReplace);
        this.m_translateSource.addActionListener(e -> {
            this.m_prefixField.setText("");
            this.setMatchEnabled(false);
        });
        this.m_translateText.addActionListener(e -> {
            this.m_prefixField.setText("");
            this.setMatchEnabled(false);
        });
        this.m_translateAuto.addActionListener(e -> {
            this.m_prefixField.setText("[MT]");
            this.setMatchEnabled(false);
        });
        this.m_translateMatch.addActionListener(e -> {
            this.m_prefixField.setText(skListener.defaultText((NearString.SORT_KEY)((Object)((Object)this.m_scoreSelector.getSelectedItem()))));
            this.setMatchEnabled(true);
        });
        return bBoth;
    }

    @Override
    public JComboBox getMainSearchTextField() {
        return this.m_searchField;
    }

    @Override
    protected JComponent modePanel() {
        this.m_modePanel = (SearchModeBox)super.modePanel();
        Box bVertical = Box.createVerticalBox();
        bVertical.add(this.m_modePanel);
        Box bReplace = Box.createHorizontalBox();
        this.m_translateTxtEntire = new JRadioButton(OStrings.getString("SW_PRETRA_ACTION_TXT_ENTIRE"));
        bReplace.add(this.m_translateTxtEntire);
        this.m_translateTxtFound = new JRadioButton(OStrings.getString("SW_PRETRA_ACTION_TXT_FOUND"));
        bReplace.add(this.m_translateTxtFound);
        this.m_translateTxtWhole = new JRadioButton(OStrings.getString("SW_PRETRA_ACTION_TXT_WORDS"));
        bReplace.add(this.m_translateTxtWhole);
        this.m_translateTxtRegex = new JCheckBox(OStrings.getString("SW_PRETRA_ACTION_TXT_REGEX"));
        bReplace.add(this.m_translateTxtRegex);
        this.m_translateSrcEntire = new JRadioButton(OStrings.getString("SW_PRETRA_ACTION_SRC_ENTIRE"));
        bReplace.add(this.m_translateSrcEntire);
        this.m_translateSrcFound = new JRadioButton(OStrings.getString("SW_PRETRA_ACTION_SRC_FOUND"));
        bReplace.add(this.m_translateSrcFound);
        this.m_translateSrcGlos = new JCheckBox(OStrings.getString("SW_PRETRA_ACTION_SRC_GLOS"));
        bReplace.add(this.m_translateSrcGlos);
        this.m_translateSrcGlosOnly = new JCheckBox(OStrings.getString("SW_PRETRA_ACTION_SRC_WITH_GLOS_ONLY"));
        bReplace.add(this.m_translateSrcGlosOnly);
        this.m_translateSrcGlos.addChangeListener(ev -> this.m_translateSrcGlosOnly.setEnabled(this.m_translateSrcGlos.isSelected()));
        bReplace.add(new JLabel("   "));
        this.m_transAsAlternative = new JCheckBox(OStrings.getString("SW_PRETRA_ACTION_AS_ALTERNATIVE"));
        bReplace.add(this.m_transAsAlternative);
        this.m_transAsAlternative.setEnabled(Core.getProject().getProjectProperties().isSupportDefaultTranslations());
        this.m_transAsAlternative.setSelected(!Core.getProject().getProjectProperties().isSupportDefaultTranslations());
        bReplace.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_PRETRA_MODE")));
        bVertical.add(bReplace);
        ButtonGroup bgExpr = new ButtonGroup();
        bgExpr.add(this.m_translateTxtEntire);
        bgExpr.add(this.m_translateTxtFound);
        bgExpr.add(this.m_translateTxtWhole);
        this.m_translateTxtFound.setSelected(true);
        bgExpr = new ButtonGroup();
        bgExpr.add(this.m_translateSrcEntire);
        bgExpr.add(this.m_translateSrcFound);
        for (AbstractButton component : this.m_modePanel.getOptionsComponents()) {
            this.addFocusToSearchListener(component);
        }
        JComponent[] boxReplaceTxt = new JComponent[]{this.m_translateTxtEntire, this.m_translateTxtFound, this.m_translateTxtWhole, this.m_translateTxtRegex};
        JComponent[] boxReplaceSrc = new JComponent[]{this.m_translateSrcEntire, this.m_translateSrcFound, this.m_translateSrcGlos, this.m_translateSrcGlosOnly};
        ActionListener disableButtons = e -> {
            this.m_translateField.setEnabled(this.m_translateText.isSelected());
            this.memTraBtn.setEnabled(this.m_translateText.isSelected());
            for (JComponent comp : boxReplaceTxt) {
                comp.setEnabled(this.m_translateText.isSelected());
                if (this.m_translateSource.isSelected()) {
                    comp.setVisible(false);
                }
                if (!this.m_translateText.isSelected()) continue;
                comp.setVisible(true);
            }
            for (JComponent comp : boxReplaceSrc) {
                comp.setEnabled(this.m_translateSource.isSelected());
                if (this.m_translateText.isSelected()) {
                    comp.setVisible(false);
                }
                if (!this.m_translateSource.isSelected()) continue;
                comp.setVisible(true);
            }
            this.m_prefixField.setEnabled(!this.m_translateText.isSelected());
            this.m_minScore.setEnabled(this.m_translateMatch.isSelected());
            this.m_scoreSelector.setEnabled(this.m_translateMatch.isSelected());
        };
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton btn : new JRadioButton[]{this.m_translateSource, this.m_translateMatch, this.m_translateAuto, this.m_translateText}) {
            group.add(btn);
            btn.addActionListener(disableButtons);
        }
        this.m_translateSource.setSelected(true);
        disableButtons.actionPerformed(null);
        return bVertical;
    }

    @Override
    protected Box buttonsPanel() {
        Box bButtons = super.buttonsPanel();
        this.m_translateInt = new JButton();
        bButtons.add(this.m_translateInt);
        this.m_translateAll = new JButton();
        bButtons.add(this.m_translateAll);
        this.m_translateInt.setEnabled(false);
        this.m_translateAll.setEnabled(false);
        this.m_translateInt.addActionListener(e -> {
            Core.getEditor().commitAndLeave();
            Core.getEditor().setFilter(new PreTranslateFilter((PreTranslateSearcher)this.m_thread));
        });
        this.m_translateAll.addActionListener(e -> {
            Core.getEditor().commitAndDeactivate();
            int count = this.m_viewer.getEntryList().size();
            String msg = MessageFormat.format(OStrings.getString("SW_REPLACE_ALL_CONFIRM"), count);
            int r = JOptionPane.showConfirmDialog(this, msg, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
            if (r == 0) {
                this.m_resultsLabel.setText(OStrings.getString("SW_PRETRA_WAIT_FINISHED"));
                SwingUtilities.invokeLater(() -> {
                    new PreTranslateFilter((PreTranslateSearcher)this.m_thread).translateAll(this.m_resultsLabel);
                    Thread.yield();
                    this.m_resultsLabel.setText(OStrings.getString("SW_PRETRA_WAIT_FINISHED"));
                    if (count >= (Integer)this.m_numberOfResults.getValue()) {
                        String msg1 = MessageFormat.format(OStrings.getString("SW_PRETRA_WAIT_COUNT_QUESTION"), count);
                        int r1 = JOptionPane.showConfirmDialog(this, msg1, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
                        if (r1 == 0) {
                            this.doSearch(true);
                        }
                    } else {
                        String msg2 = MessageFormat.format(OStrings.getString("SW_PRETRA_WAIT_COUNT_OK"), count);
                        JOptionPane.showMessageDialog(this, msg2);
                    }
                });
            }
            Core.getEditor().activateEntry();
        });
        return bButtons;
    }

    private void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        this.dispose();
    }

    private void updateUIText() {
        this.setTitle("Search and Pre-translate");
        Mnemonics.setLocalizedText(this.m_searchLabel, OStrings.getString("SW_SEARCH_TEXT"));
        Mnemonics.setLocalizedText(this.m_translateLabel, OStrings.getString("SW_PRETRANSLATE_TEXT"));
        Mnemonics.setLocalizedText(this.m_translateInt, OStrings.getString("BUTTON_TRANSLATE_INT"));
        Mnemonics.setLocalizedText(this.m_translateAll, OStrings.getString("BUTTON_TRANSLATE_ALL"));
    }

    @Override
    protected Box optionsPanel() {
        this.m_searchTranslated = new JRadioButton();
        this.m_searchUntranslated = new JRadioButton();
        this.m_searchTranslatedUntranslated = new JRadioButton();
        Mnemonics.setLocalizedText(this.m_searchTranslated, OStrings.getString("SW_SEARCH_TRANSLATED"));
        Mnemonics.setLocalizedText(this.m_searchUntranslated, OStrings.getString("SW_SEARCH_UNTRANSLATED"));
        Mnemonics.setLocalizedText(this.m_searchTranslatedUntranslated, OStrings.getString("SW_SEARCH_TRANSLATEDUNTRANSLATED"));
        Box bOB = Box.createHorizontalBox();
        bOB.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_SEARCH_IN_BOX") + "..."));
        bOB.add(this.m_searchTranslated);
        bOB.add(this.m_searchUntranslated);
        bOB.add(this.m_searchTranslatedUntranslated);
        this.addFocusToSearchListener(this.m_searchTranslated);
        this.addFocusToSearchListener(this.m_searchUntranslated);
        this.addFocusToSearchListener(this.m_searchTranslatedUntranslated);
        ButtonGroup gOptions = new ButtonGroup();
        gOptions.add(this.m_searchTranslated);
        gOptions.add(this.m_searchUntranslated);
        gOptions.add(this.m_searchTranslatedUntranslated);
        this.m_searchUntranslated.setSelected(true);
        this.bMatch = Box.createHorizontalBox();
        this.m_matchTM = new JRadioButton();
        this.m_matchSource = new JRadioButton();
        Mnemonics.setLocalizedText(this.m_matchTM, OStrings.getString("SW_PRETRA_MATCH_IN_TM"));
        Mnemonics.setLocalizedText(this.m_matchSource, OStrings.getString("SW_PRETRA_MATCH_IN_SRC"));
        this.bMatch.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_PRETRA_MATCH_IN") + "..."));
        this.bMatch.add(this.m_matchTM);
        this.m_TMpath = new JTextField();
        this.bMatch.add(this.m_TMpath);
        this.bMatch.add(this.m_matchSource);
        this.bMatch.add(new JLabel(OStrings.getString("SW_PRETRA_MATCH_GROUP_SIZE")));
        this.m_groupSize = new JSpinner();
        this.bMatch.add(this.m_groupSize);
        this.m_groupSize.setModel(new SpinnerNumberModel(5, 0, 100, 1));
        this.m_matchTM.addActionListener(e -> {
            this.m_TMpath.setEnabled(true);
            this.m_groupSize.setEnabled(false);
            this.m_minScore.setValue(Preferences.getPreferenceDefault("search_window_match_score", 80));
        });
        this.m_matchSource.addActionListener(e -> {
            this.m_TMpath.setEnabled(false);
            this.m_groupSize.setEnabled(true);
            this.m_minScore.setValue(Preferences.getPreferenceDefault("search_window_match_score_xsrc", 30));
        });
        gOptions = new ButtonGroup();
        gOptions.add(this.m_matchTM);
        gOptions.add(this.m_matchSource);
        Box bAll = Box.createHorizontalBox();
        bAll.add(bOB);
        bAll.add(this.bMatch);
        return bAll;
    }

    private void setMatchEnabled(boolean enabled) {
        this.bMatch.setEnabled(enabled);
        this.m_matchTM.setEnabled(enabled);
        this.m_matchSource.setEnabled(enabled);
        this.m_groupSize.setEnabled(enabled && this.m_matchSource.isSelected());
        this.m_TMpath.setEnabled(enabled && this.m_matchTM.isSelected());
    }

    @Override
    public void displaySearchResult(Collection<SearchResultEntry> entries) {
        this.groupPopupMenuListener.entries = new ArrayList<SearchResultEntry>(entries);
        super.displaySearchResult(entries);
    }

    @Override
    public Box wherePanel() {
        return null;
    }

    @Override
    protected String[] getFormatVariablesList() {
        if (this.m_translateMatch.isSelected() && this.m_matchSource.isSelected()) {
            return new String[]{"${preamble}", "${groupCount}", "${allSources}"};
        }
        return new String[]{"${preamble}", "${creationId}", "${creationDate}", "${sourceText}", "${targetText}", "${note}", "${preTranslation}", "${fileName}", "${fileNameOnly}", "${filePath}", "${fileShortPath}"};
    }

    @Override
    protected String getFormatOptionName() {
        if (this.m_translateMatch.isSelected() && this.m_matchSource.isSelected()) {
            return "search_window_template_pretra_src";
        }
        return "search_window_template_pretra";
    }

    @Override
    protected String getFormatOptionDefaultValue() {
        if (this.m_translateMatch.isSelected() && this.m_matchSource.isSelected()) {
            return SearchVarExpansion.DEFAULT_TEMPLATE_PRETRA_SRC;
        }
        return "${preamble}\n${sourceText}\n${preTranslation}\n\n-----------------------\n";
    }

    @Override
    protected ProjectSearcher buildSearcher(Searcher prev) {
        TextExpression sourceExpression = this.m_searchField.getSelectedItem().toString().trim().length() == 0 ? new TextExpression(){

            @Override
            public List<SearchMatch> searchString(String text) {
                return new ArrayList<SearchMatch>();
            }

            @Override
            public boolean matchesString(String text) {
                return true;
            }

            @Override
            public TextExpression asVariableKeeper() {
                return this;
            }

            @Override
            public boolean isVariableKeeper() {
                return true;
            }

            @Override
            public TextExpression rebuildForVariables(String[] vars) {
                return this;
            }

            @Override
            public boolean hasVariables() {
                return false;
            }
        } : (this.m_translateText.isSelected() ? this.m_modePanel.buildReplaceExpression(this.m_searchField.getSelectedItem().toString(), true, this.m_translateField.getSelectedItem().toString(), this.m_translateTxtRegex.isSelected()) : this.m_modePanel.buildExpression(this.m_searchField.getSelectedItem().toString(), false, true));
        if (this.m_translateMatch.isSelected() && this.m_matchSource.isSelected()) {
            return new CrossSourceSearcher(Core.getProject(), this, (Integer)this.m_numberOfResults.getValue(), Integer.parseInt(this.m_groupSize.getValue().toString()), sourceExpression, this.buildTranslationStateFilter(), (NearString.SORT_KEY)((Object)this.m_scoreSelector.getSelectedItem()), Integer.parseInt(this.m_minScore.getValue().toString()), this.m_authorField.isUsed() ? this.m_modePanel.buildExpression(this.m_authorField.getValue(), this.m_authorField.isNot(), false) : null, this.m_dateFrom.isUsed() ? this.m_dateFrom.getValue().getTime() : Long.MAX_VALUE, this.m_dateTo.isUsed() ? this.m_dateTo.getValue().getTime() : Long.MIN_VALUE);
        }
        IMachineTranslation translator = null;
        if (this.m_translateSource.isSelected()) {
            translator = new SourceTranslate(this.m_translateSrcGlos.isSelected(), this.m_translateSrcGlosOnly.isSelected());
        }
        if (this.m_translateAuto.isSelected()) {
            translator = (IMachineTranslation)this.m_preferredMt.getSelectedItem();
        }
        PreTranslateSearcher res = new PreTranslateSearcher(Core.getProject(), this, (Integer)this.m_numberOfResults.getValue(), this.m_transAsAlternative.isSelected(), sourceExpression, this.buildTranslationStateFilter(), translator, this.m_prefixField.getText(), this.m_authorField.isUsed() ? this.m_modePanel.buildExpression(this.m_authorField.getValue(), this.m_authorField.isNot(), false) : null, this.m_dateFrom.isUsed() ? this.m_dateFrom.getValue().getTime() : Long.MAX_VALUE, this.m_dateTo.isUsed() ? this.m_dateTo.getValue().getTime() : Long.MIN_VALUE);
        try {
            res.startAt(((PreTranslateSearcher)prev).projectEntries());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_translateMatch.isSelected()) {
            res.setTranslator(res.buildTranslationMemoriesPreTranslator((NearString.SORT_KEY)((Object)this.m_scoreSelector.getSelectedItem()), Integer.parseInt(this.m_minScore.getValue().toString()), this.m_TMpath.getText().trim().length() == 0 ? null : this.m_TMpath.getText().trim()));
        }
        if (this.m_translateText.isSelected()) {
            byte mode = this.m_translateTxtEntire.isSelected() ? (byte)0 : (this.m_translateTxtWhole.isSelected() ? (byte)1 : 2);
            res.setTranslator(res.buildReplacerPreTranslator(this.m_translateField.getSelectedItem().toString(), mode, this.m_translateTxtRegex.isSelected()));
        }
        if (this.m_translateSource.isSelected() && this.m_translateSrcFound.isSelected()) {
            res.setTranslator(res.buildReplacerPreTranslator("$^1", (byte)0, true));
        }
        return res;
    }

    private TranslationStateFilter buildTranslationStateFilter() {
        return this.m_searchTranslated.isSelected() ? TranslationStateFilter.TRANSLATED_ONLY : (this.m_searchUntranslated.isSelected() ? TranslationStateFilter.UNTRANSLATED_ONLY : TranslationStateFilter.TRANSLATED_AND_UNTRANSLATED);
    }

    @Override
    protected JComponent[] componentsEnabledWhenResults() {
        if (this.m_translateMatch.isSelected() && this.m_matchSource.isSelected()) {
            return new JComponent[0];
        }
        return new JComponent[]{this.m_translateInt, this.m_translateAll};
    }

    @Override
    protected JTextComponent[] textFieldsList() {
        return new JTextComponent[]{(JTextComponent)this.m_searchField.getEditor().getEditorComponent(), (JTextComponent)this.m_translateField.getEditor().getEditorComponent()};
    }

    public String getIntroText() {
        return OStrings.getString("SW_VIEWER_TEXT_PRETRA_1");
    }

    @Override
    protected void loadAdvancedOptionPreferences() {
        super.loadAdvancedOptionPreferences();
        this.m_translateTxtRegex.setSelected(Preferences.isPreferenceDefault("search_window_pretra_withVars", true));
        String replMode = Preferences.getPreferenceDefault("search_window_pretra_txt_mode", PRETRA_ONLY_TEXT);
        this.m_translateTxtEntire.setSelected(replMode.equals(PRETRA_ONLY_TEXT));
        this.m_translateTxtFound.setSelected(replMode.equals(PRETRA_COPY_EXACT));
        this.m_translateTxtWhole.setSelected(replMode.equals(PRETRA_COPY_WHOLE));
        replMode = Preferences.getPreferenceDefault("search_window_pretra_src_mode", PRETRA_SRC_FULL);
        this.m_translateSrcEntire.setSelected(!replMode.equals(PRETRA_SRC_FOUND));
        this.m_translateSrcFound.setSelected(replMode.equals(PRETRA_SRC_FOUND));
        this.m_translateSrcGlos.setSelected(Preferences.isPreferenceDefault("search_window_pretra_withGlos", false));
        this.m_translateSrcGlosOnly.setSelected(Preferences.isPreferenceDefault("search_window_pretra_withGlosOnly", false));
        this.m_translateSrcGlosOnly.setEnabled(this.m_translateSrcGlos.isSelected());
        String searchState = Preferences.getPreferenceDefault("search_window_pretra_state", "UNTRANSLATED");
        this.m_searchTranslated.setSelected(TranslationStateFilter.TRANSLATED_ONLY.toString().equals(searchState));
        this.m_searchUntranslated.setSelected(TranslationStateFilter.UNTRANSLATED_ONLY.toString().equals(searchState));
        this.m_searchTranslatedUntranslated.setSelected(TranslationStateFilter.TRANSLATED_AND_UNTRANSLATED.toString().equals(searchState));
        String replaceType = Preferences.getPreferenceDefault("search_window_pretra_type", PRETRA_TYPE_TEXT);
        this.m_translateSource.setSelected(replaceType.equals(PRETRA_TYPE_SOURCE));
        this.m_translateText.setSelected(replaceType.equals(PRETRA_TYPE_TEXT));
        this.m_translateMatch.setSelected(replaceType.equals(PRETRA_TYPE_MATCH));
        this.m_translateAuto.setSelected(replaceType.equals(PRETRA_TYPE_AUTO));
        for (ActionListener al : this.m_translateText.getActionListeners()) {
            al.actionPerformed(null);
        }
        if (this.m_translateAuto.isSelected()) {
            this.m_prefixField.setText("[MT]");
        } else {
            this.m_prefixField.setText("");
        }
        switch (Preferences.getPreferenceDefault("search_window_match_criteria", NearString.SORT_KEY.SCORE.toString())) {
            case "SCORE": {
                this.m_scoreSelector.setSelectedItem((Object)NearString.SORT_KEY.SCORE);
                break;
            }
            case "SCORE_NO_STEM": {
                this.m_scoreSelector.setSelectedItem((Object)NearString.SORT_KEY.SCORE_NO_STEM);
                break;
            }
            case "ADJUSTED_SCORE": {
                this.m_scoreSelector.setSelectedItem((Object)NearString.SORT_KEY.ADJUSTED_SCORE);
            }
        }
        this.m_matchTM.setSelected("TM".equals(Preferences.getPreferenceDefault("search_window_match_in", "TM")));
        this.m_matchSource.setSelected("SRC".equals(Preferences.getPreferenceDefault("search_window_match_in", "TM")));
        this.setMatchEnabled(this.m_translateMatch.isSelected());
        this.m_minScore.setEnabled(this.m_translateMatch.isSelected());
        this.m_scoreSelector.setEnabled(this.m_translateMatch.isSelected());
        try {
            this.m_minScore.setValue(this.m_matchTM.isSelected() ? Preferences.getPreferenceDefault("search_window_match_score", 80) : Preferences.getPreferenceDefault("search_window_match_score_xsrc", 30));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        Preferences.setPreference("search_window_pretra_withVars", Boolean.toString(this.m_translateTxtRegex.isSelected()));
        if (this.m_translateTxtEntire.isSelected()) {
            Preferences.setPreference("search_window_pretra_txt_mode", PRETRA_ONLY_TEXT);
        } else if (this.m_translateTxtFound.isSelected()) {
            Preferences.setPreference("search_window_pretra_txt_mode", PRETRA_COPY_EXACT);
        } else if (this.m_translateTxtWhole.isSelected()) {
            Preferences.setPreference("search_window_pretra_txt_mode", PRETRA_COPY_WHOLE);
        }
        Preferences.setPreference("search_window_pretra_withGlos", Boolean.toString(this.m_translateSrcGlos.isSelected()));
        Preferences.setPreference("search_window_pretra_withGlosOnly", Boolean.toString(this.m_translateSrcGlosOnly.isSelected()));
        if (this.m_translateSrcFound.isSelected()) {
            Preferences.setPreference("search_window_pretra_src_mode", PRETRA_SRC_FOUND);
        } else {
            Preferences.setPreference("search_window_pretra_src_mode", PRETRA_SRC_FULL);
        }
        if (this.m_translateSource.isSelected()) {
            Preferences.setPreference("search_window_pretra_type", PRETRA_TYPE_SOURCE);
        } else if (this.m_translateText.isSelected()) {
            Preferences.setPreference("search_window_pretra_type", PRETRA_TYPE_TEXT);
        } else if (this.m_translateMatch.isSelected()) {
            Preferences.setPreference("search_window_pretra_type", PRETRA_TYPE_MATCH);
        } else if (this.m_translateAuto.isSelected()) {
            Preferences.setPreference("search_window_pretra_type", PRETRA_TYPE_AUTO);
        }
        Preferences.setPreference("search_window_pretra_state", this.buildTranslationStateFilter().toString());
        Preferences.setPreference(this.m_matchSource.isSelected() ? "search_window_match_score_xsrc" : "search_window_match_score", this.m_minScore.getValue().toString());
        Preferences.setPreference("search_window_match_criteria", this.m_scoreSelector.getSelectedItem().toString());
        Preferences.setPreference("search_window_match_in", this.m_matchSource.isSelected() ? "SRC" : "TM");
        Preferences.save();
    }

    static {
        for (String field : new String[]{"SW_SEARCH_TEXT", "SW_REPLACE_BY"}) {
            for (String mode : new String[]{PRETRA_COPY_EXACT, "KEYWORD", "REGEXP"}) {
                theMap.put(field + ":" + mode, new TreeSet());
            }
        }
        CoreEvents.registerProjectChangeListener(new SearchWindow.SearchesLoader<Set<String>>("PreTranslateDialog", theMap));
    }

    class GroupPopupMenuListener
    extends MouseAdapter {
        public List<SearchResultEntry> entries;

        GroupPopupMenuListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!PreTranslateDialog.this.m_matchSource.isSelected()) {
                this.displaySaveMenu(e);
                return;
            }
            List<Integer> offset = PreTranslateDialog.this.m_viewer.getOffsetList();
            if (offset == null) {
                return;
            }
            if (offset.size() == 0) {
                return;
            }
            if (e.isPopupTrigger() || e.getButton() == 3) {
                int mousepos = PreTranslateDialog.this.m_viewer.viewToModel(e.getPoint());
                for (int i = 0; i < offset.size(); ++i) {
                    if (mousepos >= offset.get(i)) continue;
                    this.displayMatchMenu(i, e);
                    return;
                }
            }
        }

        private void displayMatchMenu(int entryNum, MouseEvent event) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(OStrings.getString("SW_PRETRA_MATCH_MENU_FILTER"));
            menuItem.addActionListener(e -> {
                Core.getEditor().commitAndLeave();
                Core.getEditor().setFilter(new CrossSourceFilter((CrossSourceSearcher)PreTranslateDialog.this.m_thread, entryNum));
            });
            popup.add(menuItem);
            popup.show(PreTranslateDialog.this.m_viewer, event.getX(), event.getY());
        }

        private void displaySaveMenu(MouseEvent event) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(OStrings.getString("SW_PRETRA_MENU_SAVE"));
            menuItem.addActionListener(e -> {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter("TMX", "tmx"));
                if (chooser.showSaveDialog(Core.getMainWindow().getApplicationFrame()) == 0) {
                    try {
                        SearchVarExpansion sve = new SearchVarExpansion(Core.getProject().getProjectProperties(), "${preTranslation}");
                        TMXWriter2 writer = new TMXWriter2(chooser.getSelectedFile(), Core.getProject().getProjectProperties().getSourceLanguage(), Core.getProject().getProjectProperties().getTargetLanguage(), true, true, true);
                        for (SearchResultEntry entry : this.entries) {
                            ArrayList<String> props = new ArrayList<String>(entry.getProperties() == null ? 0 : entry.getProperties().size() * 2);
                            for (TMXProp p : entry.getProperties()) {
                                props.add(p.getType());
                                props.add(p.getValue());
                            }
                            writer.writeEntry(entry.getSrcText(), sve.apply(entry), entry.getNote(), entry.getAuthor(), entry.getDate().getTime(), "", 0L, props);
                        }
                        writer.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            popup.add(menuItem);
            popup.show(PreTranslateDialog.this.m_viewer, event.getX(), event.getY());
        }
    }
}

