/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectOptions;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.FullProjectSearchWindow;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.openide.awt.Mnemonics;

public abstract class ProjectSearchWindow
extends SearchWindow {
    public static final Set<String> L_AUTHORS = new TreeSet<String>();
    public static final Set<String> L_TRANSLATORS = new TreeSet<String>();
    private JCheckBox auto;
    private JCheckBox returnInitial;
    protected MemoryTextField m_authorField;
    protected MemoryTextField m_translatorField;
    protected DateField m_dateFrom;
    protected DateField m_dateTo;
    private SimpleDateFormat m_dateFormat;
    private static final String SAVED_DATE_FORMAT = "yyyy/MM/dd HH:mm";

    public ProjectSearchWindow(MainWindow par, String startText) {
        super(par, startText);
        this.addWindowListener(new WindowAdapter(){
            private final int initialEntry = Core.getEditor().getCurrentEntryNumber();
            private final IEditor.CaretPosition initialCaret = Core.getEditor().getCurrentPositionInEntryTranslationInEditor();

            @Override
            public void windowClosed(WindowEvent e) {
                ProjectSearchWindow.this.savePreferences();
                if (ProjectSearchWindow.this.m_thread != null) {
                    ProjectSearchWindow.this.m_thread.fin();
                }
                int currentEntry = Core.getEditor().getCurrentEntryNumber();
                if (this.initialEntry > 0 && ProjectSearchWindow.this.returnInitial.isSelected() && this.initialEntry != currentEntry) {
                    IEditorFilter filter = Core.getEditor().getFilter();
                    if (filter == null || filter.allowed(Core.getProject().getAllEntries().get(this.initialEntry - 1))) {
                        ((EditorController)Core.getEditor()).gotoEntry(this.initialEntry, this.initialCaret);
                    } else {
                        Core.getEditor().gotoEntry(this.initialEntry);
                    }
                }
            }
        });
    }

    @Override
    protected Box buttonsPanel() {
        Box bCB = Box.createHorizontalBox();
        this.auto = new JCheckBox();
        bCB.add(this.auto);
        Mnemonics.setLocalizedText(this.auto, OStrings.getString("SW_AUTO_SYNC"));
        this.auto.setSelected(Preferences.isPreferenceDefault("search_window_auto_sync", false));
        this.auto.addActionListener(e -> this.m_viewer.setAutoSyncWithEditor(this.auto.isSelected()));
        this.returnInitial = new JCheckBox();
        bCB.add(this.returnInitial);
        Mnemonics.setLocalizedText(this.returnInitial, OStrings.getString("SW_BACK_TO_INITIAL_SEGMENT"));
        this.returnInitial.setSelected(Preferences.isPreferenceDefault("search_window_back_to_initial_segment", false));
        JButton m_dismissButton = new JButton();
        Mnemonics.setLocalizedText(m_dismissButton, OStrings.getString("BUTTON_CLOSE"));
        bCB.add(m_dismissButton);
        m_dismissButton.addActionListener(this.getRootPane().getActionMap().get("ESCAPE"));
        return bCB;
    }

    @Override
    protected String[] getFormatVariablesList() {
        return new String[]{"${preamble}", "${creationId}", "${creationDate}", "${sourceText}", "${targetText}", "${note}", "@{revisor}", "${fileName}", "${fileNameOnly}", "${filePath}", "${fileShortPath}"};
    }

    @Override
    protected String getFormatOptionName() {
        return "search_window_template_project";
    }

    @Override
    protected String getFormatOptionDefaultValue() {
        return "${preamble}\n${sourceText}\n${targetText}\n\n-----------------------\n";
    }

    @Override
    protected JComponent advancedPanel() {
        Box advBox = (Box)super.advancedPanel();
        this.m_dateFormat = new SimpleDateFormat(SAVED_DATE_FORMAT);
        this.m_authorField = new MemoryTextField("SW_AUTHOR", true, L_AUTHORS);
        this.m_translatorField = new MemoryTextField("SW_TRANSLATOR", true, L_TRANSLATORS);
        Box bDB = Box.createHorizontalBox();
        this.m_dateFrom = new DateField("SW_CHANGED_AFTER");
        bDB.add(this.m_dateFrom);
        bDB.add(Box.createHorizontalStrut(10));
        bDB.add(Box.createHorizontalGlue());
        this.m_dateTo = new DateField("SW_CHANGED_BEFORE");
        bDB.add(this.m_dateTo);
        Box bAuthors = Box.createHorizontalBox();
        advBox.add(bAuthors);
        bAuthors.add(this.m_authorField);
        if (this instanceof FullProjectSearchWindow) {
            bAuthors.add(this.m_translatorField);
        }
        advBox.add(bDB);
        return advBox;
    }

    @Override
    protected void loadAdvancedOptionPreferences() {
        super.loadAdvancedOptionPreferences();
        String searchAuthor = Preferences.getPreference("search_window_search_author");
        if (StringUtil.isEmpty(searchAuthor)) {
            searchAuthor = "false";
        }
        this.m_authorField.setOpen(Boolean.valueOf(searchAuthor));
        String authorName = Preferences.getPreference("search_window_author_name");
        if (!StringUtil.isEmpty(authorName)) {
            this.m_authorField.setValue(authorName);
        }
        if (StringUtil.isEmpty(searchAuthor = Preferences.getPreference("search_window_search_translator"))) {
            searchAuthor = "false";
        }
        this.m_translatorField.setOpen(Boolean.valueOf(searchAuthor));
        authorName = Preferences.getPreference("search_window_search_translator_name");
        if (!StringUtil.isEmpty(authorName)) {
            this.m_translatorField.setValue(authorName);
        }
        try {
            String dateTo;
            String dateFrom = Preferences.getPreference("search_window_date_from");
            if (StringUtil.isEmpty(dateFrom)) {
                dateFrom = "false";
            }
            this.m_dateFrom.setOpen(Boolean.valueOf(dateFrom));
            String dateFromValue = Preferences.getPreference("search_window_date_from_value");
            if (!StringUtil.isEmpty(dateFromValue)) {
                this.m_dateFrom.setValue(this.m_dateFormat.parse(dateFromValue));
            }
            if (StringUtil.isEmpty(dateTo = Preferences.getPreference("search_window_date_to"))) {
                dateTo = "false";
            }
            this.m_dateTo.setOpen(Boolean.valueOf(dateTo));
            String dateToValue = Preferences.getPreference("search_window_date_to_value");
            if (!StringUtil.isEmpty(dateToValue)) {
                this.m_dateTo.setValue(this.m_dateFormat.parse(dateToValue));
            }
        }
        catch (ParseException e) {
            this.m_dateFrom.setOpen(false);
            this.m_dateTo.setOpen(false);
        }
        if (this.m_authorField.isOpen() || this.m_translatorField.isOpen() || this.m_dateFrom.isOpen() || this.m_dateTo.isOpen()) {
            this.m_advancedVisible = true;
        }
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        Preferences.setPreference("search_window_search_author", Boolean.toString(this.m_authorField.isOpen()));
        Preferences.setPreference("search_window_author_name", this.m_authorField.getValue());
        Preferences.setPreference("search_window_search_translator", Boolean.toString(this.m_translatorField.isOpen()));
        Preferences.setPreference("search_window_search_translator_name", this.m_translatorField.getValue());
        Preferences.setPreference("search_window_date_from", Boolean.toString(this.m_dateFrom.isOpen()));
        Preferences.setPreference("search_window_date_from_value", this.m_dateFormat.format(this.m_dateFrom.m_dateModel.getDate()));
        Preferences.setPreference("search_window_date_to", Boolean.toString(this.m_dateTo.isOpen()));
        Preferences.setPreference("search_window_date_to_value", this.m_dateFormat.format(this.m_dateTo.m_dateModel.getDate()));
        Preferences.save();
    }

    @Override
    protected ProjectOptions getOptions() {
        return Core.getProject().getProjectProperties();
    }

    class DateField
    extends EnableField<Box, Date> {
        private JButton m_nowButton;
        private JSpinner m_spinner;
        private SpinnerDateModel m_dateModel;

        public DateField(String checkLabel) {
            super(ProjectSearchWindow.this, checkLabel, (JComponent)Box.createHorizontalBox(), false);
            Calendar calendar = Calendar.getInstance();
            Date initDate = calendar.getTime();
            calendar.add(1, -100);
            Date earliestDate = calendar.getTime();
            Date latestDate = initDate;
            this.m_dateModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
            this.m_spinner = new JSpinner(this.m_dateModel);
            ((Box)this.component).add(this.m_spinner);
            this.m_nowButton = new JButton();
            ((Box)this.component).add(this.m_nowButton);
            Mnemonics.setLocalizedText(this.m_nowButton, OStrings.getString("SW_NOW"));
            this.m_nowButton.addActionListener(e -> {
                Date now = Calendar.getInstance().getTime();
                this.m_dateModel.setEnd(now);
                this.m_dateModel.setValue(now);
            });
        }

        @Override
        protected void enableComponent(boolean value) {
            super.enableComponent(value);
            this.m_spinner.setEnabled(value);
            this.m_nowButton.setEnabled(value);
        }

        @Override
        public Date getValue() {
            return this.m_dateModel.getDate();
        }

        @Override
        public void setValue(Date d) {
            this.m_dateModel.setValue(d);
        }
    }

    class MemoryTextField
    extends EnableField<JComboBox, String> {
        private SearchWindow.SetRef valuesSet;

        public MemoryTextField(String checkLabel, boolean canAll, Set<String> values_set) {
            super(ProjectSearchWindow.this, checkLabel, new JComboBox(), canAll);
            this.valuesSet = new SearchWindow.SetRef(values_set);
            for (String item : this.valuesSet.theSet) {
                ((JComboBox)this.component).addItem(SearchModeBox.MemorizedExpression.forString(item));
            }
            ((JComboBox)this.component).setEditable(true);
            ((JComboBox)this.component).getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() == '\n' && ProjectSearchWindow.this.m_viewer != null) {
                        ProjectSearchWindow.this.doSearch(false);
                    }
                }
            });
            ((JComboBox)this.component).addActionListener(ev -> {
                try {
                    SearchModeBox.MemorizedExpression item = (SearchModeBox.MemorizedExpression)((JComboBox)this.component).getSelectedItem();
                    item.applyTo(ProjectSearchWindow.this.m_modePanel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.add(ProjectSearchWindow.this.createMemorizeButton(ProjectSearchWindow.this.getY(), canAll, (JComboBox)this.component, null, checkLabel, this.valuesSet));
        }

        @Override
        protected void enableComponent(boolean value) {
            ((JComboBox)this.component).setEnabled(value);
            super.enableComponent(value);
        }

        @Override
        public boolean isUsed() {
            return super.isUsed() && this.getValue().trim().length() > 0;
        }

        @Override
        public String getValue() {
            Object item = ((JComboBox)this.component).getSelectedItem();
            if (item == null) {
                return "";
            }
            return item.toString();
        }

        @Override
        public void setValue(String text) {
            ((JComboBox)this.component).setSelectedItem(text);
        }

        JComboBox getTextField() {
            return (JComboBox)this.component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeValuesSet(Set<String> newValuesSet, boolean removeContents) {
            this.valuesSet.theSet = newValuesSet;
            JComboBox jComboBox = (JComboBox)this.component;
            synchronized (jComboBox) {
                String selectedItem = removeContents ? "" : ((JComboBox)this.component).getSelectedItem();
                ((JComboBox)this.component).removeAllItems();
                ((JComboBox)this.component).addItem(selectedItem);
                for (String item : newValuesSet) {
                    ((JComboBox)this.component).addItem(SearchModeBox.MemorizedExpression.forString(item));
                }
                ((JComboBox)this.component).setSelectedItem(selectedItem);
            }
        }
    }

    abstract class EnableField<Display extends JComponent, Value>
    extends Box {
        protected JCheckBox check;
        protected JCheckBox not;
        protected JComboBox fieldList;
        protected Display component;
        final /* synthetic */ ProjectSearchWindow this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public EnableField(String checkLabel, Display theComponent, boolean hasNot) {
            this.this$0 = (ProjectSearchWindow)this$0;
            super(0);
            this.not = null;
            this.fieldList = null;
            this.check = new JCheckBox();
            if (checkLabel.contains("|")) {
                this.fieldList = new JComboBox();
                this.fieldList.setRenderer(new DelegatingComboBoxRenderer<String>((ProjectSearchWindow)this$0){
                    final /* synthetic */ ProjectSearchWindow val$this$0;
                    {
                        this.val$this$0 = projectSearchWindow;
                    }

                    @Override
                    protected Object getDisplayText(String key) {
                        return OStrings.getString(key).trim();
                    }
                });
                for (String label : checkLabel.split("\\|")) {
                    this.fieldList.addItem(label);
                }
                this.fieldList.setMaximumSize(new Dimension(100, this.fieldList.getPreferredSize().height));
            } else {
                Mnemonics.setLocalizedText(this.check, OStrings.getString(checkLabel));
            }
            this.component = theComponent;
            this.add(this.check);
            if (this.fieldList != null) {
                this.add(this.fieldList);
            }
            if (hasNot) {
                this.not = new JCheckBox(OStrings.getString("SW_SEARCH_NOT"));
                this.add(this.not);
            }
            this.add((Component)this.component);
            this.check.addActionListener(e -> {
                boolean editable = this.check.isSelected();
                this.enableComponent(editable);
                if (editable) {
                    ((JComponent)this.component).requestFocus();
                } else {
                    this.this$0.getMainSearchTextField().requestFocus();
                }
            });
        }

        public boolean isNot() {
            if (this.not == null) {
                return false;
            }
            return this.not.isSelected();
        }

        public boolean isUsed() {
            return this.isOpen();
        }

        public final boolean isOpen() {
            return this.check.isSelected();
        }

        public void setOpen(boolean value) {
            this.check.setSelected(value);
            this.enableComponent(value);
        }

        public Value getNullableValue() {
            if (this.isUsed()) {
                return this.getValue();
            }
            return null;
        }

        protected void enableComponent(boolean value) {
            if (this.not != null) {
                this.not.setEnabled(value);
            }
        }

        public final String getSelectedField() {
            if (this.fieldList == null) {
                return null;
            }
            return this.fieldList.getSelectedItem().toString();
        }

        public abstract Value getValue();

        public abstract void setValue(Value var1);
    }
}

