/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"fi"}, isDefault=true)
public class LuceneFinnishTokenizer
extends BaseTokenizer {
    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) {
        if (stemsAllowed) {
            Set stopWords = stopWordsAllowed ? FinnishAnalyzer.getDefaultStopSet() : Collections.emptySet();
            return new FinnishAnalyzer(this.getBehavior(), stopWords).tokenStream("", (Reader)new StringReader(strOrig));
        }
        return new StandardTokenizer(this.getBehavior(), (Reader)new StringReader(strOrig));
    }

    @Override
    public Analyzer getGlossaryAnalyser() {
        Set stopWords = FinnishAnalyzer.getDefaultStopSet();
        return new FinnishAnalyzer(this.getBehavior(), stopWords);
    }
}

