/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiMap<K, V> {
    Map<K, Set<V>> map;

    public MultiMap() {
        this.map = new HashMap<K, Set<V>>();
    }

    public MultiMap(boolean sorted) {
        this.map = sorted ? new TreeMap() : new HashMap();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Iterable<V> values() {
        return () -> new Iterator<V>(){
            final Iterator keyIterator;
            Iterator valIterator;
            {
                this.keyIterator = MultiMap.this.map.keySet().iterator();
                this.valIterator = null;
            }

            @Override
            public boolean hasNext() {
                return this.valIterator != null && this.valIterator.hasNext() || this.keyIterator.hasNext();
            }

            @Override
            public V next() {
                if (this.valIterator == null) {
                    this.valIterator = MultiMap.this.map.get(this.keyIterator.next()).iterator();
                }
                if (this.valIterator.hasNext()) {
                    return this.valIterator.next();
                }
                this.valIterator = MultiMap.this.map.get(this.keyIterator.next()).iterator();
                return this.next();
            }

            @Override
            public void remove() {
                this.valIterator.remove();
            }
        };
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsPair(K key, V value) {
        if (this.containsKey(key)) {
            Set<V> values = this.map.get(key);
            return values.contains(value);
        }
        return false;
    }

    public void put(K key, V value) {
        if (this.containsKey(key)) {
            Set<V> values = this.map.get(key);
            values.add(value);
        } else {
            HashSet<V> values = new HashSet<V>();
            values.add(value);
            this.map.put(key, values);
        }
    }

    public void remove(Object key) {
        this.map.remove(key);
    }
}

