/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.omegat.gui.common.OmegaTIcons;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class OmegaTFileChooser
extends JFileChooser {
    private static ImageIcon omegatIcon = null;

    public OmegaTFileChooser() {
        this(Preferences.getPreference("current_folder"));
    }

    public OmegaTFileChooser(String path) {
        super(path);
        try {
            if (omegatIcon == null) {
                omegatIcon = new ImageIcon(OmegaTIcons.ICONS.get(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Icon getIcon(File f) {
        if (StaticUtils.isProjectDir(f) && omegatIcon != null) {
            return omegatIcon;
        }
        return super.getIcon(f);
    }

    @Override
    public String getTypeDescription(File f) {
        if (StaticUtils.isProjectDir(f)) {
            return OStrings.getString("PFC_OMEGAT_PROJECT");
        }
        return super.getTypeDescription(f);
    }
}

