/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class OmegaTLogFormatter
extends Formatter {
    protected static String lineMark;
    protected static String lineSeparator;
    private String logMask;
    private boolean isMaskContainsMark;
    private boolean isMaskContainsThreadName;
    private boolean isMaskContainsLevel;
    private boolean isMaskContainsText;
    private boolean isMaskContainsKey;
    private boolean isMaskContainsLoggerName;
    private boolean isMaskContainsTime;
    private String defaultTimeFormat = "HH:mm:ss";
    private ThreadLocal<SimpleDateFormat> timeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(OmegaTLogFormatter.this.defaultTimeFormat);
        }
    };

    public OmegaTLogFormatter() {
        String timeFormat;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.logMask = manager.getProperty(cname + ".mask");
        if (this.logMask == null) {
            this.logMask = "$mark: $level: $text $key";
        }
        if ((timeFormat = manager.getProperty(cname + ".timeFormat")) != null) {
            this.defaultTimeFormat = timeFormat;
        }
        this.isMaskContainsKey = this.logMask.contains("$key");
        this.isMaskContainsLevel = this.logMask.contains("$level");
        this.isMaskContainsMark = this.logMask.contains("$mark");
        this.isMaskContainsTime = this.logMask.contains("$time");
        this.isMaskContainsText = this.logMask.contains("$text");
        this.isMaskContainsThreadName = this.logMask.contains("$threadName");
        this.isMaskContainsLoggerName = this.logMask.contains("$loggerName");
    }

    @Override
    public String format(LogRecord record) {
        String[] lines;
        String format;
        StringBuilder result = new StringBuilder();
        if (record.getResourceBundle() != null) {
            try {
                format = record.getResourceBundle().getString(record.getMessage());
            }
            catch (Exception ex) {
                format = record.getMessage();
            }
        } else {
            format = record.getMessage();
        }
        if (format == null) {
            format = "null";
        }
        String message = record.getParameters() == null ? format : StringUtil.format(format, record.getParameters());
        for (String line : lines = message.split("\r|\n")) {
            this.appendFormattedLine(result, record, line, false);
        }
        if (record.getThrown() != null) {
            StringWriter stackTrace = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(stackTrace));
            for (String line : stackTrace.toString().split("\r|\n")) {
                this.appendFormattedLine(result, record, line, true);
            }
        }
        return result.toString();
    }

    protected void appendFormattedLine(StringBuilder out, LogRecord record, String line, boolean isStack) {
        if (line.isEmpty()) {
            return;
        }
        String res = this.logMask;
        if (this.isMaskContainsMark) {
            res = res.replace("$mark", lineMark);
        }
        if (this.isMaskContainsTime) {
            res = res.replace("$time", this.timeFormatter.get().format(new Date()));
        }
        if (this.isMaskContainsLoggerName) {
            res = res.replace("$loggerName", record.getLoggerName());
        }
        if (this.isMaskContainsThreadName) {
            res = res.replace("$threadName", Thread.currentThread().getName());
        }
        if (this.isMaskContainsLevel) {
            res = res.replace("$level", this.getLocalizedLevel(record.getLevel()));
        }
        if (this.isMaskContainsText) {
            res = res.replace("$text", line);
        }
        if (this.isMaskContainsKey) {
            res = record.getResourceBundle() != null && !isStack ? res.replace("$key", "(" + record.getMessage() + ")") : res.replace("$key", "");
        }
        out.append(res).append(lineSeparator);
    }

    protected String getLocalizedLevel(Level logLevel) {
        String result = Level.INFO.getName().equals(logLevel.getName()) ? OStrings.getString("LOG_LEVEL_INFO") : (Level.SEVERE.getName().equals(logLevel.getName()) ? OStrings.getString("LOG_LEVEL_SEVERE") : (Level.WARNING.getName().equals(logLevel.getName()) ? OStrings.getString("LOG_LEVEL_WARNING") : logLevel.getName()));
        return result.trim();
    }

    static {
        lineSeparator = System.getProperty("line.separator");
        Random generator = new Random();
        generator.setSeed(System.currentTimeMillis());
        int random = generator.nextInt(Integer.MAX_VALUE);
        String sessionID = String.valueOf(random);
        if (sessionID.length() > 5) {
            sessionID = sessionID.substring(0, 5);
        } else if (sessionID.length() < 5) {
            for (int i = 5; i > sessionID.length(); ++i) {
                sessionID = "0" + sessionID;
            }
        }
        lineMark = sessionID;
    }
}

