/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ws;

import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.ws.WSDockKey;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class WSDesktop {
    private String desktopName;
    private TopLevelNode mainNode = new TopLevelNode();
    private HashMap<WSDockKey, Node> nodesByKey = new HashMap();
    private ArrayList[] borders = new ArrayList[4];
    private ArrayList floatingNodes = new ArrayList();
    private WSDockKey maximizedDockable = null;
    protected HashMap<WSDockKey, LinkedList<WSDockKey>> tabbedGroups = new HashMap();

    public WSDesktop() {
        this("default");
    }

    public WSDesktop(String desktopName) {
        this.desktopName = desktopName;
        int i = 0;
        while (i < this.borders.length) {
            this.borders[i] = new ArrayList();
            ++i;
        }
    }

    public void clear() {
        this.mainNode = new TopLevelNode();
        this.nodesByKey.clear();
        int i = 0;
        while (i < this.borders.length) {
            this.borders[i].clear();
            ++i;
        }
        this.floatingNodes.clear();
        this.maximizedDockable = null;
    }

    public void addDockable(WSDockKey key) {
        if (this.mainNode.child != null) {
            throw new IllegalArgumentException("this workspace isn't empty");
        }
        this.mainNode.setChild(new SingleDockableNode(key));
    }

    public void setMaximizedDockable(WSDockKey max) {
        this.maximizedDockable = max;
    }

    private SingleDockableNode getNode(WSDockKey key) {
        return (SingleDockableNode)this.nodesByKey.get(key);
    }

    public void split(WSDockKey base, WSDockKey newDockable, DockingConstants.Split split, double splitLocation) {
        SingleDockableNode baseNode = this.getNode(base);
        if (baseNode == null) {
            throw new IllegalArgumentException("base dockable not found " + base);
        }
        SplitNode splitNode = new SplitNode();
        this.replaceChild(baseNode.parent, baseNode, splitNode);
        switch (split.value()) {
            case 0: {
                splitNode.setTop(new SingleDockableNode(newDockable));
                splitNode.setBottom(baseNode);
                splitNode.isHorizontal = false;
                break;
            }
            case 1: {
                splitNode.setLeft(new SingleDockableNode(newDockable));
                splitNode.setRight(baseNode);
                splitNode.isHorizontal = true;
                break;
            }
            case 2: {
                splitNode.setBottom(new SingleDockableNode(newDockable));
                splitNode.setTop(baseNode);
                splitNode.isHorizontal = false;
                break;
            }
            case 3: {
                splitNode.setRight(new SingleDockableNode(newDockable));
                splitNode.setLeft(baseNode);
                splitNode.isHorizontal = true;
            }
        }
        splitNode.location = splitLocation;
    }

    public void createTab(WSDockKey baseTab, WSDockKey newTab, int order) {
        SingleDockableNode baseTabNode = this.getNode(baseTab);
        if (baseTabNode == null) {
            throw new IllegalArgumentException("base dockable not found " + baseTab);
        }
        if (baseTabNode.parent instanceof TabNode) {
            TabNode parent = (TabNode)baseTabNode.parent;
            parent.addTab(order, new SingleDockableNode(newTab));
        } else {
            TabNode gParent = new TabNode();
            this.replaceChild(baseTabNode.parent, baseTabNode, gParent);
            gParent.addTab(0, baseTabNode);
            gParent.addTab(order, new SingleDockableNode(newTab));
        }
    }

    public void addDockable(WSDockKey compoundDockable, WSDockKey childDockable) {
        SingleDockableNode node = this.getNode(compoundDockable);
        Node parent = node.parent;
        CompoundDockableNode cnode = new CompoundDockableNode(compoundDockable);
        this.replaceChild(parent, node, cnode);
        cnode.setNestedNode(new SingleDockableNode(childDockable));
    }

    public void addHiddenDockable(WSDockKey dockable, RelativeDockablePosition dockedPosition) {
        int zone = dockable.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : dockable.getAutoHideBorder().value();
        ArrayList border = this.borders[zone];
        border.add(new HiddenNode(new SingleDockableNode(dockable), dockedPosition));
    }

    public void setFloating(WSDockKey dockable, Rectangle windowRect, RelativeDockablePosition returnPosition) {
        FloatingNode f = new FloatingNode(new SingleDockableNode(dockable), windowRect, returnPosition);
        this.floatingNodes.add(f);
    }

    public String getDesktopName() {
        return this.desktopName;
    }

    public void setDesktopName(String name) {
        this.desktopName = name;
    }

    void writeDesktopNode(PrintWriter out) {
        out.println("<DockingDesktop name=\"" + this.desktopName + "\">");
        out.println("<DockingPanel>");
        if (this.mainNode.child != null) {
            this.xmlWriteComponent(this.mainNode.child, out);
        }
        if (this.maximizedDockable != null) {
            out.println("<MaximizedDockable>");
            out.println("<Key dockName=\"" + this.maximizedDockable.getKey() + "\"/>");
            out.println("</MaximizedDockable>");
        }
        out.println("</DockingPanel>");
        int i = 0;
        while (i < this.borders.length) {
            this.xmlWriteBorder(i, this.borders[i], out);
            ++i;
        }
        i = 0;
        while (i < this.floatingNodes.size()) {
            FloatingNode f = (FloatingNode)this.floatingNodes.get(i);
            this.xmlWriteFloating(f, out);
            ++i;
        }
        this.xmlWriteTabGroups(out);
        out.println("</DockingDesktop>");
    }

    private void xmlWriteComponent(Node node, PrintWriter out) {
        if (node instanceof SplitNode) {
            this.xmlWriteSplit((SplitNode)node, out);
        } else if (node instanceof TabNode) {
            this.xmlWriteTab((TabNode)node, out);
        } else if (node instanceof SingleDockableNode) {
            this.xmlWriteDockable((SingleDockableNode)node, out);
        }
    }

    private void xmlWriteSplit(SplitNode splitNode, PrintWriter out) {
        double location = splitNode.location;
        int orientation = splitNode.isHorizontal ? 1 : 0;
        out.println("<Split orientation=\"" + orientation + "\" location=\"" + location + "\">");
        this.xmlWriteComponent(splitNode.getLeft(), out);
        this.xmlWriteComponent(splitNode.getRight(), out);
        out.println("</Split>");
    }

    private void xmlWriteTab(TabNode tabNode, PrintWriter out) {
        out.println("<TabbedDockable>");
        int i = 0;
        while (i < tabNode.tabs.size()) {
            this.xmlWriteDockable(tabNode.getTab(i), out);
            ++i;
        }
        out.println("</TabbedDockable>");
    }

    private void xmlWriteDockable(SingleDockableNode dockable, PrintWriter out) {
        boolean isCompound = dockable instanceof CompoundDockableNode;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        WSDockKey key = dockable.key;
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        if (isCompound) {
            CompoundDockableNode d = (CompoundDockableNode)dockable;
            if (d.nestedNode != null) {
                this.xmlWriteComponent(d.nestedNode, out);
            }
        }
        out.println("</Dockable>");
    }

    private void xmlWriteBorder(int zone, ArrayList border, PrintWriter out) {
        if (border.size() > 0) {
            out.println("<Border zone=\"" + zone + "\">");
            int i = 0;
            while (i < border.size()) {
                HiddenNode node = (HiddenNode)border.get(i);
                this.xmlWriteBorderDockable(node, out);
                ++i;
            }
            out.println("</Border>");
        }
    }

    private void xmlWriteBorderDockable(HiddenNode node, PrintWriter out) {
        RelativeDockablePosition position = node.position;
        SingleDockableNode child = node.node;
        boolean isCompound = child instanceof CompoundDockableNode;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        WSDockKey key = child.key;
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        if (isCompound) {
            CompoundDockableNode d = (CompoundDockableNode)child;
            if (d.nestedNode != null) {
                this.xmlWriteComponent(d.nestedNode, out);
            }
        }
        out.println("</Dockable>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceChild(Node parent, Node child, Node newChild) {
        if (parent instanceof TopLevelNode) {
            TopLevelNode t = (TopLevelNode)parent;
            if (t.child != child) throw new IllegalArgumentException("child not found in top level node " + child);
            t.setChild(newChild);
            return;
        } else if (parent instanceof CompoundDockableNode) {
            CompoundDockableNode c = (CompoundDockableNode)parent;
            if (c.nestedNode != child) throw new IllegalArgumentException("child not found in compound " + child);
            c.setNestedNode(newChild);
            return;
        } else if (parent instanceof SplitNode) {
            SplitNode split = (SplitNode)parent;
            if (split.left == child) {
                split.setLeft(newChild);
                return;
            } else {
                if (split.right != child) throw new IllegalArgumentException("child not found in split " + child);
                split.setRight(newChild);
            }
            return;
        } else {
            if (parent instanceof TabNode) {
                TabNode tab = (TabNode)parent;
                int i = 0;
                while (i < tab.tabs.size()) {
                    SingleDockableNode n = tab.getTab(i);
                    if (n == child) {
                        tab.replaceTab(i, (SingleDockableNode)newChild);
                        throw new IllegalArgumentException("child not found in tabs " + child);
                    }
                    ++i;
                }
                throw new IllegalArgumentException("child not found in tabs " + child);
            }
            if (parent instanceof HiddenNode) {
                HiddenNode h = (HiddenNode)parent;
                if (h.node != child) throw new IllegalArgumentException("child not found in hidden dockable " + child);
                h.setChild((SingleDockableNode)newChild);
                return;
            } else {
                if (!(parent instanceof FloatingNode)) throw new IllegalArgumentException("wrong type for parent " + parent);
                FloatingNode f = (FloatingNode)parent;
                if (f.child != child) throw new IllegalArgumentException("child not found in floating dockable " + child);
                f.setChild(newChild);
            }
        }
    }

    private void xmlWriteFloating(FloatingNode node, PrintWriter out) {
        Rectangle r = node.windowRect;
        out.println("<Floating x=\"" + r.x + "\" y=\"" + r.y + "\" width=\"" + r.width + "\" height=\"" + r.height + "\">");
        if (node.child instanceof TabNode) {
            TabNode tab = (TabNode)node.child;
            int i = 0;
            while (i < tab.tabs.size()) {
                SingleDockableNode n = tab.getTab(i);
                this.xmlWriteFloatingDockable(n, out, node.returnPosition);
                ++i;
            }
        } else {
            this.xmlWriteFloatingDockable((SingleDockableNode)node.child, out, node.returnPosition);
        }
        out.println("</Floating>");
    }

    private void xmlWriteFloatingDockable(SingleDockableNode dockable, PrintWriter out, RelativeDockablePosition returnPosition) {
        boolean isCompound = dockable instanceof CompoundDockableNode;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        WSDockKey key = dockable.key;
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + returnPosition.getX() + "\" y=\"" + returnPosition.getY() + "\" w=\"" + returnPosition.getWidth() + "\" h=\"" + returnPosition.getHeight() + "\" />");
        out.println("<PreviousState state=\"" + DockableState.Location.DOCKED.ordinal() + "\"/>");
        if (isCompound) {
            CompoundDockableNode d = (CompoundDockableNode)dockable;
            if (d.nestedNode != null) {
                this.xmlWriteComponent(d.nestedNode, out);
            }
        }
        out.println("</Dockable>");
    }

    private void xmlWriteTabGroups(PrintWriter out) {
        ArrayList<LinkedList<WSDockKey>> uniqueGroups = new ArrayList<LinkedList<WSDockKey>>();
        ArrayList<WSDockKey> processedDockables = new ArrayList<WSDockKey>();
        for (WSDockKey d : this.tabbedGroups.keySet()) {
            if (processedDockables.contains(d)) continue;
            processedDockables.add(d);
            LinkedList<WSDockKey> tabList = this.tabbedGroups.get(d);
            for (WSDockKey d2 : tabList) {
                if (processedDockables.contains(d2)) continue;
                processedDockables.add(d2);
            }
            uniqueGroups.add(tabList);
        }
        out.println("<TabGroups>");
        int i = 0;
        while (i < uniqueGroups.size()) {
            out.println("<TabGroup>");
            LinkedList group = (LinkedList)uniqueGroups.get(i);
            for (WSDockKey d : group) {
                this.xmlWriteDockableTab(d, out);
            }
            out.println("</TabGroup>");
            ++i;
        }
        out.println("</TabGroups>");
    }

    private void xmlWriteDockableTab(WSDockKey key, PrintWriter out) {
        out.println("<Dockable>");
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("</Dockable>");
    }

    void readDesktopNode(Element root) throws SAXNotRecognizedException, SAXException {
        NodeList children = root.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            org.w3c.dom.Node child = children.item(i);
            this.xmlBuildRootNode(child);
            ++i;
        }
    }

    private void xmlBuildRootNode(org.w3c.dom.Node node) throws SAXNotRecognizedException, SAXException {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            String name = elt.getNodeName();
            if (name.equals("DockingPanel")) {
                NodeList children = elt.getChildNodes();
                int i = 0;
                int len = children.getLength();
                while (i < len) {
                    this.xmlBuildDockingPanelNode(elt.getChildNodes().item(i));
                    ++i;
                }
            } else if (name.equals("Border")) {
                int zone = Integer.parseInt(elt.getAttribute("zone"));
                NodeList children = elt.getElementsByTagName("Dockable");
                int i = 0;
                int len = children.getLength();
                while (i < len) {
                    this.xmlBuildAutoHideNode(zone, (Element)children.item(i));
                    ++i;
                }
            } else if (name.equals("Floating")) {
                int x = Integer.parseInt(elt.getAttribute("x"));
                int y = Integer.parseInt(elt.getAttribute("y"));
                int width = Integer.parseInt(elt.getAttribute("width"));
                int height = Integer.parseInt(elt.getAttribute("height"));
                NodeList children = elt.getElementsByTagName("Dockable");
                this.xmlBuildFloatingNode(children, new Rectangle(x, y, width, height));
            } else if (name.equals("TabGroups")) {
                NodeList children = elt.getElementsByTagName("TabGroup");
                this.xmlBuildTabGroup(children);
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }
    }

    private void xmlBuildDockingPanelNode(org.w3c.dom.Node node) throws SAXException {
        if (node.getNodeType() == 1) {
            Node child = this.xmlCreateComponent((Element)node, DockableState.Location.DOCKED);
            if (node != null) {
                this.mainNode.setChild(child);
            }
        }
    }

    private Node xmlCreateComponent(Element elt, DockableState.Location dockableLocation) throws SAXException {
        if (elt.getNodeName().equals("Split")) {
            SplitNode split = this.xmlBuildSplitContainer(elt, dockableLocation);
            return split;
        }
        if (elt.getNodeName().equals("Dockable")) {
            SingleDockableNode sdc = this.xmlGetDockable(elt);
            if (sdc instanceof CompoundDockableNode) {
                this.xmlBuildCompoundDockable((CompoundDockableNode)sdc, elt, dockableLocation);
            }
            return sdc;
        }
        if (elt.getNodeName().equals("TabbedDockable")) {
            TabNode tdc = this.xmlBuildTabbedDockableContainer(elt, dockableLocation);
            return tdc;
        }
        if (elt.getNodeName().equals("MaximizedDockable")) {
            SingleDockableNode sdc = this.xmlGetDockable(elt);
            this.setMaximizedDockable(sdc.key);
            return null;
        }
        throw new SAXNotRecognizedException(elt.getNodeName());
    }

    private SingleDockableNode xmlGetDockable(Element dockableElt) {
        Element key = (Element)dockableElt.getElementsByTagName("Key").item(0);
        String name = key.getAttribute("dockName");
        WSDockKey wsKey = new WSDockKey(name);
        SingleDockableNode sdn = (SingleDockableNode)this.nodesByKey.get(wsKey);
        if (sdn == null) {
            String compound = dockableElt.getAttribute("compound");
            sdn = "true".equals(compound) ? new CompoundDockableNode(wsKey) : new SingleDockableNode(wsKey);
        }
        return sdn;
    }

    private void xmlBuildCompoundDockable(CompoundDockableNode cdn, Element elt, DockableState.Location dockableLocation) throws SAXException {
        NodeList children = elt.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            org.w3c.dom.Node node = children.item(i);
            if (node.getNodeType() == 1 && !elt.getNodeName().equals("Key")) {
                Node comp;
                cdn.nestedNode = comp = this.xmlCreateComponent(elt, dockableLocation);
                return;
            }
            ++i;
        }
    }

    private SplitNode xmlBuildSplitContainer(Element elt, DockableState.Location dockableLocation) throws SAXException {
        int orientation = Integer.parseInt(elt.getAttribute("orientation"));
        String loc = elt.getAttribute("location");
        double location = 0.5;
        if (loc != null && !loc.equals("")) {
            location = Double.parseDouble(loc);
        }
        SplitNode split = new SplitNode();
        split.isHorizontal = orientation == 1;
        split.location = location;
        boolean left = true;
        int i = 0;
        while (i < elt.getChildNodes().getLength()) {
            org.w3c.dom.Node child = elt.getChildNodes().item(i);
            if (child.getNodeType() == 1) {
                Node comp = this.xmlCreateComponent((Element)child, dockableLocation);
                if (left) {
                    split.setLeft(comp);
                    left = false;
                } else {
                    split.setRight(comp);
                }
            }
            ++i;
        }
        return split;
    }

    private TabNode xmlBuildTabbedDockableContainer(Element elt, DockableState.Location dockableLocation) throws SAXException {
        TabNode tdc = new TabNode();
        int index = 0;
        int i = 0;
        while (i < elt.getChildNodes().getLength()) {
            org.w3c.dom.Node child = elt.getChildNodes().item(i);
            if (child.getNodeType() == 1) {
                SingleDockableNode sdn = this.xmlGetDockable((Element)child);
                tdc.addTab(index++, sdn);
                if (sdn instanceof CompoundDockableNode) {
                    this.xmlBuildCompoundDockable((CompoundDockableNode)sdn, (Element)child, dockableLocation);
                }
            }
            ++i;
        }
        return tdc;
    }

    private void xmlBuildAutoHideNode(int zone, Element dockableElt) throws SAXException {
        Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
        float x = Float.parseFloat(hideElt.getAttribute("x"));
        float y = Float.parseFloat(hideElt.getAttribute("y"));
        float w = Float.parseFloat(hideElt.getAttribute("w"));
        float h = Float.parseFloat(hideElt.getAttribute("h"));
        RelativeDockablePosition position = new RelativeDockablePosition(x, y, w, h);
        SingleDockableNode dockable = this.xmlGetDockable(dockableElt);
        this.borders[zone].add(new HiddenNode(dockable, position));
        if (dockable instanceof CompoundDockableNode) {
            this.xmlBuildCompoundDockable((CompoundDockableNode)dockable, dockableElt, DockableState.Location.HIDDEN);
        }
    }

    private void xmlBuildFloatingNode(NodeList dockables, Rectangle rectangle) throws SAXException {
        FloatingNode floating = null;
        SingleDockableNode baseDockable = null;
        int i = 0;
        while (i < dockables.getLength()) {
            Element dockableElt = (Element)dockables.item(i);
            Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
            float x = Float.parseFloat(hideElt.getAttribute("x"));
            float y = Float.parseFloat(hideElt.getAttribute("y"));
            float w = Float.parseFloat(hideElt.getAttribute("w"));
            float h = Float.parseFloat(hideElt.getAttribute("h"));
            RelativeDockablePosition position = new RelativeDockablePosition(x, y, w, h);
            SingleDockableNode dockable = this.xmlGetDockable(dockableElt);
            if (i == 0) {
                baseDockable = dockable;
                floating = new FloatingNode(baseDockable, rectangle, position);
                this.floatingNodes.add(floating);
            }
            Element previousState = (Element)dockableElt.getElementsByTagName("PreviousState").item(0);
            int istate = Integer.parseInt(previousState.getAttribute("state"));
            if (i > 0) {
                this.createTab(baseDockable.key, dockable.key, i);
            }
            if (dockable instanceof CompoundDockableNode) {
                this.xmlBuildCompoundDockable((CompoundDockableNode)dockable, dockableElt, DockableState.Location.FLOATING);
            }
            ++i;
        }
    }

    private void xmlBuildTabGroup(NodeList group) {
        int i = 0;
        while (i < group.getLength()) {
            Element groupElt = (Element)group.item(i);
            NodeList dockables = groupElt.getElementsByTagName("Dockable");
            SingleDockableNode base = null;
            int j = 0;
            while (j < dockables.getLength()) {
                Element dockableElt = (Element)dockables.item(j);
                SingleDockableNode d = this.xmlGetDockable(dockableElt);
                if (j == 0) {
                    base = d;
                } else {
                    this.addToTabbedGroup(base.key, d.key);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addToTabbedGroup(WSDockKey base, WSDockKey newTab) {
        LinkedList<WSDockKey> group = this.tabbedGroups.get(base);
        if (group == null) {
            group = new LinkedList();
            group.add(base);
            this.tabbedGroups.put(base, group);
        }
        group.add(newTab);
        this.tabbedGroups.put(newTab, group);
    }

    private class CompoundDockableNode
    extends SingleDockableNode {
        Node nestedNode;

        CompoundDockableNode(WSDockKey key) {
            super(key);
        }

        void setNestedNode(Node nested) {
            nested.parent = this;
            this.nestedNode = nested;
        }
    }

    private class FloatingNode
    extends Node {
        private Node child;
        private Rectangle windowRect;
        private RelativeDockablePosition returnPosition;

        FloatingNode(Node child, Rectangle windowRect, RelativeDockablePosition returnPosition) {
            this.windowRect = windowRect;
            this.returnPosition = returnPosition;
            this.setChild(child);
        }

        void setChild(Node child) {
            this.child = child;
            child.parent = this;
        }
    }

    private class HiddenNode
    extends Node {
        private SingleDockableNode node;
        private RelativeDockablePosition position;

        HiddenNode(SingleDockableNode node, RelativeDockablePosition position) {
            this.node = node;
            node.parent = this;
            this.position = position;
        }

        void setChild(SingleDockableNode child) {
            child.parent = this;
            this.node = child;
        }
    }

    private abstract class Node {
        Node parent;

        private Node() {
        }
    }

    private class SingleDockableNode
    extends Node {
        WSDockKey key;

        SingleDockableNode(WSDockKey key) {
            this.key = key;
            WSDesktop.this.nodesByKey.put(key, this);
        }
    }

    private class SplitNode
    extends Node {
        Node left;
        Node right;
        private double location;
        boolean isHorizontal;

        private SplitNode() {
        }

        void setTop(Node node) {
            this.left = node;
            node.parent = this;
        }

        void setBottom(Node node) {
            this.right = node;
            node.parent = this;
        }

        void setLeft(Node node) {
            this.left = node;
            node.parent = this;
        }

        void setRight(Node node) {
            this.right = node;
            node.parent = this;
        }

        Node getTop() {
            return this.left;
        }

        Node getBottom() {
            return this.right;
        }

        Node getLeft() {
            return this.left;
        }

        Node getRight() {
            return this.right;
        }
    }

    private class TabNode
    extends Node {
        ArrayList tabs = new ArrayList();

        private TabNode() {
        }

        SingleDockableNode getTab(int index) {
            return (SingleDockableNode)this.tabs.get(index);
        }

        void addTab(int index, SingleDockableNode tab) {
            this.tabs.add(index, tab);
            tab.parent = this;
        }

        private void replaceTab(int index, SingleDockableNode node) {
            this.tabs.set(index, node);
            node.parent = this;
        }
    }

    private class TopLevelNode
    extends Node {
        Node child;

        private TopLevelNode() {
        }

        void setChild(Node child) {
            this.child = child;
            child.parent = this;
        }
    }
}

