/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import gen.taas.TaasExtractionResult;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class LocalTaaSGlossary
implements IGlossary {
    private static final Logger LOGGER = Logger.getLogger(LocalTaaSGlossary.class.getName());
    private String domain;
    private String[] collections;

    public LocalTaaSGlossary(Properties prop) {
        this.domain = prop.getProperty("taas.domain");
        String coll = prop.getProperty("taas.collections");
        if (coll != null) {
            this.collections = coll.split(",");
        }
    }

    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        if (!TaaSPlugin.client.isAllowed()) {
            return Collections.emptyList();
        }
        TaasExtractionResult res = TaaSPlugin.client.termExtraction(sLang, tLang, srcText, this.domain, this.collections);
        String data = TaaSPlugin.filterTaasResult((String)res.getTerms());
        List entries = GlossaryReaderTBX.read((String)data, (boolean)false);
        Log.logDebug((Logger)LOGGER, (String)"TaaS returns {0} glossary entries", (Object[])new Object[]{entries.size()});
        return entries;
    }
}

