/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class ImportFromAutoTMX {
    final RealProject project;
    Map<String, SourceTextEntry> existEntries = new HashMap<String, SourceTextEntry>();
    boolean didAnyChange = false;

    public ImportFromAutoTMX(RealProject project, List<SourceTextEntry> allProjectEntries) {
        this.project = project;
        for (SourceTextEntry ste : allProjectEntries) {
            this.existEntries.put(ste.getSrcText(), ste.firstInstance == null ? ste : ste.firstInstance);
        }
    }

    void process(IBrowsableMemory mem, boolean isEnforcedTMX) throws Exception {
        IEntryCursor cursor = mem.browseAllEntries();
        while (cursor.next()) {
            SourceTextEntry topEntry = this.existEntries.get(cursor.getEntrySource());
            if (topEntry == null) continue;
            this.processEntry(cursor, topEntry, isEnforcedTMX);
            if (topEntry.duplicates == null) continue;
            for (SourceTextEntry ste : topEntry.duplicates) {
                this.processEntry(cursor, ste, isEnforcedTMX);
            }
        }
    }

    void processEntry(IEntryCursor cursor, SourceTextEntry ste, boolean isEnforcedTMX) throws Exception {
        boolean has100PC;
        TMXEntry existTranslation = this.project.getTranslationInfo(ste);
        PrepareTMXEntry e = cursor.toPrepareTMXEntry();
        String id = ste.getKey().id;
        boolean hasICE = id != null && e.hasPropValue("x-ice", id);
        boolean bl = has100PC = id != null && e.hasPropValue("x-100pc", id);
        if (e.getPropValue("x-target-lang") != null && !e.getPropValue("x-target-lang").equalsIgnoreCase(this.project.getProjectProperties().getTargetLanguage().toString())) {
            return;
        }
        if (!hasICE && !has100PC) {
            boolean isDefaultTranslation;
            boolean bl2 = isDefaultTranslation = !this.isAltTranslation(e);
            if (!existTranslation.defaultTranslation && isDefaultTranslation) {
                return;
            }
            if (!isDefaultTranslation && !this.altTranslationMatches(e, ste.getKey())) {
                return;
            }
            if (existTranslation.isTranslated()) {
                if (existTranslation.linked == TMXEntry.ExternalLinked.xAUTO && !StringUtil.equalsWithNulls(existTranslation.translation, e.translation) || isEnforcedTMX) {
                    this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
                }
            } else {
                this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
            }
        } else if (!existTranslation.isTranslated() || existTranslation.defaultTranslation) {
            if (hasICE) {
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
            } else if (has100PC) {
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
            }
        } else if (existTranslation.linked == TMXEntry.ExternalLinked.xICE || existTranslation.linked == TMXEntry.ExternalLinked.x100PC) {
            if (hasICE && !StringUtil.equalsWithNulls(existTranslation.translation, e.translation)) {
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
            }
        } else if (existTranslation.linked == TMXEntry.ExternalLinked.x100PC && has100PC && !StringUtil.equalsWithNulls(existTranslation.translation, e.translation)) {
            this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
        }
    }

    private boolean isAltTranslation(PrepareTMXEntry entry) {
        if (entry.otherProperties == null) {
            return false;
        }
        boolean hasFileProp = false;
        boolean hasOtherProp = false;
        for (TMXProp p : entry.otherProperties) {
            if (p.getType().equals("file")) {
                hasFileProp = true;
                continue;
            }
            if (!p.getType().equals("id") && !p.getType().equals("next") && !p.getType().equals("path") && !p.getType().equals("prev")) continue;
            hasOtherProp = true;
        }
        return EntryKey.IGNORE_FILE_CONTEXT ? hasFileProp && hasOtherProp : hasFileProp;
    }

    private boolean altTranslationMatches(PrepareTMXEntry entry, EntryKey key) {
        try {
            for (TMXProp p : entry.otherProperties) {
                if (p.getType().equals("file") && EntryKey.IGNORE_FILE_CONTEXT) continue;
                try {
                    Field f = EntryKey.class.getField(p.getType());
                    Object value = f.get(key);
                    if (value.equals(p.getValue())) continue;
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        if (StringUtil.isEmpty(trans.note)) {
            trans.note = null;
        }
        trans.source = entry.getSrcText();
        if (!this.didAnyChange) {
            TMXEntry oldEntry;
            TMXEntry tMXEntry = oldEntry = defaultTranslation ? this.project.projectTMX.defaults.get(entry.getSrcText()) : this.project.projectTMX.alternatives.get(entry.getKey());
            if (oldEntry == null) {
                if (trans.isTranslated()) {
                    this.didAnyChange = true;
                }
            } else if (oldEntry.isTranslated()) {
                if (!oldEntry.getTranslationText().equals(trans.getTranslationText())) {
                    this.didAnyChange = true;
                }
            } else if (trans.isTranslated()) {
                this.didAnyChange = true;
            }
        }
        TMXEntry newTrEntry = trans.translation == null && trans.note == null ? null : new TMXEntry(trans, defaultTranslation, externalLinked);
        this.project.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
    }
}

