/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.segmentation.Rule;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.util.Language;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public abstract class TranslateEntry
implements ITranslateCallback {
    private final ProjectProperties m_config;
    private int pass;
    private List<TranslateEntryQueueItem> translateQueue = new ArrayList<TranslateEntryQueueItem>();
    private int currentlyProcessedSegment;

    public TranslateEntry(ProjectProperties m_config) {
        this.m_config = m_config;
    }

    @Override
    public void setPass(int pass) {
        this.pass = pass;
        this.currentlyProcessedSegment = 0;
    }

    protected void fileStarted() {
        this.currentlyProcessedSegment = 0;
    }

    abstract String getCurrentFile();

    protected void fileFinished() {
        if (this.currentlyProcessedSegment != this.translateQueue.size()) {
            throw new RuntimeException("Invalid two-pass processing: number of segments are not equals");
        }
        this.translateQueue.clear();
    }

    @Override
    public String getNote(String id, String origSource, String path) {
        ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
        boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
        String source = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(origSource, spr, this.m_config.isRemoveTags(), removeSpaces));
        if (this.m_config.isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.m_config.getSourceLanguage();
            Language targetLang = this.m_config.getTargetLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, source, spaces, brules);
            StringBuilder res = new StringBuilder();
            for (int i = 0; i < segments.size(); ++i) {
                TMXEntry tex = this.internalGetSegmentEntry(id, i, segments.get(i), path);
                if (tex == null || tex.note == null) continue;
                res.append(tex.note).append("\n\n");
            }
            return res.toString();
        }
        TMXEntry tex = this.internalGetSegmentEntry(id, 0, source, path);
        if (tex == null) {
            return null;
        }
        return tex.note;
    }

    @Override
    public ITMXEntry getTranslationEntry(String id, String origSource, String path) {
        ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
        boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
        String source = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(origSource, spr, this.m_config.isRemoveTags(), removeSpaces));
        if (this.m_config.isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.m_config.getSourceLanguage();
            Language targetLang = this.m_config.getTargetLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, source, spaces, brules);
            PrepareTMXEntry res = new PrepareTMXEntry();
            res.source = source;
            res.translation = this.getTranslation(id, source, path);
            res.note = this.getNote(id, source, path);
            for (int i = 0; i < segments.size(); ++i) {
                String onesrc = segments.get(i);
                TMXEntry tex = this.internalGetSegmentEntry(id, i, onesrc, path);
                if (tex == null) continue;
                if (res.changer == null) {
                    res.changer = tex.changer == null ? tex.creator : tex.changer;
                    res.changeDate = tex.changeDate == 0L ? tex.creationDate : tex.changeDate;
                    res.creationDate = tex.creationDate;
                    res.creator = tex.creator;
                    continue;
                }
                if (!res.changer.equals(tex.changer)) {
                    res.creator = null;
                    res.changer = null;
                    res.creationDate = 0L;
                    res.changeDate = 0L;
                    return res;
                }
                if (res.changeDate >= tex.changeDate) continue;
                res.changeDate = tex.changeDate;
            }
            if (res.translation == null && res.note == null) {
                return null;
            }
            return res;
        }
        return this.internalGetSegmentEntry(id, 0, source, path);
    }

    @Override
    public String getTranslation(String id, String origSource, String path) {
        int locFirstTag;
        String firstTag;
        ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
        String tags = null;
        if (this.m_config.isRemoveTags()) {
            tags = TagUtil.buildTagListForRemove(origSource);
        }
        boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
        String source = StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(origSource, spr, this.m_config.isRemoveTags(), removeSpaces));
        StringBuilder res = new StringBuilder();
        if (this.m_config.isSentenceSegmentingEnabled()) {
            boolean translated = false;
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.m_config.getSourceLanguage();
            Language targetLang = this.m_config.getTargetLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, source, spaces, brules);
            for (int i = 0; i < segments.size(); ++i) {
                String tr;
                String onesrc = segments.get(i);
                TMXEntry tex = this.internalGetSegmentEntry(id, i, onesrc, path);
                String string = tr = tex == null ? onesrc : tex.translation;
                if (tex != null) {
                    translated = true;
                }
                segments.set(i, tr);
            }
            if (!translated) {
                return null;
            }
            res.append(Core.getSegmenter().glue(sourceLang, targetLang, segments, spaces, brules));
        } else {
            TMXEntry tex = this.internalGetSegmentEntry(id, 0, source, path);
            if (tex == null) {
                return null;
            }
            res.append(tex.translation);
        }
        String r = res.toString();
        String fileName = this.getCurrentFile().toLowerCase();
        if ((fileName.endsWith(".docx") || fileName.endsWith(".docm")) && !this.m_config.isRemoveTags() && !Core.getFilterMaster().getConfig().isRemoveTags() && (firstTag = TagUtil.getFirstTag(r)) != null && (locFirstTag = r.indexOf(firstTag)) > 0) {
            String addSpace = "";
            if (!Character.isWhitespace(r.codePointBefore(locFirstTag)) && !Character.isWhitespace(r.codePointAt(locFirstTag + firstTag.length())) && Core.getProject().getProjectProperties().getTargetLanguage().isSpaceDelimited()) {
                addSpace = " ";
            }
            r = firstTag + r.substring(0, locFirstTag) + addSpace + r.substring(locFirstTag + firstTag.length());
        }
        if (this.m_config.isRemoveTags()) {
            r = r + tags;
        }
        if (spr.crlf) {
            r = r.replace("\n", "\r\n");
        } else if (spr.cr) {
            r = r.replace("\n", "\r");
        }
        if (spr.spacesAtBegin > 0) {
            r = origSource.substring(0, spr.spacesAtBegin) + r;
        }
        if (spr.spacesAtEnd > 0) {
            r = r + origSource.substring(origSource.length() - spr.spacesAtEnd);
        }
        return r;
    }

    @Override
    public String getTranslation(String id, String origSource) {
        return this.getTranslation(id, origSource, null);
    }

    @Override
    public void linkPrevNextSegments() {
        for (int i = 0; i < this.translateQueue.size(); ++i) {
            TranslateEntryQueueItem item = this.translateQueue.get(i);
            try {
                item.prevSegment = this.translateQueue.get((int)(i - 1)).segmentSource;
            }
            catch (IndexOutOfBoundsException ex) {
                item.prevSegment = "";
            }
            try {
                item.nextSegment = this.translateQueue.get((int)(i + 1)).segmentSource;
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                item.nextSegment = "";
            }
        }
    }

    private TMXEntry internalGetSegmentEntry(String id, int segmentIndex, String segmentSource, String path) {
        if (segmentSource.trim().isEmpty()) {
            return null;
        }
        switch (this.pass) {
            case 1: {
                TranslateEntryQueueItem item = new TranslateEntryQueueItem();
                item.id = id;
                item.segmentIndex = segmentIndex;
                item.segmentSource = segmentSource;
                this.translateQueue.add(item);
                ++this.currentlyProcessedSegment;
                return this.getSegmentEntry(id, segmentIndex, segmentSource, null, null, path);
            }
            case 2: {
                TranslateEntryQueueItem item = this.translateQueue.get(this.currentlyProcessedSegment);
                if (!StringUtil.equalsWithNulls(id, item.id) || segmentIndex != item.segmentIndex || !StringUtil.equalsWithNulls(segmentSource, item.segmentSource)) {
                    throw new RuntimeException("Invalid two-pass processing: not equals fields");
                }
                ++this.currentlyProcessedSegment;
                return this.getSegmentEntry(id, segmentIndex, segmentSource, item.prevSegment, item.nextSegment, path);
            }
        }
        throw new RuntimeException("Invalid pass number: " + this.pass);
    }

    protected abstract TMXEntry getSegmentEntry(String var1, int var2, String var3, String var4, String var5, String var6);

    protected static class TranslateEntryQueueItem {
        String id;
        int segmentIndex;
        String segmentSource;
        String prevSegment;
        String nextSegment;

        protected TranslateEntryQueueItem() {
        }
    }
}

