/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.glossaries;

import java.util.Collection;
import java.util.Collections;
import org.omegat.core.Core;
import org.omegat.core.data.ITranslationEntry;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.gui.glossary.GlossaryEntryView;
import org.omegat.gui.glossary.MergedGlossaryEntries;
import org.omegat.util.StringUtil;

public class GlossaryEntryStore
extends GlossaryEntryView
implements ITranslationEntry {
    private final String mTarget;
    private final String mNote;
    private final IGlossary mOrigin;

    public GlossaryEntryStore(String src, String loc, String note, IGlossary origin) {
        super(src);
        this.mTarget = StringUtil.normalizeUnicode(loc);
        this.mNote = StringUtil.normalizeUnicode(note);
        this.mOrigin = origin;
    }

    public final String getLocText() {
        return this.mTarget;
    }

    public String getCommentText() {
        return this.mNote;
    }

    public final String getNoteText() {
        return this.mNote;
    }

    public final boolean getPriority() {
        return this.mOrigin == Core.getGlossaryManager().getPriorityGlossary();
    }

    public final IGlossary getOrigin() {
        return this.mOrigin;
    }

    @Override
    public final Collection<GlossaryEntryStore> getMergedEntries() {
        return Collections.singletonList(this);
    }

    @Override
    public final Collection<String> getLocTerms(boolean unique) {
        return Collections.singletonList(this.mTarget);
    }

    @Override
    public final Iterable<GlossaryEntryStore> getEntriesFor(String tra) {
        if (tra.equals(this.mTarget)) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    public final boolean hasPriorities() {
        return this.mOrigin == Core.getGlossaryManager().getPriorityGlossary();
    }

    @Override
    public final boolean hasPriorities(String tra) {
        return tra.equals(this.mTarget) && this.hasPriorities();
    }

    @Override
    public final String getSourceText() {
        return this.getSrcText();
    }

    @Override
    public final String getTranslationText() {
        return this.mTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            GlossaryEntryStore otherStore = (GlossaryEntryStore)o;
            return StringUtil.equalsWithNulls(this.getSrcText(), otherStore.getSrcText()) && StringUtil.equalsWithNulls(this.mTarget, otherStore.mTarget) && StringUtil.equalsWithNulls(this.mNote, otherStore.mNote);
        }
        catch (ClassCastException cce1) {
            try {
                MergedGlossaryEntries otherView = (MergedGlossaryEntries)o;
                Collection<GlossaryEntryStore> subEntries = otherView.getMergedEntries();
                return subEntries.size() == 1 && this.equals(subEntries.iterator().next());
            }
            catch (ClassCastException cce2) {
                return false;
            }
        }
    }

    public int hashCode() {
        int hash = 98;
        hash = hash * 17 + (this.getSrcText() == null ? 0 : this.getSrcText().hashCode());
        hash = hash * 31 + (this.mTarget == null ? 0 : this.mTarget.hashCode());
        hash = hash * 13 + (this.mNote == null ? 0 : this.mNote.hashCode());
        return hash;
    }
}

