/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.Language;

public abstract class CachedTranslate
extends BaseTranslate {
    private final Map<String, String> cache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        String fromCache = this.getCachedTranslation(sLang, tLang, text);
        if (fromCache != null) {
            return fromCache;
        }
        String result = super.getTranslation(sLang, tLang, text);
        if (result != null) {
            this.cache.put(sLang + "/" + tLang + "/" + text, result);
        }
        return result;
    }

    public String getCachedTranslation(Language sLang, Language tLang, String text) {
        return this.cache.get(sLang + "/" + tLang + "/" + text);
    }
}

