/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.omegat.core.data.IProject;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FindMatches;
import org.omegat.core.matching.FindMatchesKeep;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class FindMatchesArray
extends FindMatchesKeep {
    private LinkedList<NearString> result = new LinkedList();
    private final int maxCount;
    private int remaining;

    public FindMatchesArray(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, memoryPath, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.maxCount = maxCount;
    }

    public FindMatchesArray(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.maxCount = maxCount;
    }

    @Override
    public final int maxCount() {
        return this.maxCount;
    }

    @Override
    protected NearString lastKeptResult() {
        return this.result.isEmpty() ? null : this.result.getLast();
    }

    public List<NearString> search(IProject project, String searchText, boolean requiresTranslation, boolean fillSimilarityData, IStopped stop) throws FindMatches.StoppedException {
        this.result.clear();
        this.remaining = this.maxCount;
        this.doSearch(project, searchText, requiresTranslation, fillSimilarityData, stop);
        if (fillSimilarityData) {
            for (NearString near : this.result) {
                this.buildSimilarityData(near);
            }
        }
        return this.result;
    }

    @Override
    protected void doInsertion(NearString added) {
        if (this.result.isEmpty()) {
            this.result.add(added);
            return;
        }
        ListIterator<NearString> I = this.result.listIterator();
        while (I.hasNext()) {
            NearString st = (NearString)I.next();
            if (Preferences.isPreferenceDefault("ext_tmx_do_merge", true) && added.source.equals(st.source) && (added.translation == null && st.translation == null || added.translation != null && added.translation.equals(st.translation))) {
                I.set(NearString.merge(st, added));
                return;
            }
            if (st.composedScoreForSorting(this.sortKey) >= added.composedScoreForSorting(this.sortKey)) continue;
            I.previous();
            I.add(added);
            if (--this.remaining < 0) {
                this.result.removeLast();
            }
            return;
        }
    }
}

