/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.TMXProp;

public interface IEntryCursor {
    public boolean next() throws Exception;

    public String getEntrySource() throws Exception;

    public String getEntryTranslation() throws Exception;

    public String getEntryAuthor() throws Exception;

    public String getEntryLastModifier() throws Exception;

    public long getEntryCreationDate() throws Exception;

    public long getEntryLastModificationDate() throws Exception;

    public String getEntryNote() throws Exception;

    public boolean nextProperty() throws Exception;

    public String getCurrentPropertyName() throws Exception;

    public String getCurrentPropertyValue() throws Exception;

    default public PrepareTMXEntry toPrepareTMXEntry() throws Exception {
        PrepareTMXEntry tmx = new PrepareTMXEntry();
        tmx.source = this.getEntrySource();
        tmx.translation = this.getEntryTranslation();
        try {
            tmx.note = this.getEntryNote();
            tmx.creator = this.getEntryAuthor();
            tmx.creationDate = this.getEntryCreationDate();
            tmx.changer = this.getEntryLastModifier();
            tmx.changeDate = this.getEntryLastModificationDate();
            while (this.nextProperty()) {
                if (tmx.otherProperties == null) {
                    tmx.otherProperties = new ArrayList<TMXProp>();
                }
                tmx.otherProperties.add(new TMXProp(this.getCurrentPropertyName(), this.getCurrentPropertyValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmx;
    }

    default public EntryKey buildEntryKey() throws Exception {
        boolean hasKey = false;
        HashMap<String, String> props = new HashMap<String, String>();
        while (this.nextProperty()) {
            String key = this.getCurrentPropertyName();
            hasKey = key.equals("file") || key.equals("id") || key.equals("prev") || key.equals("next") || key.equals("path");
            if (!hasKey) continue;
            props.put(key, this.getCurrentPropertyValue());
        }
        return hasKey ? new EntryKey((String)props.get("file"), this.getEntrySource(), (String)props.get("id"), (String)props.get("prev"), (String)props.get("next"), (String)props.get("path")) : null;
    }

    public static class TMXEntriesCursor
    implements IEntryCursor {
        private Iterator<? extends ITMXEntry> iter;
        private ITMXEntry current = null;
        private Iterator<TMXProp> propIter = null;
        private TMXProp currentProp = null;

        public TMXEntriesCursor(Iterable<? extends ITMXEntry> entries) {
            this.iter = entries.iterator();
        }

        public TMXEntriesCursor(Iterator<? extends ITMXEntry> entries) {
            this.iter = entries;
        }

        @Override
        public boolean next() {
            if (this.iter.hasNext()) {
                this.current = this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public String getEntrySource() {
            return this.current.getSourceText();
        }

        @Override
        public String getEntryTranslation() {
            return this.current.getTranslationText();
        }

        @Override
        public String getEntryAuthor() {
            return this.current.getCreator();
        }

        @Override
        public String getEntryLastModifier() {
            return this.current.getChanger();
        }

        @Override
        public long getEntryCreationDate() {
            return this.current.getCreationDate();
        }

        @Override
        public long getEntryLastModificationDate() {
            return this.current.getChangeDate();
        }

        @Override
        public String getEntryNote() {
            return this.current.getNote();
        }

        @Override
        public boolean nextProperty() {
            if (this.current.getProperties() == null) {
                return false;
            }
            if (this.propIter == null) {
                this.propIter = this.current.getProperties().iterator();
            }
            if (this.propIter.hasNext()) {
                this.currentProp = this.propIter.next();
                return true;
            }
            this.propIter = null;
            return false;
        }

        @Override
        public String getCurrentPropertyName() {
            return this.currentProp.getType();
        }

        @Override
        public String getCurrentPropertyValue() {
            return this.currentProp.getValue();
        }

        @Override
        public PrepareTMXEntry toPrepareTMXEntry() throws Exception {
            try {
                return (PrepareTMXEntry)this.current;
            }
            catch (ClassCastException cce) {
                return IEntryCursor.super.toPrepareTMXEntry();
            }
        }
    }
}

