/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class ProjectMemory
extends ProjectTMX
implements IEntryEventListener {
    private IExternalProjectMemory memory;
    private IProject project;
    private long timeStamp = 0L;
    private long timeStamp_interval = 1000L;
    private Object distantOrphanPolicy = null;
    public static final long TIMESTAMP_REFRESH = -1L;
    private ExtendedCheckOrphanedCallback sourceEntryFinder;

    public ProjectMemory(Language sourceLanguage, Language targetLanguage, boolean isSentenceSegmentingEnabled, File saveTmxFile, ExtendedCheckOrphanedCallback callback, IProject project, File propertiesFile) throws Exception {
        super(sourceLanguage, targetLanguage, isSentenceSegmentingEnabled, saveTmxFile, callback);
        String distantOrphansPolicySpec;
        this.project = project;
        this.sourceEntryFinder = callback;
        Properties config = new Properties();
        FileInputStream fis = new FileInputStream(propertiesFile);
        config.load(fis);
        fis.close();
        Class<?> memoryClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
        try {
            this.memory = (IExternalProjectMemory)memoryClass.getConstructor(ProjectMemory.class, Properties.class).newInstance(this, config);
        }
        catch (Exception nsm) {
            this.memory = (IExternalProjectMemory)memoryClass.getConstructor(Properties.class).newInstance(config);
        }
        try {
            this.timeStamp_interval = Long.parseLong(config.getProperty("timestamp.interval"));
            Log.log("Created project memory with timestamp interval " + this.timeStamp_interval + " milliseconds");
        }
        catch (Exception e) {
            Log.log("Created project memory with default timestamp interval (1 second)");
        }
        if (config.getProperty("project.reuse-save_tmx") != null) {
            try {
                this.timeStamp = new File(project.getProjectProperties().getProjectInternal() + "/project_save.tmx").lastModified();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((distantOrphansPolicySpec = config.getProperty("distant.keep-orphans")) == null) {
            this.registerAsExternalMemory(targetLanguage, false);
        } else if (distantOrphansPolicySpec.startsWith("asMemory")) {
            this.registerAsExternalMemory(targetLanguage, true);
        } else if (distantOrphansPolicySpec.startsWith("RAM")) {
            if (distantOrphansPolicySpec.contains("%")) {
                try {
                    distantOrphansPolicySpec = distantOrphansPolicySpec.substring(3).trim();
                    distantOrphansPolicySpec = distantOrphansPolicySpec.replace('%', ' ').trim();
                    this.distantOrphanPolicy = Double.parseDouble(distantOrphansPolicySpec);
                }
                catch (Exception e) {
                    this.distantOrphanPolicy = 1.0;
                }
            } else {
                this.distantOrphanPolicy = Double.MAX_VALUE;
            }
        }
        CoreEvents.registerEntryEventListener(this);
    }

    private void registerAsExternalMemory(Language targetLanguage, boolean required) {
        block7: {
            try {
                IExternalMemory asTra = this.memory.asTranslationMemory();
                this.distantOrphanPolicy = asTra;
                if (asTra == null) {
                    Log.log("Cannot convert to translation memory: orphan segments will be ignored");
                    if (required) {
                        JOptionPane.showMessageDialog(null, "Cannot convert to translation memory: orphan segments will be ignored", "Error", 0);
                    }
                } else if (this.project == Core.getProject()) {
                    this.project.getTransMemories().put(OStrings.getString("CT_DISTANT_ORPHAN_STRINGS"), asTra);
                } else {
                    this.project.getTransMemories().put(OStrings.getString("CT_DISTANT_ORPHAN_STRINGS") + " (" + targetLanguage + ")", asTra);
                }
            }
            catch (Exception e) {
                Log.log("Failed to create orphan segments provider : " + e.getMessage());
                if (!required) break block7;
                JOptionPane.showMessageDialog(null, "Failed to create orphan segments provider : " + e.getMessage(), "Error", 0);
            }
        }
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        try {
            Set<Integer> changes = this.refresh();
            if (changes.size() > 0) {
                Core.getEditor().commitAndDeactivate();
                Core.getEditor().refreshEntries(changes);
                Core.getEditor().activateEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not synchronize with server:\n" + e.getClass().getName() + " : " + e.getMessage(), "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Set<Integer> refresh() throws Exception {
        if (this.timeStamp == -1L) {
            return Collections.emptySet();
        }
        if (System.currentTimeMillis() - this.timeStamp < this.timeStamp_interval) {
            return Collections.emptySet();
        }
        try {
            double count;
            IEntryCursor cursor = this.memory.findChanges(this.timeStamp);
            this.timeStamp = -1L;
            HashSet<Integer> changedSegments = new HashSet<Integer>();
            boolean keepOrphans = false;
            if (this.distantOrphanPolicy instanceof Double && (count = (double)((this.getDefaults().size() + this.getAlternatives().size()) / Core.getProject().getAllEntries().size())) < (Double)this.distantOrphanPolicy) {
                keepOrphans = true;
            }
            while (cursor.next()) {
                EntryKey key = cursor.buildEntryKey();
                SourceTextEntry ste = key == null ? this.sourceEntryFinder.existSource.get(cursor.getEntrySource()) : this.sourceEntryFinder.existKeys.get(key);
                if (ste == null) {
                    if (!keepOrphans) continue;
                    ste = key != null ? new SourceTextEntry(key, -1, null, Collections.EMPTY_LIST, true) : new SourceTextEntry(new EntryKey("", cursor.getEntrySource(), "", "", "", ""), -1, null, Collections.EMPTY_LIST, true);
                }
                this.project.setTranslation(ste, cursor.toPrepareTMXEntry(), key == null, null);
                changedSegments.add(ste.entryNum());
                if (key != null) continue;
                for (SourceTextEntry dup : ste.getDuplicates()) {
                    changedSegments.add(dup.entryNum());
                }
            }
            HashSet<Integer> hashSet = changedSegments;
            return hashSet;
        }
        finally {
            this.timeStamp = System.currentTimeMillis();
        }
    }

    @Override
    public void setTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) {
        super.setTranslation(ste, te, isDefault);
        if (this.timeStamp == -1L) {
            return;
        }
        try {
            this.memory.registerTranslation(ste, te, isDefault);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save(ProjectProperties props, String translationFile, boolean translationUpdatedByUser) throws Exception {
        super.save(props, translationFile, translationUpdatedByUser);
        this.memory.onProjectSave(translationUpdatedByUser);
    }

    public final ExtendedCheckOrphanedCallback getEntriesFinder() {
        return this.sourceEntryFinder;
    }

    public static interface IExternalProjectMemory {
        public IEntryCursor findChanges(long var1) throws Exception;

        public void registerTranslation(SourceTextEntry var1, TMXEntry var2, boolean var3) throws Exception;

        default public void onProjectSave(boolean translationUpdatedByUser) {
        }

        default public IExternalMemory asTranslationMemory() throws Exception {
            return null;
        }
    }

    public static class ExtendedCheckOrphanedCallback
    implements ProjectTMX.CheckOrphanedCallback {
        public final Map<String, SourceTextEntry> existSource = new HashMap<String, SourceTextEntry>();
        public final Map<EntryKey, SourceTextEntry> existKeys = new HashMap<EntryKey, SourceTextEntry>();

        public ExtendedCheckOrphanedCallback() {
        }

        public ExtendedCheckOrphanedCallback(List<SourceTextEntry> entries) {
            for (SourceTextEntry ste : entries) {
                this.addEntry(ste);
            }
        }

        @Override
        public boolean existEntryInProject(EntryKey key) {
            return this.existKeys.containsKey(key);
        }

        @Override
        public boolean existSourceInProject(String src) {
            return this.existSource.containsKey(src);
        }

        @Override
        public void addEntry(SourceTextEntry ste) {
            if (!this.existSource.containsKey(ste.getKey().sourceText)) {
                this.existSource.put(ste.getKey().sourceText, ste);
            }
            if (!this.existKeys.containsKey(ste.getKey())) {
                this.existKeys.put(ste.getKey(), ste);
            }
        }
    }
}

