/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.List;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.search.CrossSourceSearchResultEntry;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.search.PreTranslateDialog;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Token;

public class CrossSourceSearcher
extends ProjectSearcher
implements IStopped {
    private ITokenizer tokenizer;
    private final ISimilarityCalculator distance = new LevenshteinDistance();
    private final NearString.SORT_KEY m_criteria;
    private final int m_minVal;
    private final int m_minGroupSize;
    private CrossSourceSearchResultEntry[] entryPerId;
    protected final TranslationStateFilter m_translationStateFilter;
    protected final TextExpression m_searchSource;

    public CrossSourceSearcher(IProject project, PreTranslateDialog window, int numberOfResults, int minGroupSize, TextExpression searchSource, TranslationStateFilter filter, NearString.SORT_KEY criteria, int minValue, TextExpression author, long dateAfter, long dateBefore) {
        super(window, project, true, false, numberOfResults, author, null, dateAfter, dateBefore);
        this.m_criteria = criteria;
        this.m_minVal = minValue;
        this.m_minGroupSize = minGroupSize;
        this.entryPerId = new CrossSourceSearchResultEntry[project.getAllEntries().size()];
        this.tokenizer = this.m_project.getSourceTokenizer();
        this.m_searchSource = searchSource;
        this.m_translationStateFilter = filter;
    }

    @Override
    public boolean isStopped() {
        return this.isInterrupted();
    }

    @Override
    protected void testOngoing(SourceTextEntry ste) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return;
        }
        if (!this.checkFilters(tmxEntry)) {
            return;
        }
        List<SearchMatch> srcMatches = this.m_searchSource.searchString(ste.getSrcText());
        if (srcMatches != null) {
            Token[] selfTokens = this.tokenize(ste.getSrcText());
            int maxFound = this.m_minVal - 1;
            int idxFound = -1;
            for (SourceTextEntry ste2 : this.m_project.getAllEntries()) {
                Token[] candTokens;
                int similarity;
                if (ste == ste2) continue;
                TMXEntry tmxEntry2 = this.m_project.getTranslationInfo(ste);
                if (!this.getTranslationStateFilter().isValidEntry(tmxEntry2)) {
                    return;
                }
                if (!this.checkFilters(tmxEntry2)) {
                    return;
                }
                if (!this.m_searchSource.matchesString(ste.getSrcText()) || (similarity = this.distance.calcSimilarity(selfTokens, candTokens = this.tokenize(ste2.getSrcText()))) <= maxFound) continue;
                idxFound = ste2.entryNum();
                maxFound = similarity;
            }
            if (idxFound == -1) {
                return;
            }
            if (this.entryPerId[idxFound - 1] != null) {
                this.entryPerId[idxFound - 1].add(ste);
                if (this.entryPerId[idxFound - 1].entries().size() >= this.m_minGroupSize) {
                    this.addEntry(this.entryPerId[idxFound - 1]);
                }
                CrossSourceSearchResultEntry crossSourceSearchResultEntry = this.entryPerId[idxFound - 1];
                this.entryPerId[ste.entryNum() - 1] = crossSourceSearchResultEntry;
                this.addEntry(crossSourceSearchResultEntry);
            } else {
                CrossSourceSearchResultEntry entry = new CrossSourceSearchResultEntry(ste, tmxEntry, srcMatches);
                entry.add(this.m_project.getAllEntries().get(idxFound - 1));
                if (entry.entries().size() >= this.m_minGroupSize) {
                    this.addEntry(entry);
                }
                CrossSourceSearchResultEntry crossSourceSearchResultEntry = entry;
                this.entryPerId[ste.entryNum() - 1] = crossSourceSearchResultEntry;
                this.entryPerId[idxFound - 1] = crossSourceSearchResultEntry;
                this.addEntry(crossSourceSearchResultEntry);
            }
        }
    }

    private Token[] tokenize(String st) {
        if (this.tokenizer == null) {
            this.tokenizer = this.m_project.getSourceTokenizer();
        }
        switch (this.m_criteria) {
            case SCORE: {
                return this.tokenizer.tokenizeWords(st, ITokenizer.StemmingMode.MATCHING);
            }
            case SCORE_NO_STEM: {
                return this.tokenizer.tokenizeWords(st, ITokenizer.StemmingMode.NONE);
            }
            case ADJUSTED_SCORE: {
                return this.tokenizer.tokenizeVerbatim(st);
            }
        }
        return this.tokenizer.tokenizeVerbatim(st);
    }

    @Override
    public TranslationStateFilter getTranslationStateFilter() {
        return this.m_translationStateFilter;
    }

    @Override
    public boolean searchOn(int location) {
        return (location & 1) > 0;
    }
}

