/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.search.FullSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;

public class GlossarySearchResultEntry
extends FullSearchResultEntry {
    private GlossaryEntryStore m_entry;

    public GlossarySearchResultEntry(GlossaryEntryStore en, List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(srcMatch, targetMatch, noteMatch);
        this.m_entry = en;
    }

    @Override
    public int getEntryNum() {
        return -1;
    }

    @Override
    public String getPreamble() {
        return OStrings.getString("SW_GLOSSARY_RESULT") + ": " + this.m_entry.getOrigin().getShortName() + this.getMoreString();
    }

    @Override
    public String getSrcText() {
        return this.m_entry.getSrcText();
    }

    @Override
    public String getTranslation() {
        return this.m_entry.getLocText();
    }

    @Override
    public String getNote() {
        return this.m_entry.getCommentText();
    }

    @Override
    public String getFileName() {
        return OStrings.getString("SW_GLOSSARY_RESULT") + ": " + this.m_entry.getOrigin().getLongName();
    }

    @Override
    public String getAuthor() {
        return null;
    }

    @Override
    public String getRevisor() {
        return null;
    }

    @Override
    public Date getDate() {
        return null;
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }
}

