/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.search.SearchMatch;

public class ReplaceMatch
extends SearchMatch {
    private String replacement;

    public ReplaceMatch(int start, int end, String replacement) {
        super(start, end);
        this.replacement = replacement;
    }

    public final String getReplacement() {
        return this.replacement;
    }

    @Override
    public ReplaceMatch merge(SearchMatch other, boolean mustKeep, String defaultReplacement) {
        String rightPart;
        try {
            rightPart = ((ReplaceMatch)other).replacement;
        }
        catch (ClassCastException cce) {
            rightPart = defaultReplacement;
        }
        if (mustKeep) {
            return new ReplaceMatch(Math.min(this.start, other.start), Math.max(this.end, other.end), this.replacement + rightPart);
        }
        this.start = Math.min(this.start, other.start);
        this.end = Math.max(this.end, other.end);
        this.replacement = this.replacement + rightPart;
        return this;
    }

    @Override
    public SearchMatch englobeWord(String source) {
        int newStart;
        int newEnd = this.end;
        for (newStart = this.start; newStart > 0 && Character.isLetter(source.charAt(newStart - 1)); --newStart) {
        }
        while (newEnd < source.length() && Character.isLetter(source.charAt(newEnd))) {
            ++newEnd;
        }
        return new ReplaceMatch(newStart, newEnd, this.replacement);
    }

    public static String buildReplacedString(String ori, List<SearchMatch> matches, String defaultReplacement) {
        int shift = 0;
        for (SearchMatch m0 : matches) {
            String repl;
            try {
                repl = ((ReplaceMatch)m0).replacement;
            }
            catch (Exception e) {
                repl = defaultReplacement;
            }
            ori = ori.substring(0, m0.start + shift) + repl + ori.substring(m0.end + shift);
            shift += repl.length() - (m0.end - m0.start);
        }
        return ori;
    }

    public static List<SearchMatch> buildReplacedMatches(String ori, List<SearchMatch> matches, String defaultReplacement) {
        int shift = 0;
        ArrayList<SearchMatch> newList = new ArrayList<SearchMatch>(matches.size());
        for (SearchMatch m0 : matches) {
            String repl;
            try {
                repl = ((ReplaceMatch)m0).replacement;
            }
            catch (Exception e) {
                repl = defaultReplacement;
            }
            int shift2 = repl.length() - (m0.end - m0.start);
            newList.add(new SearchMatch(m0.start + shift, m0.end + shift + shift2));
            shift += shift2;
        }
        return newList;
    }
}

