/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import org.omegat.core.data.ITranslationEntry;
import org.omegat.core.data.SourceTextEntry;

public enum TranslationStateFilter {
    TRANSLATED_ONLY(1),
    UNTRANSLATED_ONLY(2),
    TRANSLATED_AND_UNTRANSLATED(3);

    public static final int FLAG_TRANSLATED = 1;
    public static final int FLAG_UNTRANSLATED = 2;
    public final int value;

    private TranslationStateFilter(int value) {
        this.value = value;
    }

    public boolean isValid(String entry) {
        if (entry != null) {
            return (this.value & 1) > 0;
        }
        return (this.value & 2) > 0;
    }

    public boolean isValidEntry(ITranslationEntry entry) {
        if (entry.isTranslated()) {
            return (this.value & 1) > 0;
        }
        return (this.value & 2) > 0;
    }

    public boolean isValidEntry(SourceTextEntry entry) {
        String translation = entry.getSourceTranslation();
        if (translation != null && translation.length() > 0) {
            return (this.value & 1) > 0;
        }
        return (this.value & 2) > 0;
    }
}

