/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class SRX
implements ISegmentationData,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2182125877925944613L;
    private static final XMLOutputFactory staxOutputFactory = XMLOutputFactory.newInstance();
    private static final XMLInputFactory staxInputFactory = XMLInputFactory.newInstance();
    private static final String DEFAULT_RULES_PATTERN = ".*";
    private boolean cascade = true;
    private boolean segmentSubflows = true;
    private boolean includeStartingTags;
    private boolean includeEndingTags = true;
    private boolean includeIsolatedTags;
    private List<MapRule> mappingRules = new ArrayList<MapRule>();
    public static String INITIAL_VERSION = "0.2";
    public static String OT160RC8_VERSION = "0.2.1";
    public static String OT160RC9_VERSION;
    public static String CURRENT_VERSION;
    private String version;

    public SRX clone() {
        SRX result = new SRX();
        result.mappingRules = new ArrayList<MapRule>(this.mappingRules.size());
        for (MapRule rule : this.mappingRules) {
            result.mappingRules.add(rule.clone());
        }
        return result;
    }

    @Override
    public SRX toSRX() {
        return this;
    }

    public static void saveTo(SRX srx, File outDir) throws IOException {
        File outFile = new File(outDir, "segmentation.srx".replace(".", "-2conf"));
        if (outFile.exists()) {
            outFile.delete();
            if (srx == null) {
                return;
            }
            outFile = new File(outDir, "segmentation.conf");
        } else {
            outFile = new File(outDir, "segmentation.conf".replace(".", "-2srx"));
            if (outFile.exists()) {
                outFile.delete();
                if (srx == null) {
                    return;
                }
                outFile = new File(outDir, "segmentation.srx");
            } else {
                outFile = new File(outDir, "segmentation.conf");
                if (!outFile.exists()) {
                    outFile = new File(outDir, "segmentation.srx");
                }
            }
        }
        if (srx == null) {
            outFile.delete();
            return;
        }
        if (outFile.getName().endsWith(".conf")) {
            SRX.saveToConf(srx, outFile);
        } else if (outFile.getName().endsWith(".srx")) {
            SRX.saveToSrx(srx, outFile);
        }
    }

    public static void saveToConf(SRX srx, File outFile) throws IOException {
        try {
            srx.setVersion(CURRENT_VERSION);
            XMLEncoder xmlenc = new XMLEncoder(new FileOutputStream(outFile));
            xmlenc.writeObject(srx);
            xmlenc.close();
        }
        catch (IOException ioe) {
            Log.logErrorRB("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG", new Object[0]);
            Log.log(ioe);
            throw ioe;
        }
    }

    public static void saveToSrx(SRX srx, File outFile) throws IOException {
        try (OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
            XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(fos);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("srx");
            writer.writeDefaultNamespace("http://www.lisa.org/srx20");
            writer.writeAttribute("version", "2.0");
            writer.writeCharacters("\n    ");
            writer.writeEmptyElement("header");
            writer.writeAttribute("cascade", srx.cascade ? "yes" : "no");
            writer.writeAttribute("segmentsubflows", srx.segmentSubflows ? "yes" : "no");
            writer.writeCharacters("\n    ");
            writer.writeStartElement("body");
            writer.writeCharacters("\n        ");
            writer.writeStartElement("languagerules");
            for (MapRule mr : srx.getMappingRules()) {
                writer.writeCharacters("\n            ");
                writer.writeStartElement("languagerule");
                writer.writeAttribute("languagerulename", mr.getLanguage());
                for (Rule rule : mr.getRules()) {
                    writer.writeCharacters("\n                ");
                    writer.writeStartElement("rule");
                    writer.writeAttribute("break", rule.isBreakRule() ? "yes" : "no");
                    writer.writeCharacters("\n                    ");
                    writer.writeStartElement("beforebreak");
                    writer.writeCharacters(rule.getBeforebreak());
                    writer.writeEndElement();
                    writer.writeCharacters("\n                    ");
                    writer.writeStartElement("afterbreak");
                    writer.writeCharacters(rule.getAfterbreak());
                    writer.writeEndElement();
                    writer.writeCharacters("\n                ");
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n            ");
                writer.writeEndElement();
            }
            writer.writeCharacters("\n        ");
            writer.writeEndElement();
            writer.writeCharacters("\n        ");
            writer.writeStartElement("maprules");
            for (MapRule mr : srx.getMappingRules()) {
                writer.writeCharacters("\n            ");
                writer.writeEmptyElement("languagemap");
                writer.writeAttribute("languagerulename", mr.getLanguage());
                writer.writeAttribute("languagepattern", mr.getPattern());
            }
            writer.writeCharacters("\n        ");
            writer.writeEndElement();
            writer.writeCharacters("\n    ");
            writer.writeEndElement();
            writer.writeCharacters("\n");
            writer.writeEndElement();
            writer.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static SRX loadConfFile(File configFile) {
        SRX res;
        try {
            MyExceptionListener myel = new MyExceptionListener();
            XMLDecoder xmldec = new XMLDecoder(new FileInputStream(configFile), null, myel);
            res = (SRX)xmldec.readObject();
            xmldec.close();
            if (myel.isExceptionOccured()) {
                StringBuilder sb = new StringBuilder();
                for (Exception ex : myel.getExceptionsList()) {
                    sb.append("    ");
                    sb.append(ex);
                    sb.append("\n");
                }
                Log.logErrorRB("CORE_SRX_EXC_LOADING_SEG_RULES", sb.toString());
                return ISegmentationData.getDefault();
            }
            if (CURRENT_VERSION.compareTo(res.getVersion()) > 0) {
                SRX defaults = ISegmentationData.getDefault();
                res = SRX.merge(res, defaults);
            }
            Log.log("using segmentation rules from " + configFile);
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                Log.log(e);
            }
            res = ISegmentationData.getDefault();
        }
        return res;
    }

    protected static SRX loadSrxFile(URL rulesUrl) {
        SRX res = new SRX();
        ArrayList<MapRule> newMap = new ArrayList<MapRule>();
        res.setMappingRules(newMap);
        try {
            try (InputStream io = rulesUrl.openStream();){
                Log.log("using segmentation rules from " + rulesUrl);
                XMLStreamReader reader = staxInputFactory.createXMLStreamReader(io);
                ArrayList<Rule> rulesList = null;
                HashMap mapping = new HashMap();
                while (reader.hasNext()) {
                    if (reader.next() != 1) continue;
                    if (reader.getName().getLocalPart().equals("header")) {
                        res.setCascade(!"no".equals(reader.getAttributeValue(null, "cascade")));
                        res.setSegmentSubflows(!"no".equals(reader.getAttributeValue(null, "segmentsubflows")));
                        continue;
                    }
                    if (reader.getName().getLocalPart().equals("languagerule")) {
                        rulesList = new ArrayList<Rule>();
                        mapping.put(reader.getAttributeValue(null, "languagerulename"), rulesList);
                        continue;
                    }
                    if (reader.getName().getLocalPart().equals("rule")) {
                        boolean isBreak = !"no".equals(reader.getAttributeValue(null, "break"));
                        StringBuffer before = new StringBuffer();
                        StringBuffer after = new StringBuffer();
                        int pos = 0;
                        while (reader.hasNext()) {
                            int next = reader.next();
                            if (next == 1) {
                                if (reader.getName().getLocalPart().equals("beforebreak")) {
                                    pos = -1;
                                    continue;
                                }
                                if (reader.getName().getLocalPart().equals("afterbreak")) {
                                    pos = 1;
                                    continue;
                                }
                                pos = 0;
                                continue;
                            }
                            if (next == 2) {
                                if (reader.getName().getLocalPart().equals("beforebreak")) {
                                    pos = 0;
                                    continue;
                                }
                                if (reader.getName().getLocalPart().equals("afterbreak")) {
                                    pos = 0;
                                    continue;
                                }
                                if (!reader.getName().getLocalPart().equals("rule")) continue;
                                break;
                            }
                            if (!reader.hasText()) continue;
                            if (pos == -1) {
                                before.append(reader.getText());
                            }
                            if (pos != 1) continue;
                            after.append(reader.getText());
                        }
                        rulesList.add(new Rule(isBreak, before.toString(), after.toString()));
                        continue;
                    }
                    if (!reader.getName().getLocalPart().equals("languagemap")) continue;
                    newMap.add(new MapRule(reader.getAttributeValue(null, "languagerulename"), reader.getAttributeValue(null, "languagepattern"), (List)mapping.get(reader.getAttributeValue(null, "languagerulename"))));
                }
            }
            return res;
        }
        catch (Exception ex) {
            Log.log(ex);
            return null;
        }
    }

    private static SRX merge(SRX current, SRX defaults) {
        current = SRX.upgrade(current, defaults);
        int defaultMapRulesN = defaults.getMappingRules().size();
        for (int i = 0; i < defaultMapRulesN; ++i) {
            MapRule dmaprule = defaults.getMappingRules().get(i);
            String dcode = dmaprule.getLanguageCode();
            boolean found = false;
            int currentMapRulesN = current.getMappingRules().size();
            MapRule cmaprule = null;
            for (int j = 0; j < currentMapRulesN; ++j) {
                cmaprule = current.getMappingRules().get(j);
                String ccode = cmaprule.getLanguageCode();
                if (!dcode.equals(ccode)) continue;
                found = true;
                break;
            }
            if (found) {
                List<Rule> crules = cmaprule.getRules();
                List<Rule> drules = dmaprule.getRules();
                for (Rule drule : drules) {
                    int currentRulesN;
                    if (crules.contains(drule)) continue;
                    if (drule.isBreakRule()) {
                        crules.add(drule);
                        continue;
                    }
                    int firstBreakRuleN = currentRulesN = crules.size();
                    for (int k = 0; k < currentRulesN; ++k) {
                        Rule crule = crules.get(k);
                        if (!crule.isBreakRule()) continue;
                        firstBreakRuleN = k;
                        break;
                    }
                    crules.add(firstBreakRuleN, drule);
                }
                continue;
            }
            int englishN = currentMapRulesN;
            for (int j = 0; j < currentMapRulesN; ++j) {
                cmaprule = current.getMappingRules().get(j);
                String cpattern = cmaprule.getPattern();
                if (!DEFAULT_RULES_PATTERN.equals(cpattern)) continue;
                englishN = j;
                break;
            }
            current.getMappingRules().add(englishN, dmaprule);
        }
        return current;
    }

    private static SRX upgrade(SRX current, SRX defaults) {
        if (OT160RC9_VERSION.equals(CURRENT_VERSION)) {
            String DEF = "Default (English)";
            for (int i = 0; i < current.getMappingRules().size(); ++i) {
                MapRule maprule = current.getMappingRules().get(i);
                if (!DEF.equals(maprule.getLanguageCode())) continue;
                maprule.setLanguage("Default");
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "English"));
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "Text"));
                maprule.getRules().removeAll(SRX.getRulesForLanguage(defaults, "HTML"));
            }
        }
        return current;
    }

    private static List<Rule> getRulesForLanguage(SRX source, String langName) {
        for (MapRule mr : source.getMappingRules()) {
            if (!langName.equals(mr.getLanguageCode())) continue;
            return mr.getRules();
        }
        return null;
    }

    @Override
    public List<Rule> lookupRulesForLanguage(Language srclang) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < this.getMappingRules().size(); ++i) {
            MapRule maprule = this.getMappingRules().get(i);
            if (!maprule.getCompiledPattern().matcher(srclang.getLanguage()).matches()) continue;
            rules.addAll(maprule.getRules());
            if (!this.cascade) break;
        }
        return rules;
    }

    @Override
    public boolean isCascade() {
        return this.cascade;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean isSegmentSubflows() {
        return this.segmentSubflows;
    }

    public void setSegmentSubflows(boolean segmentSubflows) {
        this.segmentSubflows = segmentSubflows;
    }

    @Override
    public boolean isIncludeStartingTags() {
        return this.includeStartingTags;
    }

    public void setIncludeStartingTags(boolean includeStartingTags) {
        this.includeStartingTags = includeStartingTags;
    }

    @Override
    public boolean isIncludeEndingTags() {
        return this.includeEndingTags;
    }

    public void setIncludeEndingTags(boolean includeEndingTags) {
        this.includeEndingTags = includeEndingTags;
    }

    @Override
    public boolean isIncludeIsolatedTags() {
        return this.includeIsolatedTags;
    }

    public void setIncludeIsolatedTags(boolean includeIsolatedTags) {
        this.includeIsolatedTags = includeIsolatedTags;
    }

    @Override
    public List<MapRule> getMappingRules() {
        return this.mappingRules;
    }

    public void setMappingRules(List<MapRule> rules) {
        this.mappingRules = rules;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    public void insertMapRule(int pos, MapRule mr) {
        this.mappingRules.add(pos, mr);
    }

    @Override
    public void insertRule(int pos, MapRule mr, Rule r) {
        mr.getRules().add(pos, r);
    }

    static {
        CURRENT_VERSION = OT160RC9_VERSION = "0.2.2";
    }

    static class MyExceptionListener
    implements ExceptionListener {
        private List<Exception> exceptionsList = new ArrayList<Exception>();
        private boolean exceptionOccured = false;

        MyExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            this.exceptionOccured = true;
            this.exceptionsList.add(e);
        }

        public boolean isExceptionOccured() {
            return this.exceptionOccured;
        }

        public List<Exception> getExceptionsList() {
            return this.exceptionsList;
        }
    }
}

