/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

public class CalcRevisionStatistics
extends LongProcessThread {
    private static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters"), OStrings.getString("CT_STATS_Files")};
    private static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Revised"), OStrings.getString("CT_STATS_RevisedChanged")};
    private static final boolean[] htAlign = new boolean[]{false, true, true, true, true, true};
    private static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_Revised"), OStrings.getString("CT_STATS_RevisedChanged")};
    private static final boolean[] ftAlign = new boolean[]{false, true, true, true, true};
    private final IStatisticsPanel.Standard callback;

    public CalcRevisionStatistics(IStatisticsPanel.Standard callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        String result = CalcRevisionStatistics.buildProjectStats(p, this.callback);
        this.callback.setTextData(result);
        this.callback.finishData();
    }

    public static String buildProjectStats(IProject project) {
        return CalcRevisionStatistics.buildProjectStats(project, null);
    }

    public static String buildProjectStats(IProject project, IStatisticsPanel.Standard callback) {
        FileData global = new FileData();
        HashMap uniqueSegment = new HashMap();
        HashSet<SourceTextEntry> revised = new HashSet<SourceTextEntry>();
        HashSet<SourceTextEntry> changed = new HashSet<SourceTextEntry>();
        for (SourceTextEntry ste : project.getAllEntries()) {
            TMXEntry tMXEntry;
            Iterator src = ste.getSrcText();
            for (ProtectedPart pp : ste.getProtectedParts()) {
                src = ((String)((Object)src)).replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
            }
            if (!uniqueSegment.containsKey(src)) {
                uniqueSegment.put(src, ste);
            }
            if ((tMXEntry = project.getTranslationInfo(ste)) != null && tMXEntry.revisor != null) {
                revised.add(ste);
            }
            if (tMXEntry == null || tMXEntry.changer == null || tMXEntry.changer.equals(Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")))) continue;
            changed.add(ste);
        }
        HashSet<String> filesUnique = new HashSet<String>();
        HashSet filesRemainingUnique = new HashSet();
        for (Map.Entry entry : uniqueSegment.entrySet()) {
            StatCount count = new StatCount((SourceTextEntry)entry.getValue());
            global.unique.add(count);
            filesUnique.add(((SourceTextEntry)entry.getValue()).getKey().file);
        }
        global.unique.addFiles(filesUnique.size());
        for (SourceTextEntry sourceTextEntry : revised) {
            global.revised.add(new StatCount(sourceTextEntry));
        }
        for (SourceTextEntry sourceTextEntry : changed) {
            global.changed.add(new StatCount(sourceTextEntry));
        }
        ArrayList<FileData> counts = new ArrayList<FileData>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            FileData numbers = new FileData();
            numbers.filename = file.filePath;
            counts.add(numbers);
            int fileTotal = 0;
            for (SourceTextEntry ste : file.entries) {
                TMXEntry tr;
                String src = ste.getSrcText();
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
                }
                StatCount count = new StatCount(ste);
                global.total.add(count);
                fileTotal = 1;
                numbers.total.add(count);
                Boolean firstSeen = (Boolean)hashMap.get(src);
                if (firstSeen == null) {
                    hashMap.put(src, false);
                    numbers.unique.add(count);
                }
                if ((tr = project.getTranslationInfo(ste)) != null && tr.revisor != null) {
                    numbers.revised.add(count);
                }
                if (tr == null || tr.changer == null || tr.changer.equals(Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name")))) continue;
                numbers.changed.add(count);
            }
            global.total.addFiles(fileTotal);
        }
        StringBuilder result = new StringBuilder();
        result.append(OStrings.getString("CT_STATS_Project_Statistics"));
        result.append("\n\n");
        String[][] headerTable = CalcRevisionStatistics.calcHeaderTable(new StatCount[]{global.total, global.unique, global.revised, global.changed});
        if (callback != null) {
            callback.setProjectTableData(htHeaders, headerTable);
        }
        result.append(TextUtil.showTextTable(htHeaders, headerTable, htAlign));
        result.append("\n\n");
        result.append(OStrings.getString("CT_STATS_FILE_Statistics"));
        result.append("\n\n");
        String[][] filesTable = CalcRevisionStatistics.calcFilesTable(project.getProjectProperties(), counts);
        if (callback != null) {
            callback.setFilesTableData(ftHeaders, filesTable);
        }
        result.append(TextUtil.showTextTable(ftHeaders, filesTable, ftAlign));
        return result.toString();
    }

    protected static String[][] calcHeaderTable(StatCount[] result) {
        String[][] table = new String[result.length][6];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = htRows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
            table[i][5] = Integer.toString(result[i].files);
        }
        return table;
    }

    protected static String[][] calcFilesTable(ProjectProperties m_config, List<FileData> counts) {
        String[][] table = new String[counts.size()][5];
        int r = 0;
        for (FileData numbers : counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, m_config.getSourceRoot());
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.unique.segments);
            table[r][3] = Integer.toString(numbers.revised.segments);
            table[r][4] = Integer.toString(numbers.changed.segments);
            ++r;
        }
        return table;
    }

    public static class FileData {
        public String filename;
        public StatCount total = new StatCount();
        public StatCount unique = new StatCount();
        public StatCount revised = new StatCount();
        public StatCount changed = new StatCount();
    }
}

