/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.tagvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.OStrings;
import org.omegat.util.TagUtil;

public class ErrorReport {
    public final Map<TagUtil.Tag, TagError> srcErrors = new HashMap<TagUtil.Tag, TagError>();
    public final Map<TagUtil.Tag, TagError> transErrors = new HashMap<TagUtil.Tag, TagError>();
    public final SourceTextEntry ste;
    public final String source;
    public final String translation;
    public final int entryNum;

    public ErrorReport(SourceTextEntry ste, String translation) {
        this.ste = ste;
        this.source = ste != null ? ste.getSrcText() : null;
        this.translation = translation;
        this.entryNum = ste != null ? ste.entryNum() : -1;
    }

    public boolean isEmpty() {
        return this.srcErrors.isEmpty() && this.transErrors.isEmpty();
    }

    public Map<TagError, List<TagUtil.Tag>> inverseReport() {
        HashMap<TagError, List<TagUtil.Tag>> result = new HashMap<TagError, List<TagUtil.Tag>>();
        ErrorReport.fillInverseReport(this.srcErrors, result);
        ErrorReport.fillInverseReport(this.transErrors, result);
        return result;
    }

    private static void fillInverseReport(Map<TagUtil.Tag, TagError> input, Map<TagError, List<TagUtil.Tag>> collector) {
        for (Map.Entry<TagUtil.Tag, TagError> e : input.entrySet()) {
            List<TagUtil.Tag> existing = collector.get((Object)e.getValue());
            if (existing == null) {
                existing = new ArrayList<TagUtil.Tag>();
                collector.put(e.getValue(), existing);
            }
            existing.add(e.getKey());
        }
    }

    public static String localizedTagError(TagError error) {
        switch (error) {
            case DUPLICATE: {
                return OStrings.getString("TAG_ERROR_DUPLICATE");
            }
            case MALFORMED: {
                return OStrings.getString("TAG_ERROR_MALFORMED");
            }
            case MISSING: {
                return OStrings.getString("TAG_ERROR_MISSING");
            }
            case EXTRANEOUS: {
                return OStrings.getString("TAG_ERROR_EXTRANEOUS");
            }
            case ORDER: {
                return OStrings.getString("TAG_ERROR_ORDER");
            }
            case WHITESPACE: {
                return OStrings.getString("TAG_ERROR_WHITESPACE");
            }
            case ORPHANED: {
                return OStrings.getString("TAG_ERROR_ORPHANED");
            }
            case UNSPECIFIED: {
                return OStrings.getString("TAG_ERROR_UNSPECIFIED");
            }
        }
        return null;
    }

    public static enum TagError {
        MISSING,
        EXTRANEOUS,
        ORDER,
        MALFORMED,
        WHITESPACE,
        DUPLICATE,
        ORPHANED,
        UNSPECIFIED;

    }
}

