/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.filehooks.IFileHook;

public class SdlProjectHook
implements IFileHook {
    public static final String SOURCE_TRADOS_DIR = "source-trados";
    public static final String TARGET_TRADOS_DIR = "target-trados";
    private Exception lastCompileException = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getNativeSourceFile(String currentFile, SourceTextEntry entry) {
        currentFile = currentFile.replace("/", File.separator);
        ProjectProperties otProj = Core.getProject().getProjectProperties();
        String sourceDir = otProj.getSourceRoot();
        try (ZipFile zipFile = new ZipFile(new File(currentFile));){
            ZipEntry ze;
            currentFile = currentFile.substring(sourceDir.length());
            sourceDir = otProj.getProjectRoot() + File.separator + SOURCE_TRADOS_DIR;
            new File(sourceDir).mkdir();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            do {
                if (!entries.hasMoreElements()) return currentFile;
            } while (!(ze = entries.nextElement()).getName().startsWith(otProj.getTargetLanguage().getLanguage()) || !ze.getName().endsWith(".sdlxliff"));
            currentFile = sourceDir + File.separator + ze.getName().substring(ze.getName().lastIndexOf(File.separator) + 1);
            File f = new File(currentFile);
            if (!f.exists()) {
                IOUtils.copy((InputStream)zipFile.getInputStream(ze), (OutputStream)new FileOutputStream(f));
            }
            String string = XLIFF_HOOK.getNativeSourceFile(f.getCanonicalPath(), entry, otProj.getProjectRoot() + SOURCE_TRADOS_DIR + File.separator);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentFile;
    }

    @Override
    public Exception lastCompileException() {
        return this.lastCompileException;
    }

    @Override
    public String getNativeTargetFile(String currentFile) {
        return XLIFF_HOOK.getNativeTargetFile(currentFile);
    }

    @Override
    public void postCompile(File destDir, String midName) {
        ProjectProperties otProj = Core.getProject().getProjectProperties();
        try (ZipFile zipFile = new ZipFile(new File(destDir, midName));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (!ze.getName().startsWith(otProj.getTargetLanguage().getLanguage()) || !ze.getName().endsWith(".sdlxliff")) continue;
                String tradosFileName = ze.getName();
                if (tradosFileName.contains("\\")) {
                    tradosFileName = tradosFileName.substring(tradosFileName.lastIndexOf("\\") + 1);
                }
                if (tradosFileName.contains("/")) {
                    tradosFileName = tradosFileName.substring(tradosFileName.lastIndexOf("/") + 1);
                }
                File tradosDir = new File(Core.getProject().getProjectProperties().getProjectRoot(), TARGET_TRADOS_DIR);
                File tradosFile = new File(tradosDir, tradosFileName);
                tradosFile.getParentFile().mkdirs();
                IOUtils.copy((InputStream)zipFile.getInputStream(ze), (OutputStream)new FileOutputStream(tradosFile));
                XLIFF_HOOK.postCompile(tradosDir, tradosFile.getCanonicalPath().substring(tradosDir.getCanonicalPath().length() + File.separator.length()), otProj.getProjectRoot() + TARGET_TRADOS_DIR + File.separator);
                this.lastCompileException = XLIFF_HOOK.lastCompileException();
                return;
            }
        }
        catch (Exception e) {
            this.lastCompileException = e;
        }
    }
}

