/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.openide.awt.Mnemonics;

public class CustomColorSelectionDialog
extends JDialog {
    private final Map<Styles.EditorColor, Color> temporaryPreferences = new EnumMap<Styles.EditorColor, Color>(Styles.EditorColor.class);
    private final ChangeListener colorChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomColorSelectionDialog.this.recordTemporaryPreference();
        }
    };
    private JButton cancelButton;
    private JColorChooser colorChooser;
    private JLabel colorStylesLabel;
    private JList colorStylesList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JButton resetAllColorsButton;
    private JButton resetCurrentColorButton;
    private JEditorPane sampleEditorPane;

    public CustomColorSelectionDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.configureColorChooser();
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomColorSelectionDialog.this.closeDialog();
            }
        });
        this.colorStylesListValueChanged(null);
        DockingUI.displayCentered(this);
        this.colorStylesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((Styles.EditorColor)((Object)value)).getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
    }

    private void configureColorChooser() {
        try {
            CustomColorSelectionDialog.removeTransparencySlider(this.colorChooser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.colorChooser.getSelectionModel().addChangeListener(this.colorChangeListener);
    }

    private void recordTemporaryPreference() {
        Styles.EditorColor selectedStyle = (Styles.EditorColor)((Object)this.colorStylesList.getSelectedValue());
        if (selectedStyle == null) {
            return;
        }
        this.temporaryPreferences.put(selectedStyle, this.colorChooser.getColor());
    }

    private void setColorChooserWithoutNotifying(Color color) {
        this.colorChooser.getSelectionModel().removeChangeListener(this.colorChangeListener);
        this.colorChooser.setColor(color == null ? Color.BLACK : color);
        this.colorChooser.getSelectionModel().addChangeListener(this.colorChangeListener);
    }

    private void initComponents() {
        this.sampleEditorPane = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.colorStylesLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.colorStylesList = new JList<Styles.EditorColor>(Styles.EditorColor.values());
        this.colorChooser = new JColorChooser();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.resetCurrentColorButton = new JButton();
        this.resetAllColorsButton = new JButton();
        this.jPanel5 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.sampleEditorPane.setEditable(false);
        this.sampleEditorPane.setText("Sample translation text");
        this.sampleEditorPane.setMinimumSize(new Dimension(400, 100));
        this.sampleEditorPane.setName("");
        this.sampleEditorPane.setPreferredSize(new Dimension(400, 100));
        this.sampleEditorPane.setRequestFocusEnabled(false);
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_COLORS_TITLE"));
        this.setIconImage(null);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.jPanel3.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.colorStylesLabel, OStrings.getString("GUI_COLORS_COLOR"));
        this.jPanel3.add((Component)this.colorStylesLabel, "North");
        this.colorStylesList.setSelectionMode(0);
        this.colorStylesList.setSelectedIndex(0);
        this.colorStylesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomColorSelectionDialog.this.colorStylesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.colorStylesList);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "West");
        this.jPanel1.add((Component)this.colorChooser, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new GridLayout(0, 1));
        Mnemonics.setLocalizedText(this.resetCurrentColorButton, OStrings.getString("GUI_COLORS_RESET_COLOR"));
        this.resetCurrentColorButton.setVerticalAlignment(1);
        this.resetCurrentColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomColorSelectionDialog.this.resetThisColorButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.resetCurrentColorButton);
        Mnemonics.setLocalizedText(this.resetAllColorsButton, OStrings.getString("GUI_COLORS_RESET_ALL_COLORS"));
        this.resetAllColorsButton.setVerticalAlignment(1);
        this.resetAllColorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomColorSelectionDialog.this.resetAllColorsButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.resetAllColorsButton);
        this.jPanel5.setLayout(new GridLayout(1, 0));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomColorSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomColorSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.cancelButton);
        this.jPanel4.add(this.jPanel5);
        this.jPanel2.add((Component)this.jPanel4, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void colorStylesListValueChanged(ListSelectionEvent evt) {
        Styles.EditorColor selectedStyle = (Styles.EditorColor)((Object)this.colorStylesList.getSelectedValue());
        if (selectedStyle == null) {
            this.colorChooser.setEnabled(false);
            this.resetCurrentColorButton.setEnabled(false);
            return;
        }
        this.colorChooser.setEnabled(true);
        this.resetCurrentColorButton.setEnabled(true);
        Color color = this.temporaryPreferences.containsKey((Object)selectedStyle) ? this.temporaryPreferences.get((Object)selectedStyle) : selectedStyle.getColor();
        this.setColorChooserWithoutNotifying(color);
    }

    private void resetAllColorsButtonActionPerformed(ActionEvent evt) {
        int confirm = JOptionPane.showConfirmDialog(this, OStrings.getString("GUI_COLORS_RESET_ALL_COLORS_CONFIRM"), OStrings.getString("GUI_COLORS_RESET_ALL_COLORS").replaceFirst("&", ""), 0, 3);
        if (confirm != 0) {
            return;
        }
        ListModel model = this.colorStylesList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Styles.EditorColor style = (Styles.EditorColor)((Object)model.getElementAt(i));
            this.temporaryPreferences.put(style, style.getDefault());
        }
        this.resetThisColorButtonActionPerformed(null);
    }

    private void resetThisColorButtonActionPerformed(ActionEvent evt) {
        Styles.EditorColor selectedStyle = (Styles.EditorColor)((Object)this.colorStylesList.getSelectedValue());
        if (selectedStyle == null) {
            return;
        }
        Color defaultColor = selectedStyle.getDefault();
        if (defaultColor == null) {
            this.setColorChooserWithoutNotifying(Color.BLACK);
            this.temporaryPreferences.put(selectedStyle, null);
        } else {
            this.colorChooser.setColor(defaultColor);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        for (Map.Entry<Styles.EditorColor, Color> e : this.temporaryPreferences.entrySet()) {
            Styles.EditorColor style = e.getKey();
            style.setColor(e.getValue());
        }
        Preferences.save();
        if (!this.temporaryPreferences.isEmpty()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("GUI_COLORS_CHANGED_RESTART"));
        }
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.temporaryPreferences.clear();
        this.setVisible(false);
        this.dispose();
    }

    private static void removeTransparencySlider(JColorChooser jc) throws Exception {
        AbstractColorChooserPanel[] colorPanels = jc.getChooserPanels();
        for (int i = 1; i < colorPanels.length; ++i) {
            AbstractColorChooserPanel cp = colorPanels[i];
            Field f = cp.getClass().getDeclaredField("panel");
            f.setAccessible(true);
            Object colorPanel = f.get(cp);
            Field f2 = colorPanel.getClass().getDeclaredField("spinners");
            f2.setAccessible(true);
            Object spinners = f2.get(colorPanel);
            Object transpSlispinner = Array.get(spinners, 3);
            if (i == colorPanels.length - 1) {
                transpSlispinner = Array.get(spinners, 4);
            }
            Field f3 = transpSlispinner.getClass().getDeclaredField("slider");
            f3.setAccessible(true);
            JSlider slider = (JSlider)f3.get(transpSlispinner);
            slider.setEnabled(false);
            slider.setVisible(false);
            Field f4 = transpSlispinner.getClass().getDeclaredField("spinner");
            f4.setAccessible(true);
            JSpinner spinner = (JSpinner)f4.get(transpSlispinner);
            spinner.setEnabled(false);
            spinner.setVisible(false);
            Field f5 = transpSlispinner.getClass().getDeclaredField("label");
            f5.setAccessible(true);
            JLabel label = (JLabel)f5.get(transpSlispinner);
            label.setVisible(false);
        }
    }
}

