/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ExternToolsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField perlPath;
    private JTextField tradosPath;
    private JTextField commandLinePath;
    private JTextField projectsDirPath;
    private JTextField fileModel;
    private JTextField projectsModel;
    private JCheckBox bUseXcompile;
    private JCheckBox bKeepAfterUse;
    private JCheckBox bRenameMethod;
    private int returnStatus = 0;

    public ExternToolsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.invalidate();
        this.pack();
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.setTitle(OStrings.getString("EXTERN_TOOLS_DIALOG"));
        this.setMinimumSize(new Dimension(400, 150));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExternToolsDialog.this.doClose(0);
            }
        });
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        JPanel line1 = new JPanel();
        JPanel line2 = new JPanel();
        JPanel line3 = new JPanel();
        JPanel line4 = new JPanel();
        JPanel line5 = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(line1);
        this.getContentPane().add(new JPanel());
        this.getContentPane().add(line2);
        this.getContentPane().add(line3);
        this.getContentPane().add(line4);
        line1.setLayout(new BorderLayout());
        line1.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_PERL_PATH")), "Before");
        this.perlPath = new JTextField();
        line1.add((Component)this.perlPath, "Center");
        this.perlPath.setText(Preferences.getPreference("perl_path"));
        JButton btnBrowse = new JButton("Browse");
        line1.add((Component)btnBrowse, "After");
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Search Perl Interpreter");
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                File file = fileChooser.getSelectedFile();
                this.perlPath.setText(file.getAbsolutePath());
            }
        });
        line2.setLayout(new BorderLayout());
        line2.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_TRADOS_PATH")), "Before");
        this.tradosPath = new JTextField();
        line2.add((Component)this.tradosPath, "Center");
        this.tradosPath.setText(Preferences.getPreference("trados_path"));
        btnBrowse = new JButton("Browse");
        line2.add((Component)btnBrowse, "After");
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setDialogTitle("Search Trados Directory");
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                File file = fileChooser.getSelectedFile();
                this.tradosPath.setText(file.getAbsolutePath());
            }
        });
        line3.setLayout(new BorderLayout());
        line3.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_TRADOS_COMMAND")), "Before");
        this.commandLinePath = new JTextField();
        line3.add((Component)this.commandLinePath, "Center");
        this.commandLinePath.setText(Preferences.getPreference("trados_command_line"));
        btnBrowse = new JButton("Find");
        line3.add((Component)btnBrowse, "After");
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser(new File(this.tradosPath.getText()));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setDialogTitle("Search for command line exe");
            fileChooser.setFileFilter(new FileNameExtensionFilter("Executable file", "exe"));
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                File file = fileChooser.getSelectedFile();
                this.commandLinePath.setText(file.getName() + " %s");
            }
        });
        line4.setLayout(new BoxLayout(line4, 0));
        this.bUseXcompile = new JCheckBox(OStrings.getString("EXT_TOOLS_USE_XCOMPILE"));
        line4.add(this.bUseXcompile);
        this.bUseXcompile.setSelected(Preferences.isPreferenceDefault("trados_use_cross_compile", false));
        this.bKeepAfterUse = new JCheckBox(OStrings.getString("EXT_TOOLS_KEEP_PROJECT"));
        line4.add(this.bKeepAfterUse);
        this.bKeepAfterUse.setSelected(Preferences.isPreferenceDefault("trados_keep_intermediate", false));
        this.bRenameMethod = new JCheckBox(OStrings.getString("EXT_TOOLS_RENAME_METHOD"));
        line4.add(this.bRenameMethod);
        this.bRenameMethod.setSelected(Preferences.isPreferenceDefault("trados_rename_method", false));
        JPanel lineProjectsDir = new JPanel();
        this.getContentPane().add(lineProjectsDir);
        lineProjectsDir.setLayout(new BorderLayout());
        lineProjectsDir.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_PROJECTS_DIR")), "Before");
        this.projectsDirPath = new JTextField(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.getText().length() == 0) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    int c0 = this.getBackground().getRGB();
                    int c1 = this.getForeground().getRGB();
                    int m = -16843010;
                    int c2 = ((c0 & m) >>> 1) + ((c1 & m) >>> 1);
                    g.setColor(new Color(c2, true));
                    g.drawString(OStrings.getString("EXT_TOOLS_PROJECTS_TIP"), this.getInsets().left, this.getHeight() / 2 + g.getFontMetrics().getAscent() / 2 - 2);
                }
            }
        };
        lineProjectsDir.add((Component)this.projectsDirPath, "Center");
        if (Preferences.getPreferenceDefault("trados_proj_path", "").length() > 0) {
            this.projectsDirPath.setText(Preferences.getPreference("trados_proj_path"));
        }
        btnBrowse = new JButton("Find");
        lineProjectsDir.add((Component)btnBrowse, "After");
        btnBrowse.addActionListener(evt -> {
            JFileChooser fileChooser = new JFileChooser(this.projectsDirPath.getText());
            fileChooser.setFileSelectionMode(1);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Search for Trados projects directory");
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                StringBuffer buf = new StringBuffer();
                for (File f : fileChooser.getSelectedFiles()) {
                    buf.append(f.toString()).append(";");
                }
                this.projectsDirPath.setText(buf.toString());
            }
        });
        JPanel lineFileModel = new JPanel();
        this.getContentPane().add(lineFileModel);
        lineFileModel.setLayout(new BorderLayout());
        lineFileModel.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_FILE_MODEL")), "Before");
        this.fileModel = new JTextField();
        lineFileModel.add((Component)this.fileModel, "Center");
        JPanel lineProjectsModel = new JPanel();
        this.getContentPane().add(lineProjectsModel);
        lineProjectsModel.setLayout(new BorderLayout());
        lineProjectsModel.add((Component)new JLabel(OStrings.getString("EXT_TOOLS_PROJECTS_MODEL")), "Before");
        this.projectsModel = new JTextField();
        lineProjectsModel.add((Component)this.projectsModel, "Center");
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(evt -> this.okButtonActionPerformed(evt));
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(evt -> this.doClose(0));
        this.getContentPane().add(new JPanel());
        this.getContentPane().add(line5);
        line5.setLayout(new FlowLayout(2));
        line5.add(this.okButton);
        line5.add(this.cancelButton);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("perl_path", this.perlPath.getText());
        Preferences.setPreference("trados_path", this.tradosPath.getText());
        Preferences.setPreference("trados_command_line", this.commandLinePath.getText());
        Preferences.setPreference("trados_use_cross_compile", this.bUseXcompile.isSelected());
        Preferences.setPreference("trados_keep_intermediate", this.bKeepAfterUse.isSelected());
        Preferences.setPreference("trados_rename_method", this.bRenameMethod.isSelected());
        Preferences.setPreference("trados_proj_path", this.projectsDirPath.getText());
        Preferences.setPreference("trados_proj_model", this.projectsModel.getText());
        Preferences.setPreference("trados_file_model", this.fileModel.getText());
        this.doClose(1);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

