/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.omegat.gui.glossary.GlossaryEntryView;
import org.omegat.gui.glossary.GlossarySortCriteria;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class GlossaryConfigDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox activeSrc;
    private JCheckBox activeTra;
    private JCheckBox ignoreTags;
    private JCheckBox removeSubwords;
    private SearchModeBox modeBox;
    private JCheckBox suggest;
    private JCheckBox cbDoMerge;
    private JComboBox templateList;
    private JList<GlossarySortCriteria.WithDirection> srcOrderList;
    private JList<GlossarySortCriteria.WithDirection> traOrderList;
    private int returnStatus = 0;

    public GlossaryConfigDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryConfigDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.activeSrc.setSelected(Preferences.isPreference("transtips_src"));
        this.activeTra.setSelected(Preferences.isPreference("transtips_tra"));
        this.suggest.setSelected(Preferences.isPreference("transtips_suggest"));
        this.ignoreTags.setSelected(Preferences.isPreference("glossary_remove_tags"));
        this.removeSubwords.setSelected(Preferences.isPreference("glossary_remove_subwords"));
        this.cbDoMerge.setSelected(Preferences.isPreferenceDefault("glossary_pane_do_merge", true));
        this.templateList.setSelectedItem(ScriptItem.find(this.templateList, Preferences.getPreference("glossary_pane_template")));
        this.modeBox.loadPreferences("transtips_");
        StringBuffer configBuf = new StringBuffer(Preferences.getPreferenceDefault("glossary_pane_sort_order", "ACPL;ACPL"));
        GlossaryConfigDialog.fillModel((DefaultListModel)this.srcOrderList.getModel(), configBuf);
        GlossaryConfigDialog.fillModel((DefaultListModel)this.traOrderList.getModel(), configBuf);
        this.invalidate();
        this.pack();
        this.setResizable(false);
    }

    private static void fillModel(DefaultListModel<GlossarySortCriteria.WithDirection> model, StringBuffer buf) {
        EnumSet<GlossarySortCriteria> set = EnumSet.noneOf(GlossarySortCriteria.class);
        while (buf.length() != 0 && buf.charAt(0) != ';') {
            GlossarySortCriteria crit = GlossarySortCriteria.forChar(buf.charAt(0));
            model.addElement(new GlossarySortCriteria.WithDirection(crit, Character.isLowerCase(buf.charAt(0))));
            set.add(crit);
            buf.delete(0, 1);
        }
        if (buf.toString().startsWith(";")) {
            buf.delete(0, 1);
        }
        EnumSet.allOf(GlossarySortCriteria.class).forEach(c0 -> {
            if (!set.contains(c0)) {
                model.addElement(new GlossarySortCriteria.WithDirection((GlossarySortCriteria)((Object)c0), false));
            }
        });
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.activeSrc = new JCheckBox();
        Mnemonics.setLocalizedText(this.activeSrc, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_UNDERLINE_SRC"));
        this.activeTra = new JCheckBox();
        Mnemonics.setLocalizedText(this.activeTra, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_UNDERLINE_TRA"));
        this.suggest = new JCheckBox();
        Mnemonics.setLocalizedText(this.suggest, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_SUGGEST"));
        this.ignoreTags = new JCheckBox();
        this.removeSubwords = new JCheckBox();
        Mnemonics.setLocalizedText(this.ignoreTags, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_IGNORE_TAGS"));
        Mnemonics.setLocalizedText(this.removeSubwords, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_REMOVE_SUBWORDS"));
        Mnemonics.setLocalizedText(this.suggest, OStrings.getString("TF_OPTIONSMENU_GLOSSARY_SUGGEST"));
        this.modeBox = new SearchModeBox(1, ITokenizer.StemmingMode.GLOSSARY, null);
        this.setTitle(OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GlossaryConfigDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Box buttonsBox = Box.createHorizontalBox();
        this.add((Component)buttonsBox, "South");
        Box bCheck = Box.createVerticalBox();
        this.add((Component)bCheck, "North");
        Box bCheckTips = Box.createHorizontalBox();
        bCheck.add(bCheckTips);
        bCheckTips.add(this.activeSrc);
        bCheckTips.add(this.activeTra);
        Box bCheckOther = Box.createHorizontalBox();
        bCheck.add(bCheckOther);
        bCheckOther.add(this.suggest);
        bCheckOther.add(this.ignoreTags);
        bCheckOther.add(this.removeSubwords);
        Box boxTemplate = Box.createHorizontalBox();
        bCheck.add(boxTemplate);
        boxTemplate.add(new JLabel(OStrings.getString("TF_OPTIONSMENU_GLOSSARY_TEMPLATE")));
        this.templateList = new JComboBox();
        boxTemplate.add(this.templateList);
        this.templateList.addItem(new ScriptItem(OStrings.getString("TF_OPTIONSMENU_GLOSSARY_TEMPLATE_HARDCODED_DEFAULT"), "result.appendSource(entry.srcText); result.append(\": \");\ndef translations  = entry.getLocTerms(true)\ndef count = translations.size()\ntranslations.each { tra -> \n\tresult.appendTarget(tra, entry.hasPriorities(tra));\n\tdef merged = entry.getEntriesFor(tra)\n\tdef commentsList = merged.collect { it.commentText }.findAll { (it != null) && (it.length() > 0) }.unique() \n\tfor (com in commentsList) {\n\t\tresult.append(\"\\n -> \"); result.appendComment(com); \n\t}\n\tif (count-- > 1) result.append(\",\");\n}\nresult.append(\"\\n\");\n"));
        File scriptsDir = new File(Preferences.getPreferenceDefault("scripts_dir", StaticUtils.installDir() + "/scripts") + "/layout/glossary");
        if (scriptsDir.exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(scriptsDir.toPath());){
                for (Path p : stream) {
                    File f = p.toFile();
                    if (!f.getName().endsWith(".groovy")) continue;
                    this.templateList.addItem(new ScriptItem(f.getName(), f));
                }
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        this.cbDoMerge = new JCheckBox("Merge results", true);
        boxTemplate.add(this.cbDoMerge);
        Box bSortOrder = Box.createHorizontalBox();
        bCheck.add(bSortOrder);
        bSortOrder.add(new JLabel(OStrings.getString("TF_OPTIONSMENU_GLOSSARY_SORT")));
        DefaultListModel srcModel = new DefaultListModel();
        this.srcOrderList = new JList(srcModel);
        bSortOrder.add(this.srcOrderList);
        Box bSortButtonsSrc = Box.createVerticalBox();
        bSortOrder.add(bSortButtonsSrc);
        JButton btnSrcUp = new JButton("^ UP");
        bSortButtonsSrc.add(btnSrcUp);
        JButton btnSrcDown = new JButton("v DOWN");
        bSortButtonsSrc.add(btnSrcDown);
        JButton btnSrcReverse = new JButton("v DESC");
        bSortButtonsSrc.add(btnSrcReverse);
        btnSrcUp.addActionListener(ev -> {
            if (this.srcOrderList.getSelectedIndex() > 0) {
                int idx = this.srcOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)srcModel.getElementAt(idx);
                srcModel.remove(idx);
                srcModel.add(idx - 1, el);
            }
        });
        btnSrcDown.addActionListener(ev -> {
            if (this.srcOrderList.getSelectedIndex() >= 0 && this.srcOrderList.getSelectedIndex() < 2) {
                int idx = this.srcOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)srcModel.getElementAt(idx);
                srcModel.remove(idx);
                srcModel.add(idx + 1, el);
            }
        });
        btnSrcReverse.addActionListener(ev -> {
            if (this.srcOrderList.getSelectedIndex() >= 0) {
                int idx = this.srcOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)srcModel.getElementAt(idx);
                boolean bl = el.desc = !el.desc;
                if (el.desc) {
                    btnSrcReverse.setLabel("^ ASC");
                } else {
                    btnSrcReverse.setLabel("v DESC");
                }
                this.srcOrderList.repaint();
            }
        });
        DefaultListModel traModel = new DefaultListModel();
        this.traOrderList = new JList(traModel);
        bSortOrder.add(this.traOrderList);
        Box bSortButtonsTra = Box.createVerticalBox();
        bSortOrder.add(bSortButtonsTra);
        JButton btnTraUp = new JButton("^ UP");
        bSortButtonsTra.add(btnTraUp);
        JButton btnTraDown = new JButton("v DOWN");
        bSortButtonsTra.add(btnTraDown);
        JButton btnTraReverse = new JButton("v DESC");
        bSortButtonsTra.add(btnTraReverse);
        btnTraUp.addActionListener(ev -> {
            if (this.traOrderList.getSelectedIndex() > 0) {
                int idx = this.traOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)traModel.getElementAt(idx);
                traModel.remove(idx);
                traModel.add(idx - 1, el);
            }
        });
        btnTraDown.addActionListener(ev -> {
            if (this.traOrderList.getSelectedIndex() >= 0 && this.traOrderList.getSelectedIndex() < 2) {
                int idx = this.traOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)traModel.getElementAt(idx);
                traModel.remove(idx);
                traModel.add(idx + 1, el);
            }
        });
        btnTraReverse.addActionListener(ev -> {
            if (this.traOrderList.getSelectedIndex() >= 0) {
                int idx = this.traOrderList.getSelectedIndex();
                GlossarySortCriteria.WithDirection el = (GlossarySortCriteria.WithDirection)traModel.getElementAt(idx);
                boolean bl = el.desc = !el.desc;
                if (el.desc) {
                    btnTraReverse.setLabel("^ ASC");
                } else {
                    btnTraReverse.setLabel("v DESC");
                }
                this.traOrderList.repaint();
            }
        });
        this.add((Component)this.modeBox, "Center");
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryConfigDialog.this.okButtonActionPerformed(evt);
            }
        });
        JPanel pButtons = new JPanel();
        this.add((Component)pButtons, "South");
        pButtons.add((Component)buttonsBox, "East");
        buttonsBox.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonsBox.add(this.cancelButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int i;
        this.modeBox.savePreferences("transtips_");
        Preferences.setPreference("transtips_src", this.activeSrc.isSelected());
        Preferences.setPreference("transtips_tra", this.activeTra.isSelected());
        Preferences.setPreference("transtips_suggest", this.suggest.isSelected());
        Preferences.setPreference("glossary_pane_do_merge", this.cbDoMerge.isSelected());
        Preferences.setPreference("glossary_pane_template", ((ScriptItem)this.templateList.getSelectedItem()).toOption());
        GlossaryEntryView.engine = null;
        Preferences.setPreference("glossary_remove_tags", this.ignoreTags.isSelected());
        Preferences.setPreference("glossary_remove_subwords", this.removeSubwords.isSelected());
        StringBuffer sortOrderSpec = new StringBuffer();
        for (i = 0; i < this.srcOrderList.getModel().getSize(); ++i) {
            sortOrderSpec.append(this.srcOrderList.getModel().getElementAt(i).shortName());
        }
        sortOrderSpec.append(";");
        for (i = 0; i < this.traOrderList.getModel().getSize(); ++i) {
            sortOrderSpec.append(this.traOrderList.getModel().getElementAt(i).shortName());
        }
        Preferences.setPreference("glossary_pane_sort_order", sortOrderSpec);
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static class ScriptItem {
        String name;
        Object item;

        public ScriptItem(String name, Object item) {
            this.name = name;
            this.item = item;
        }

        public String toString() {
            return this.name;
        }

        public String toOption() {
            if (this.item instanceof File) {
                return "file:" + this.name;
            }
            return this.item.toString();
        }

        public static ScriptItem find(JComboBox items, String findName) {
            for (int i = 0; i < items.getItemCount(); ++i) {
                ScriptItem item0 = (ScriptItem)items.getItemAt(i);
                if (item0.name.equals(findName)) {
                    return item0;
                }
                if (!findName.startsWith("file:") || !item0.name.equals(findName.substring(5))) continue;
                return item0;
            }
            return (ScriptItem)items.getItemAt(0);
        }
    }
}

