/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.omegat.core.Core;
import org.omegat.core.glossaries.FileGlossary;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.glossaries.GlossaryEntryWithProperties;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;

public class GlossaryReaderTBX
extends FileGlossary {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();
    private TBXInfo fileInfo;

    public GlossaryReaderTBX(File file) throws Exception {
        super(file);
        TBXContents contents = GlossaryReaderTBX.readMartif(new FileInputStream(file), this);
        this.entries = contents.entries;
        this.fileInfo = contents;
    }

    public static TBXContents readFromString(String data, IGlossary origin) throws Exception {
        return GlossaryReaderTBX.readMartif(new ByteArrayInputStream(data.getBytes()), origin);
    }

    @Override
    public String getFormat() {
        return this.fileInfo.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TBXContents readMartif(InputStream is, IGlossary origin) throws Exception {
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            TBXContents contents = new TBXContents();
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                if (reader.getLocalName().equals("termEntry") || reader.getLocalName().equals("conceptEntry")) {
                    GlossaryReaderTBX.readTermEntry(contents.entries, reader, origin);
                    continue;
                }
                if (reader.getLocalName().equals("tbx")) {
                    contents.version = "3.0";
                    contents.dialect = reader.getAttributeValue(null, "type");
                    continue;
                }
                if (reader.getLocalName().equals("martif")) {
                    contents.version = "2.0";
                    continue;
                }
                if (!"XCSURI".equals(reader.getAttributeValue(null, "type"))) continue;
                reader.next();
                contents.dialect = reader.getText();
            }
            Log.log(origin.getShortName() + ": Read " + contents.entries.size() + " entries");
            TBXContents tBXContents = contents;
            return tBXContents;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void readTermEntry(List<GlossaryEntryStore> result, XMLStreamReader reader, IGlossary origin) throws Exception {
        String sLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String tLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        StringBuilder note = new StringBuilder();
        ArrayList<TMXProp> enProp = new ArrayList<TMXProp>();
        ArrayList<TMXProp> srcProp = new ArrayList<TMXProp>();
        ArrayList<TMXProp> traProp = new ArrayList<TMXProp>();
        ArrayList<String> sTerms = new ArrayList<String>();
        ArrayList<String> tTerms = new ArrayList<String>();
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && (reader.getLocalName().equals("termEntry") || reader.getLocalName().equals("conceptEntry"))) {
                for (String s : sTerms) {
                    boolean addedForLang = false;
                    for (String t : tTerms) {
                        result.add(new GlossaryEntryWithProperties(s, t, note.toString(), enProp, srcProp, traProp, origin));
                        addedForLang = true;
                    }
                    if (addedForLang) continue;
                    result.add(new GlossaryEntryWithProperties(s, "", note.toString(), enProp, srcProp, traProp, origin));
                }
                return;
            }
            if (next != 1) continue;
            if (reader.getLocalName().equals("note")) {
                GlossaryReaderTBX.appendLine(note, GlossaryReaderTBX.readContent(reader, "note"));
                continue;
            }
            if (reader.getLocalName().equals("descripGrp")) {
                GlossaryReaderTBX.appendProperty(enProp, "", reader);
                continue;
            }
            if (reader.getLocalName().equals("descrip")) {
                GlossaryReaderTBX.appendProperty(enProp, "", reader);
                continue;
            }
            if (!reader.getLocalName().equals("langSet") && !reader.getLocalName().equals("langSec")) continue;
            String lang = reader.getAttributeValue(null, "lang");
            lang = new Language(lang).getLanguageCode();
            while (reader.hasNext() && ((next = reader.next()) != 2 || !reader.getLocalName().equals("langSet") && !reader.getLocalName().equals("langSec"))) {
                if (next != 1) continue;
                if (reader.getLocalName().equals("tig") || reader.getLocalName().equals("ntig") || reader.getLocalName().equals("termSec")) {
                    if (sLang.equalsIgnoreCase(lang)) {
                        sTerms.add(GlossaryReaderTBX.readContent(reader, "term"));
                        continue;
                    }
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    tTerms.add(GlossaryReaderTBX.readContent(reader, "term"));
                    continue;
                }
                if (reader.getLocalName().equals("termNote")) {
                    if (sLang.equalsIgnoreCase(lang)) {
                        GlossaryReaderTBX.appendProperty(srcProp, "", reader);
                        continue;
                    }
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    GlossaryReaderTBX.appendProperty(traProp, "", reader);
                    continue;
                }
                if (reader.getLocalName().equals("descripGrp")) {
                    if (sLang.equalsIgnoreCase(lang)) {
                        GlossaryReaderTBX.appendProperty(srcProp, "", reader);
                        continue;
                    }
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    GlossaryReaderTBX.appendProperty(traProp, "", reader);
                    continue;
                }
                if (reader.getLocalName().equals("descrip")) {
                    if (sLang.equalsIgnoreCase(lang)) {
                        GlossaryReaderTBX.appendProperty(srcProp, "", reader);
                        continue;
                    }
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    GlossaryReaderTBX.appendProperty(traProp, "", reader);
                    continue;
                }
                if (!reader.getLocalName().equals("admin")) continue;
                if (sLang.equalsIgnoreCase(lang)) {
                    GlossaryReaderTBX.appendProperty(srcProp, "", reader);
                    continue;
                }
                if (!tLang.equalsIgnoreCase(lang)) continue;
                GlossaryReaderTBX.appendProperty(traProp, "", reader);
            }
        }
    }

    protected static void appendProperty(List<TMXProp> list, String prefix, XMLStreamReader reader) throws XMLStreamException {
        Object line = null;
        if (reader.getLocalName().equals("descrip")) {
            if ("context".equals(reader.getAttributeValue(null, "type"))) {
                if (Preferences.isPreferenceDefault("glossary_tbx_display_context", true)) {
                    list.add(new TMXProp(prefix + "context", GlossaryReaderTBX.readContent(reader, "descrip")));
                }
            } else {
                list.add(new TMXProp(prefix + reader.getAttributeValue(null, "type"), GlossaryReaderTBX.readContent(reader, "descrip")));
            }
        }
        if (reader.getLocalName().equals("descripGrp")) {
            int next;
            String prefix2 = "";
            if (reader.getAttributeValue(null, "id") != null) {
                prefix2 = reader.getAttributeValue(null, "id") + ".";
            }
            while (reader.hasNext() && ((next = reader.next()) != 2 || !reader.getLocalName().equals("descripGrp"))) {
                if (next != 1 || !reader.getLocalName().equals("descrip")) continue;
                GlossaryReaderTBX.appendProperty(list, prefix2 + prefix, reader);
            }
        }
        if (reader.getLocalName().equals("termNote")) {
            list.add(new TMXProp(prefix + reader.getAttributeValue(null, "type"), GlossaryReaderTBX.readContent(reader, "termNote")));
        }
        if (reader.getLocalName().equals("admin")) {
            list.add(new TMXProp(prefix + reader.getAttributeValue(null, "type"), GlossaryReaderTBX.readContent(reader, "admin")));
        }
    }

    protected static void appendLine(StringBuilder str, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (str.length() > 0) {
            str.append('\n');
        }
        str.append(line);
    }

    protected static String readContent(XMLStreamReader reader, String mark) throws XMLStreamException {
        StringBuilder res = new StringBuilder();
        boolean in = reader.getLocalName().equals(mark);
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2) {
                if (reader.getLocalName().equals(mark)) break;
                if (reader.getLocalName().equals("hi") && in) {
                    res.append("* ");
                }
            }
            if (next == 1) {
                if (reader.getLocalName().equals(mark)) {
                    in = true;
                } else if (reader.getLocalName().equals("hi") && in) {
                    res.append(" *");
                }
            }
            if (next != 4 || !in) continue;
            res.append(reader.getText());
        }
        return res.toString();
    }

    public static class TBXContents
    extends TBXInfo {
        public List<GlossaryEntryStore> entries = new ArrayList<GlossaryEntryStore>();
    }

    public static class TBXInfo {
        public String version = null;
        public String dialect = null;

        public String getFormat() {
            return "TBX" + (this.version == null ? "" : " " + this.version) + (this.dialect == null ? "" : " " + this.dialect);
        }
    }
}

