/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.StreamSupport;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.gui.glossary.GlossaryEntryView;

public class MergedGlossaryEntries
extends GlossaryEntryView {
    private Collection<GlossaryEntryStore> entries;

    public MergedGlossaryEntries(String src, Collection<GlossaryEntryStore> entries) {
        super(src);
        this.entries = entries;
    }

    @Override
    public Collection<GlossaryEntryStore> getMergedEntries() {
        return this.entries;
    }

    @Override
    public Collection<String> getLocTerms(boolean unique) {
        ArrayList<String> res = new ArrayList<String>(unique ? this.entries.size() / 3 : this.entries.size());
        for (GlossaryEntryStore ge : this.entries) {
            if (res.contains(ge.getLocText())) continue;
            res.add(ge.getLocText());
        }
        return res;
    }

    @Override
    public Iterable<GlossaryEntryStore> getEntriesFor(String tra) {
        return () -> StreamSupport.stream(this.entries.spliterator(), false).filter(entry -> entry.getLocText().equals(tra)).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            GlossaryEntryStore otherStore = (GlossaryEntryStore)o;
            return this.entries.size() == 1 && this.entries.iterator().next().equals(otherStore);
        }
        catch (ClassCastException cce1) {
            try {
                MergedGlossaryEntries otherView = (MergedGlossaryEntries)o;
                return this.entries.equals(otherView.entries);
            }
            catch (ClassCastException cce2) {
                return false;
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        for (GlossaryEntryStore store : this.entries) {
            hash += store.hashCode();
        }
        return hash;
    }

    public boolean hasPriorities() {
        for (GlossaryEntryStore ge : this.entries) {
            if (!ge.getPriority()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPriorities(String tra) {
        for (GlossaryEntryStore ge : this.entries) {
            if (!ge.getPriority() || !ge.getLocText().equals(tra)) continue;
            return true;
        }
        return false;
    }
}

