/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.TextExpression;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class TransTips {
    public static void search(String sourceText, GlossaryEntryStore glossaryEntry, Search callback, boolean isSource) {
        if (isSource) {
            TransTips.searchPhrase(sourceText, glossaryEntry, glossaryEntry.getSrcText(), callback, true);
        } else {
            for (String tra : glossaryEntry.getLocTerms(true)) {
                TransTips.searchPhrase(sourceText, glossaryEntry, tra, callback, false);
            }
        }
    }

    private static void searchPhrase(String sourceText, GlossaryEntryStore glossaryEntry, String phrase, Search callback, boolean isSource) {
        List<SearchMatch> matches;
        if (phrase == null || phrase.equals("")) {
            return;
        }
        SearchModeBox dummyBox = new SearchModeBox(0, ITokenizer.StemmingMode.GLOSSARY, null);
        dummyBox.loadPreferences("transtips_");
        TextExpression expr = dummyBox.buildExpression(phrase, false, isSource);
        ArrayList<Integer> startTags = null;
        ArrayList<Integer> endTags = null;
        if (Preferences.isPreferenceDefault("glossary_remove_tags", false)) {
            startTags = new ArrayList<Integer>();
            endTags = new ArrayList<Integer>();
            Matcher m = Pattern.compile("</?\\w+/?>").matcher(sourceText);
            while (m.find()) {
                startTags.add(m.start());
                endTags.add(m.end());
            }
            sourceText = sourceText.replaceAll("</?\\w+/?>", "");
        }
        if ((matches = expr.searchString(sourceText)) == null) {
            return;
        }
        if (startTags != null) {
            block1: for (int i = 0; i < matches.size(); ++i) {
                int j;
                for (j = 0; j < startTags.size() && (Integer)startTags.get(j) <= matches.get(i).getStart(); ++j) {
                    matches.get(i).move((Integer)endTags.get(j) - (Integer)startTags.get(j));
                }
                for (j = 0; j < startTags.size(); ++j) {
                    if ((Integer)startTags.get(j) <= matches.get(i).getStart()) continue;
                    if ((Integer)startTags.get(j) >= matches.get(i).getEnd()) continue block1;
                    matches.get(i).addLength((Integer)endTags.get(j) - (Integer)startTags.get(j));
                }
            }
        }
        for (SearchMatch found : matches) {
            callback.found(glossaryEntry, found.getStart(), found.getEnd());
        }
    }

    public static interface Search {
        public void found(GlossaryEntryStore var1, int var2, int var3);
    }
}

