/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectOptions;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.Searcher;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.search.ReplaceDialog;
import org.omegat.gui.search.SearchVarExpansion;
import org.omegat.gui.search.SearchWindow;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

class EntryListPane
extends JTextPane {
    protected static final AttributeSet FOUND_MARK = Styles.createAttributeSet(Styles.EditorColor.COLOR_SEARCH_RESULT.getColor(), null, false, null);
    protected static final AttributeSet FOUND_MARK_BOLD = Styles.createAttributeSet(Styles.EditorColor.COLOR_SEARCH_RESULT.getColor(), null, true, null);
    protected static final AttributeSet REPLACE_MARK = Styles.createAttributeSet(Styles.EditorColor.COLOR_SEARCH_REPLACE.getColor(), null, false, null);
    protected static final AttributeSet REPLACE_MARK_BOLD = Styles.createAttributeSet(Styles.EditorColor.COLOR_SEARCH_REPLACE.getColor(), null, true, null);
    protected static final int MARKS_PER_REQUEST = 100;
    protected static final String ENTRY_SEPARATOR = "---------\n";
    private static final String KEY_GO_TO_NEXT_SEGMENT = "gotoNextSegmentMenuItem";
    private static final String KEY_GO_TO_PREVIOUS_SEGMENT = "gotoPreviousSegmentMenuItem";
    private static final String KEY_TRANSFER_FOCUS = "transferFocus";
    private static final String KEY_TRANSFER_FOCUS_BACKWARD = "transferFocusBackward";
    private static final int ENTRY_LIST_INDEX_NO_ENTRIES = -1;
    private static final int ENTRY_LIST_INDEX_END_OF_TEXT = -2;
    private volatile Searcher m_searcher;
    private final List<Integer> m_entryList = new ArrayList<Integer>();
    private final List<Integer> m_offsetList = new ArrayList<Integer>();
    private final Map<Integer, IEditor.CaretPosition> m_firstMatchList = new HashMap<Integer, IEditor.CaretPosition>();
    private DisplayMatches currentlyDisplayedMatches;
    private int numberOfResults;
    private SearchWindow m_parent;
    private boolean useTabForAdvance;
    private boolean autoSyncWithEditor;
    private final SegmentHighlighter highlighter = new SegmentHighlighter();

    private static void bindKeyStrokesFromMainMenuShortcuts(InputMap map) {
        PropertiesShortcuts.MainMenuShortcuts.bindKeyStrokes(map, KEY_GO_TO_NEXT_SEGMENT, KEY_GO_TO_PREVIOUS_SEGMENT);
    }

    private static InputMap createDefaultInputMap(InputMap parent) {
        InputMap map = new InputMap();
        map.setParent(parent);
        EntryListPane.bindKeyStrokesFromMainMenuShortcuts(map);
        int CTRL_CMD_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        map.put(KeyStroke.getKeyStroke(10, 0), KEY_GO_TO_NEXT_SEGMENT);
        map.put(KeyStroke.getKeyStroke(10, CTRL_CMD_MASK), KEY_GO_TO_PREVIOUS_SEGMENT);
        return map;
    }

    private static InputMap createDefaultInputMapUseTab(InputMap parent) {
        InputMap map = new InputMap();
        map.setParent(parent);
        EntryListPane.bindKeyStrokesFromMainMenuShortcuts(map);
        int CTRL_CMD_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        map.put(KeyStroke.getKeyStroke(9, 0), KEY_GO_TO_NEXT_SEGMENT);
        map.put(KeyStroke.getKeyStroke(9, 64), KEY_GO_TO_PREVIOUS_SEGMENT);
        map.put(KeyStroke.getKeyStroke(9, CTRL_CMD_MASK), KEY_TRANSFER_FOCUS);
        map.put(KeyStroke.getKeyStroke(9, CTRL_CMD_MASK | 0x40), KEY_TRANSFER_FOCUS_BACKWARD);
        return map;
    }

    public EntryListPane(SearchWindow parent) {
        this.setDocument(new DefaultStyledDocument());
        this.setDragEnabled(true);
        if (Core.getMainWindow() != null) {
            this.setFont(Core.getMainWindow().getApplicationFont());
        }
        StaticUIUtils.makeCaretAlwaysVisible(this);
        StaticUIUtils.setCaretUpdateEnabled(this, false);
        this.m_parent = parent;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!EntryListPane.this.autoSyncWithEditor && e.getClickCount() == 2 && !EntryListPane.this.m_entryList.isEmpty()) {
                    EntryListPane.this.getActiveDisplayedEntry().gotoEntryInEditor();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                boolean useTabForAdvance = Core.getEditor().getSettings().isUseTabForAdvance();
                if (EntryListPane.this.useTabForAdvance != useTabForAdvance) {
                    EntryListPane.this.useTabForAdvance = useTabForAdvance;
                    EntryListPane.this.initInputMap(useTabForAdvance);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SwingUtilities.invokeLater(EntryListPane.this.highlighter);
                if (EntryListPane.this.autoSyncWithEditor) {
                    EntryListPane.this.getActiveDisplayedEntry().gotoEntryInEditor();
                }
            }
        });
        this.initActions();
        this.useTabForAdvance = Core.getEditor() != null ? Core.getEditor().getSettings().isUseTabForAdvance() : false;
        this.autoSyncWithEditor = Preferences.isPreferenceDefault("search_window_auto_sync", false);
        this.initInputMap(this.useTabForAdvance);
        this.setEditable(false);
    }

    private void initInputMap(boolean useTabForAdvance) {
        this.setFocusTraversalKeysEnabled(!useTabForAdvance);
        InputMap parent = this.getInputMap().getParent();
        InputMap newMap = useTabForAdvance ? EntryListPane.createDefaultInputMapUseTab(parent) : EntryListPane.createDefaultInputMap(parent);
        this.setInputMap(0, newMap);
    }

    void setAutoSyncWithEditor(boolean autoSyncWithEditor) {
        this.autoSyncWithEditor = autoSyncWithEditor;
        if (autoSyncWithEditor) {
            this.getActiveDisplayedEntry().gotoEntryInEditor();
        }
    }

    public void displaySearchResult(ProjectOptions config, Collection<SearchResultEntry> entries, int numberOfResults, String templateString, boolean boldWords) {
        UIThreadsUtil.mustBeSwingThread();
        this.numberOfResults = numberOfResults;
        this.currentlyDisplayedMatches = null;
        this.m_entryList.clear();
        this.m_offsetList.clear();
        this.m_firstMatchList.clear();
        if (entries == null) {
            this.setText("");
            return;
        }
        this.currentlyDisplayedMatches = new DisplayMatches(config, entries, templateString, boldWords);
        this.highlighter.reset();
        SwingUtilities.invokeLater(this.highlighter);
        if (this.autoSyncWithEditor) {
            this.getActiveDisplayedEntry().gotoEntryInEditor();
        }
    }

    private int getActiveEntryListIndex() {
        int nrEntries = this.getNrEntries();
        if (nrEntries == 0) {
            return -1;
        }
        if (nrEntries > 0) {
            int pos = this.getSelectionStart();
            for (int i = 0; i < nrEntries; ++i) {
                if (pos >= this.m_offsetList.get(i)) continue;
                return i;
            }
        }
        return -2;
    }

    private void addMessage(StringBuilder m_stringBuf, String message) {
        if (m_stringBuf.length() > 0) {
            m_stringBuf.append(ENTRY_SEPARATOR);
        }
        m_stringBuf.append(message);
    }

    public void reset() {
        this.displaySearchResult(null, null, 0, "", false);
    }

    public int getNrEntries() {
        return this.m_offsetList.size();
    }

    public int getNrMatches() {
        return this.currentlyDisplayedMatches.matches.size();
    }

    public List<Integer> getEntryList() {
        return this.m_entryList;
    }

    public List<Integer> getOffsetList() {
        return this.m_offsetList;
    }

    public Searcher getSearcher() {
        return this.m_searcher;
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(KEY_GO_TO_NEXT_SEGMENT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EntryListPane.this.getActiveDisplayedEntry().getNext().activate();
            }
        });
        actionMap.put(KEY_GO_TO_PREVIOUS_SEGMENT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EntryListPane.this.getActiveDisplayedEntry().getPrevious().activate();
            }
        });
        actionMap.put(KEY_TRANSFER_FOCUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EntryListPane.this.transferFocus();
            }
        });
        actionMap.put(KEY_TRANSFER_FOCUS_BACKWARD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EntryListPane.this.transferFocusBackward();
            }
        });
    }

    private DisplayedEntry getActiveDisplayedEntry() {
        int activeEntryListIndex = this.getActiveEntryListIndex();
        switch (activeEntryListIndex) {
            case -1: {
                return new EmptyDisplayedEntry();
            }
            case -2: {
                return new DisplayedEntryImpl(this.getNrEntries());
            }
        }
        return new DisplayedEntryImpl(activeEntryListIndex);
    }

    private class SegmentHighlighter
    implements Runnable {
        private final MutableAttributeSet attrNormal = new SimpleAttributeSet();
        private final MutableAttributeSet attrActive;
        private int entryListIndex = -1;
        private int offset = -1;
        private int length = -1;

        public SegmentHighlighter() {
            StyleConstants.setBackground(this.attrNormal, EntryListPane.this.getBackground());
            this.attrActive = new SimpleAttributeSet();
            StyleConstants.setBackground(this.attrActive, Color.decode("#c0ffc0"));
        }

        @Override
        public void run() {
            int activeEntryListIndex = EntryListPane.this.getActiveEntryListIndex();
            if (activeEntryListIndex == -2) {
                activeEntryListIndex = EntryListPane.this.getNrEntries() - 1;
            }
            if (activeEntryListIndex != this.entryListIndex) {
                this.removeCurrentHighlight();
                this.addHighlight(activeEntryListIndex);
            }
        }

        public void reset() {
            this.entryListIndex = -1;
            this.offset = -1;
            this.length = -1;
        }

        private void removeCurrentHighlight() {
            if (this.entryListIndex == -1 || this.entryListIndex >= EntryListPane.this.m_offsetList.size() || this.length <= 0) {
                return;
            }
            EntryListPane.this.getStyledDocument().setCharacterAttributes(this.offset, this.length, this.attrNormal, false);
            this.reset();
        }

        private void addHighlight(int entryListIndex) {
            if (entryListIndex == -1 || entryListIndex >= EntryListPane.this.m_offsetList.size()) {
                return;
            }
            int offset = entryListIndex == 0 ? 0 : (Integer)EntryListPane.this.m_offsetList.get(entryListIndex - 1) + EntryListPane.ENTRY_SEPARATOR.length();
            int length = (Integer)EntryListPane.this.m_offsetList.get(entryListIndex) - offset - 1;
            EntryListPane.this.getStyledDocument().setCharacterAttributes(offset, length, this.attrActive, false);
            this.entryListIndex = entryListIndex;
            this.offset = offset;
            this.length = length;
        }
    }

    private class DisplayedEntryImpl
    implements DisplayedEntry {
        private final int index;

        private DisplayedEntryImpl(int index) {
            this.index = index;
        }

        @Override
        public DisplayedEntry getNext() {
            if (this.index >= EntryListPane.this.getNrEntries() - 1) {
                return this;
            }
            return new DisplayedEntryImpl(this.index + 1);
        }

        @Override
        public DisplayedEntry getPrevious() {
            if (this.index == 0) {
                return this;
            }
            return new DisplayedEntryImpl(this.index - 1);
        }

        @Override
        public void activate() {
            if (this.index >= EntryListPane.this.getNrEntries()) {
                return;
            }
            int beginPos = 0;
            if (this.index != 0) {
                beginPos = (Integer)EntryListPane.this.m_offsetList.get(this.index - 1) + EntryListPane.ENTRY_SEPARATOR.length();
                int endPos = (Integer)EntryListPane.this.m_offsetList.get(this.index);
                try {
                    Rectangle endRect = EntryListPane.this.modelToView(endPos);
                    EntryListPane.this.scrollRectToVisible(endRect);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            EntryListPane.this.setSelectionStart(beginPos);
            EntryListPane.this.setSelectionEnd(beginPos);
        }

        @Override
        public void gotoEntryInEditor() {
            IEditor editor;
            int currEntryInEditor;
            if (this.index >= EntryListPane.this.getNrEntries()) {
                return;
            }
            final int entry = (Integer)EntryListPane.this.m_entryList.get(this.index);
            if (entry > 0 && (currEntryInEditor = (editor = Core.getEditor()).getCurrentEntryNumber()) != 0 && entry != currEntryInEditor) {
                final boolean isSegDisplayed = this.isSegmentDisplayed(entry);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (isSegDisplayed && EntryListPane.this.m_firstMatchList.containsKey(entry)) {
                            IEditor.CaretPosition pos = (IEditor.CaretPosition)EntryListPane.this.m_firstMatchList.get(entry);
                            editor.gotoEntry(entry, pos);
                        } else {
                            editor.gotoEntry(entry);
                        }
                    }
                });
            }
        }

        private boolean isSegmentDisplayed(int entry) {
            IEditorFilter filter = Core.getEditor().getFilter();
            if (filter == null) {
                return true;
            }
            SourceTextEntry ste = Core.getProject().getAllEntries().get(entry - 1);
            return filter.allowed(ste);
        }
    }

    private static class EmptyDisplayedEntry
    implements DisplayedEntry {
        private EmptyDisplayedEntry() {
        }

        @Override
        public DisplayedEntry getNext() {
            return this;
        }

        @Override
        public DisplayedEntry getPrevious() {
            return this;
        }

        @Override
        public void activate() {
        }

        @Override
        public void gotoEntryInEditor() {
        }
    }

    private static interface DisplayedEntry {
        public DisplayedEntry getNext();

        public DisplayedEntry getPrevious();

        public void activate();

        public void gotoEntryInEditor();
    }

    protected class DisplayMatches
    implements Runnable {
        protected final DefaultStyledDocument doc;
        private final List<SearchMatch> matches = new ArrayList<SearchMatch>();
        private final List<SearchMatch> replMatches = new ArrayList<SearchMatch>();
        private final SearchVarExpansion template;
        private final boolean boldWords;
        private final String text;

        public DisplayMatches(ProjectOptions config, Collection<SearchResultEntry> entries, String templateString, boolean boldWords) {
            UIThreadsUtil.mustBeSwingThread();
            this.doc = new DefaultStyledDocument();
            this.template = new SearchVarExpansion(config, templateString);
            try {
                this.template.replaceDialog = (ReplaceDialog)EntryListPane.this.m_parent;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.boldWords = boldWords;
            StringBuilder m_stringBuf = new StringBuilder();
            if (entries.isEmpty()) {
                EntryListPane.this.addMessage(m_stringBuf, OStrings.getString("ST_NOTHING_FOUND"));
            }
            if (entries.size() >= EntryListPane.this.numberOfResults) {
                EntryListPane.this.addMessage(m_stringBuf, StringUtil.format(OStrings.getString("SW_MAX_FINDS_REACHED"), EntryListPane.this.numberOfResults) + "\n\n");
            }
            for (SearchResultEntry entry : entries) {
                int length = m_stringBuf.length();
                m_stringBuf.append(this.template.apply(entry));
                EntryListPane.this.m_offsetList.add(m_stringBuf.length());
                if (entry.getEntryNum() >= 0) {
                    EntryListPane.this.m_entryList.add(entry.getEntryNum());
                }
                if (entry.getSrcMatch() != null) {
                    for (SearchMatch match : entry.getSrcMatch()) {
                        match.move(length);
                        this.matches.add(match);
                    }
                }
                if (entry.getTargetMatch() != null) {
                    for (SearchMatch match : entry.getTargetMatch()) {
                        match.move(length);
                        this.matches.add(match);
                    }
                }
                if (this.template.replMatches == null) continue;
                for (SearchMatch match : this.template.replMatches) {
                    match.move(length);
                    this.replMatches.add(match);
                }
            }
            this.text = m_stringBuf.toString();
            try {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, this.text, null);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
            EntryListPane.this.setDocument(this.doc);
            EntryListPane.this.setCaretPosition(0);
            if (Core.getMainWindow() != null) {
                EntryListPane.this.setFont(Core.getMainWindow().getApplicationFont());
            }
            EntryListPane.this.m_parent.searchEnded(entries.size(), this.matches.size());
            if (!this.matches.isEmpty() || !this.replMatches.isEmpty()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            SearchMatch word;
            UIThreadsUtil.mustBeSwingThread();
            if (EntryListPane.this.currentlyDisplayedMatches != this) {
                return;
            }
            int max = 100;
            int last = -1;
            AttributeSet NORM_MARK = FOUND_MARK;
            AttributeSet BOLD_MARK = FOUND_MARK_BOLD;
            for (SearchMatch m : this.matches) {
                if (m.getStart() <= last) {
                    NORM_MARK = NORM_MARK == FOUND_MARK ? REPLACE_MARK : FOUND_MARK;
                    BOLD_MARK = BOLD_MARK == FOUND_MARK_BOLD ? REPLACE_MARK_BOLD : FOUND_MARK_BOLD;
                } else {
                    NORM_MARK = FOUND_MARK;
                    BOLD_MARK = FOUND_MARK_BOLD;
                }
                if (this.boldWords) {
                    word = m.englobeWord(this.text);
                    this.doc.setCharacterAttributes(word.getStart(), word.getLength(), NORM_MARK, true);
                }
                this.doc.setCharacterAttributes(m.getStart(), m.getLength(), BOLD_MARK, true);
                last = m.getStart() + m.getLength();
                if (max-- > 0) continue;
                break;
            }
            max = 100;
            NORM_MARK = REPLACE_MARK;
            BOLD_MARK = REPLACE_MARK_BOLD;
            for (SearchMatch m : this.replMatches) {
                if (m.getStart() <= last) {
                    NORM_MARK = NORM_MARK == FOUND_MARK ? REPLACE_MARK : FOUND_MARK;
                    BOLD_MARK = BOLD_MARK == FOUND_MARK_BOLD ? REPLACE_MARK_BOLD : FOUND_MARK_BOLD;
                } else {
                    NORM_MARK = REPLACE_MARK;
                    BOLD_MARK = REPLACE_MARK_BOLD;
                }
                if (this.boldWords) {
                    word = m.englobeWord(this.text);
                    this.doc.setCharacterAttributes(word.getStart(), word.getLength(), NORM_MARK, true);
                }
                this.doc.setCharacterAttributes(m.getStart(), m.getLength(), BOLD_MARK, true);
                last = m.getStart() + m.getLength();
                if (max-- > 0) continue;
                break;
            }
        }
    }
}

