/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.util.InlineTagHandler;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TMXReader2 {
    private final XMLInputFactory factory;
    private final SimpleDateFormat dateFormat1;
    private final SimpleDateFormat dateFormat2;
    private final SimpleDateFormat dateFormatOut;
    public static final String SEG_PARAGRAPH = "paragraph";
    public static final String SEG_SENTENCE = "sentence";
    public static final String CT_OMEGAT = "OmegaT";
    private XMLEventReader xml;
    private boolean isParagraphSegtype = true;
    private boolean isOmegaT = false;
    private boolean extTmxLevel2;
    private boolean useSlash;
    private boolean isSegmentingEnabled;
    private int errorsCount;
    private int warningsCount;
    ParsedTu currentTu = new ParsedTu();
    StringBuilder propContent = new StringBuilder();
    StringBuilder noteContent = new StringBuilder();
    StringBuilder segContent = new StringBuilder();
    StringBuilder segInlineTag = new StringBuilder();
    InlineTagHandler inlineTagHandler = new InlineTagHandler();
    public static final EntityResolver TMX_DTD_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("tmx11.dtd")) {
                return new InputSource(TMXReader2.class.getResourceAsStream("/schemas/tmx11.dtd"));
            }
            if (systemId.endsWith("tmx14.dtd")) {
                return new InputSource(TMXReader2.class.getResourceAsStream("/schemas/tmx14.dtd"));
            }
            return null;
        }
    };
    public static final XMLResolver TMX_DTD_RESOLVER_2 = new XMLResolver(){

        @Override
        public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws XMLStreamException {
            if (systemId.endsWith("tmx11.dtd")) {
                return TMXReader2.class.getResourceAsStream("/schemas/tmx11.dtd");
            }
            if (systemId.endsWith("tmx14.dtd")) {
                return TMXReader2.class.getResourceAsStream("/schemas/tmx14.dtd");
            }
            return null;
        }
    };

    public TMXReader2() {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        this.factory.setXMLReporter(new XMLReporter(){

            @Override
            public void report(String message, String error_type, Object info, Location location) throws XMLStreamException {
                Log.logWarningRB("TMXR_WARNING_WHILE_PARSING", location.getLineNumber(), location.getColumnNumber());
                Log.log(message + ": " + info);
                TMXReader2.this.warningsCount++;
            }
        });
        this.factory.setXMLResolver(TMX_DTD_RESOLVER_2);
        this.dateFormat1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        this.dateFormat1.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        this.dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormatOut = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        this.dateFormatOut.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public boolean isParagraphSegtype() {
        return this.isParagraphSegtype;
    }

    public void readTMX(File file, Language sourceLanguage, Language targetLanguage, boolean isSegmentingEnabled, boolean forceOmegaTMX, boolean extTmxLevel2, boolean useSlash, LoadCallback callback) throws Exception {
        Log.logRB("TMXR_INFO_READING_FILE", file.getAbsolutePath());
        InputStream in = new FileInputStream(file);
        in = file.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(in)) : new BufferedInputStream(in);
        this.readTMX(in, sourceLanguage, targetLanguage, isSegmentingEnabled, forceOmegaTMX, extTmxLevel2, useSlash, callback);
        if (this.errorsCount > 0 || this.warningsCount > 0) {
            Log.log("File " + file + " loaded with " + (this.errorsCount > 0 ? "errors" : "warnings"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTMX(InputStream in, Language sourceLanguage, Language targetLanguage, boolean isSegmentingEnabled, boolean forceOmegaTMX, boolean extTmxLevel2, boolean useSlash, LoadCallback callback) throws Exception {
        this.extTmxLevel2 = extTmxLevel2;
        this.useSlash = useSlash;
        this.isSegmentingEnabled = isSegmentingEnabled;
        boolean allFound = true;
        this.xml = this.factory.createXMLEventReader(in);
        try {
            Location lastErrorLocation = null;
            while (this.xml.hasNext()) {
                try {
                    XMLEvent e = this.xml.nextEvent();
                    switch (e.getEventType()) {
                        case 1: {
                            StartElement eStart = (StartElement)e;
                            if ("tu".equals(eStart.getName().getLocalPart())) {
                                this.parseTu(eStart);
                                ParsedTuv origTuv = this.currentTu.getTuvByLang(sourceLanguage);
                                ParsedTuv targetTuv = this.currentTu.getTuvByLang(targetLanguage);
                                allFound &= callback.onEntry(this.currentTu, origTuv, targetTuv, this.isParagraphSegtype);
                                break;
                            }
                            if (!"header".equals(eStart.getName().getLocalPart())) break;
                            this.parseHeader(eStart, sourceLanguage);
                        }
                    }
                }
                catch (XMLStreamException xmlEx) {
                    Log.log(xmlEx);
                    if (++this.errorsCount > 100) {
                        Log.log("Too many errors, stop parsing this stream.");
                        break;
                    }
                    if (lastErrorLocation != null && lastErrorLocation.getLineNumber() == xmlEx.getLocation().getLineNumber() && lastErrorLocation.getColumnNumber() == xmlEx.getLocation().getColumnNumber()) {
                        Log.log("Seems to start infinite loop, break.");
                        break;
                    }
                    lastErrorLocation = xmlEx.getLocation();
                }
                catch (Exception otherEx) {
                    Log.log(otherEx);
                    if (++this.errorsCount <= 100) continue;
                    Log.log("Too many errors, stop parsing this stream.");
                    break;
                }
            }
        }
        finally {
            this.xml.close();
            in.close();
        }
        if (!allFound) {
            Log.logWarningRB("TMXR_WARNING_SOURCE_NOT_FOUND", new Object[0]);
            ++this.warningsCount;
        }
        Log.logRB("TMXR_INFO_READING_COMPLETE", new Object[0]);
        Log.log("");
        if (this.errorsCount > 0 || this.warningsCount > 0) {
            Log.logDebug(Logger.getLogger(this.getClass().getName()), "Errors: {0}, Warnings: {1}", this.errorsCount, this.warningsCount);
        }
    }

    protected void parseHeader(StartElement element, Language sourceLanguage) {
        this.isParagraphSegtype = SEG_PARAGRAPH.equals(TMXReader2.getAttributeValue(element, "segtype"));
        this.isOmegaT = CT_OMEGAT.equals(TMXReader2.getAttributeValue(element, "creationtool"));
        Log.logRB("TMXR_INFO_CREATION_TOOL", TMXReader2.getAttributeValue(element, "creationtool"));
        Log.logRB("TMXR_INFO_CREATION_TOOL_VERSION", TMXReader2.getAttributeValue(element, "creationtoolversion"));
        Log.logRB("TMXR_INFO_SEG_TYPE", TMXReader2.getAttributeValue(element, "segtype"));
        Log.logRB("TMXR_INFO_SOURCE_LANG", TMXReader2.getAttributeValue(element, "srclang"));
        String tmxSourceLanguage = TMXReader2.getAttributeValue(element, "srclang");
        if (!tmxSourceLanguage.equalsIgnoreCase(sourceLanguage.getLanguage())) {
            Log.logWarningRB("TMXR_WARNING_INCORRECT_SOURCE_LANG", tmxSourceLanguage, sourceLanguage);
        }
        if (this.isSegmentingEnabled && this.isParagraphSegtype) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_SENTSEG", new Object[0]);
        }
    }

    protected void parseTu(StartElement element) throws Exception {
        this.currentTu.clear();
        this.currentTu.changeid = TMXReader2.getAttributeValue(element, "changeid");
        this.currentTu.changedate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "changedate"));
        this.currentTu.creationid = TMXReader2.getAttributeValue(element, "creationid");
        this.currentTu.creationdate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "creationdate"));
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = (StartElement)e;
                    if ("tuv".equals(eStart.getName().getLocalPart())) {
                        this.parseTuv(eStart);
                        break;
                    }
                    if ("prop".equals(eStart.getName().getLocalPart())) {
                        this.parseProp(eStart);
                        break;
                    }
                    if (!"note".equals(eStart.getName().getLocalPart())) break;
                    this.parseNote(eStart);
                    break;
                }
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"tu".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }

    protected void parseTuv(StartElement element) throws Exception {
        ParsedTuv tuv = new ParsedTuv();
        this.currentTu.tuvs.add(tuv);
        tuv.changeid = TMXReader2.getAttributeValue(element, "changeid");
        tuv.changedate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "changedate"));
        tuv.creationid = TMXReader2.getAttributeValue(element, "creationid");
        tuv.creationdate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "creationdate"));
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!"lang".equals(a.getName().getLocalPart())) continue;
            tuv.lang = a.getValue();
            break;
        }
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = (StartElement)e;
                    if (!"seg".equals(eStart.getName().getLocalPart())) break;
                    if (this.isOmegaT) {
                        this.parseSegOmegaT();
                    } else if (this.extTmxLevel2) {
                        this.parseSegExtLevel2();
                    } else {
                        this.parseSegExtLevel1();
                    }
                    tuv.text = StringUtil.normalizeUnicode(this.segContent);
                    break;
                }
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"tuv".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }

    protected void parseNote(StartElement element) throws Exception {
        this.noteContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"note".equals(eEnd.getName().getLocalPart())) break;
                    this.currentTu.note = this.noteContent.toString();
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.noteContent.append(c.getData());
                }
            }
        }
    }

    protected void parseProp(StartElement element) throws Exception {
        String propType = TMXReader2.getAttributeValue(element, "type");
        this.propContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"prop".equals(eEnd.getName().getLocalPart())) break;
                    this.currentTu.props.add(new TMXProp(propType, this.propContent.toString()));
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.propContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegOmegaT() throws Exception {
        this.segContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"seg".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.segContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegExtLevel1() throws Exception {
        this.segContent.setLength(0);
        int inlineLevel = 0;
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    ++inlineLevel;
                    break;
                }
                case 2: {
                    --inlineLevel;
                    EndElement eEnd = (EndElement)e;
                    if (!"seg".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
                case 4: {
                    if (inlineLevel != 0) break;
                    Characters c = (Characters)e;
                    this.segContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegExtLevel2() throws Exception {
        this.segContent.setLength(0);
        this.segInlineTag.setLength(0);
        this.inlineTagHandler.reset();
        int inlineLevel = 0;
        block8: while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = e.asStartElement();
                    if ("hi".equals(eStart.getName().getLocalPart())) continue block8;
                    ++inlineLevel;
                    this.segInlineTag.setLength(0);
                    if ("bpt".equals(eStart.getName().getLocalPart())) {
                        this.inlineTagHandler.startBPT(TMXReader2.getAttributeValue(eStart, "i"), TMXReader2.getAttributeValue(eStart, "x"));
                        this.inlineTagHandler.setTagShortcutLetter(StringUtil.getFirstLetterLowercase(TMXReader2.getAttributeValue(eStart, "type")));
                        break;
                    }
                    if ("ept".equals(eStart.getName().getLocalPart())) {
                        this.inlineTagHandler.startEPT(TMXReader2.getAttributeValue(eStart, "i"));
                        break;
                    }
                    if ("it".equals(eStart.getName().getLocalPart())) {
                        this.inlineTagHandler.startOTHER();
                        this.inlineTagHandler.setOtherTagShortcutLetter(StringUtil.getFirstLetterLowercase(TMXReader2.getAttributeValue(eStart, "type")));
                        this.inlineTagHandler.setCurrentPos(TMXReader2.getAttributeValue(eStart, "pos"));
                        break;
                    }
                    if ("ph".equals(eStart.getName().getLocalPart())) {
                        this.inlineTagHandler.startOTHER();
                        this.inlineTagHandler.setOtherTagShortcutLetter(StringUtil.getFirstLetterLowercase(TMXReader2.getAttributeValue(eStart, "type")));
                        break;
                    }
                    this.inlineTagHandler.startOTHER();
                    break;
                }
                case 2: {
                    Integer tagN;
                    EndElement eEnd = e.asEndElement();
                    if ("hi".equals(eEnd.getName().getLocalPart())) continue block8;
                    --inlineLevel;
                    if ("seg".equals(eEnd.getName().getLocalPart())) {
                        return;
                    }
                    boolean slashBefore = false;
                    boolean slashAfter = false;
                    int tagName = StringUtil.getFirstLetterLowercase(this.segInlineTag.toString());
                    if ("bpt".equals(eEnd.getName().getLocalPart())) {
                        if (tagName != 0) {
                            this.inlineTagHandler.setTagShortcutLetter(tagName);
                        } else {
                            tagName = this.inlineTagHandler.getTagShortcutLetter();
                        }
                        tagN = this.inlineTagHandler.endBPT();
                    } else if ("ept".equals(eEnd.getName().getLocalPart())) {
                        slashBefore = true;
                        tagName = this.inlineTagHandler.getTagShortcutLetter();
                        tagN = this.inlineTagHandler.endEPT();
                    } else if ("it".equals(eEnd.getName().getLocalPart())) {
                        if (tagName != 0) {
                            this.inlineTagHandler.setOtherTagShortcutLetter(tagName);
                        } else {
                            tagName = this.inlineTagHandler.getOtherTagShortcutLetter();
                        }
                        tagN = this.inlineTagHandler.endOTHER();
                        if ("end".equals(this.inlineTagHandler.getCurrentPos())) {
                            slashBefore = true;
                        }
                    } else if ("ph".equals(eEnd.getName().getLocalPart())) {
                        if (tagName != 0) {
                            this.inlineTagHandler.setOtherTagShortcutLetter(tagName);
                        } else {
                            tagName = this.inlineTagHandler.getOtherTagShortcutLetter();
                        }
                        tagN = this.inlineTagHandler.endOTHER();
                        if (this.useSlash) {
                            slashAfter = true;
                        }
                    } else {
                        tagN = this.inlineTagHandler.endOTHER();
                        if (this.useSlash) {
                            slashAfter = true;
                        }
                    }
                    if (tagName == 0) {
                        tagName = 102;
                    }
                    if (tagN == null) {
                        Log.logErrorRB("TMX_ERROR_READING_LEVEL2", e.getLocation().getLineNumber(), e.getLocation().getColumnNumber());
                        ++this.errorsCount;
                        this.segContent.setLength(0);
                        while (true) {
                            XMLEvent ev = this.xml.nextEvent();
                            switch (ev.getEventType()) {
                                case 2: {
                                    EndElement evEnd = (EndElement)ev;
                                    if (!"seg".equals(evEnd.getName().getLocalPart())) break;
                                    return;
                                }
                            }
                        }
                    }
                    this.segContent.append('<');
                    if (slashBefore) {
                        this.segContent.append('/');
                    }
                    this.segContent.appendCodePoint(tagName);
                    this.segContent.append(Integer.toString(tagN));
                    if (slashAfter) {
                        this.segContent.append('/');
                    }
                    this.segContent.append('>');
                    break;
                }
                case 4: {
                    Characters c = (Characters)e;
                    if (inlineLevel == 0) {
                        this.segContent.append(c.getData());
                        break;
                    }
                    this.segInlineTag.append(c.getData());
                }
            }
        }
    }

    public long parseISO8601date(String str) {
        if (str == null) {
            return 0L;
        }
        try {
            return this.dateFormat1.parse(str).getTime();
        }
        catch (ParseException parseException) {
            try {
                return this.dateFormat2.parse(str).getTime();
            }
            catch (ParseException parseException2) {
                return 0L;
            }
        }
    }

    private static String getAttributeValue(StartElement e, String attrName) {
        Attribute a = e.getAttributeByName(new QName(attrName));
        return a != null ? a.getValue() : null;
    }

    public static class ParsedTuv {
        public String lang;
        public String changeid;
        public long changedate;
        public String creationid;
        public long creationdate;
        public String text;
    }

    public static class ParsedTu {
        public String changeid;
        public long changedate;
        public String creationid;
        public long creationdate;
        public String note;
        public List<TMXProp> props = new ArrayList<TMXProp>();
        public List<ParsedTuv> tuvs = new ArrayList<ParsedTuv>();

        void clear() {
            this.changeid = null;
            this.changedate = 0L;
            this.creationid = null;
            this.creationdate = 0L;
            this.props = new ArrayList<TMXProp>();
            this.tuvs = new ArrayList<ParsedTuv>();
            this.note = null;
        }

        public ParsedTuv getTuvByLang(Language lang) {
            String langLanguage = lang.getLanguageCode();
            String langCountry = lang.getCountryCode();
            ParsedTuv tuvLC = null;
            ParsedTuv tuvL = null;
            ParsedTuv tuvLW = null;
            for (ParsedTuv tuv : this.tuvs) {
                String[] tuvLangParts = tuv.lang.split("\\W");
                if (!langLanguage.equalsIgnoreCase(tuvLangParts[0])) continue;
                if (tuvLangParts.length == 1) {
                    tuvL = tuv;
                    continue;
                }
                if (langCountry.equalsIgnoreCase(tuvLangParts[1])) {
                    tuvLC = tuv;
                    continue;
                }
                tuvLW = tuv;
            }
            if (tuvLC != null) {
                return tuvLC;
            }
            if (tuvL != null) {
                return tuvL;
            }
            return tuvLW;
        }

        public ParsedTuv getTuvByLang(String lang) {
            if (lang.endsWith("*") || lang.endsWith("?")) {
                return this.getTuvByLang(new Language(lang.substring(0, lang.length() - 1)));
            }
            for (ParsedTuv tuv : this.tuvs) {
                if (!tuv.lang.equalsIgnoreCase(lang)) continue;
                return tuv;
            }
            return null;
        }
    }

    public static interface LoadCallback {
        public boolean onEntry(ParsedTu var1, ParsedTuv var2, ParsedTuv var3, boolean var4);
    }
}

