/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.omegat.core.data.ITMXEntry;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public class TMXWriter2
implements AutoCloseable {
    private static XMLOutputFactory FACTORY = XMLOutputFactory.newInstance();
    private final OutputStream out;
    private final XMLStreamWriter xml;
    private final String langSrc;
    private final String langTar;
    private final boolean levelTwo;
    private final boolean forceValidTMX;
    private final SimpleDateFormat tmxDateFormat;
    protected static final Pattern TAGS_ANY = Pattern.compile("<(/?)([\\S&&[^/\\d]]+)(\\d+)(/?)>");

    public TMXWriter2(File file, Language sourceLanguage, Language targetLanguage, boolean sentenceSegmentingEnabled, boolean levelTwo, boolean forceValidTMX) throws Exception {
        this.levelTwo = levelTwo;
        this.forceValidTMX = forceValidTMX;
        this.out = new BufferedOutputStream(new FileOutputStream(file));
        this.xml = FACTORY.createXMLStreamWriter(this.out, "UTF-8");
        this.xml.writeStartDocument("UTF-8", "1.0");
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        if (levelTwo) {
            this.xml.writeDTD("<!DOCTYPE tmx SYSTEM \"tmx14.dtd\">");
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            this.xml.writeStartElement("tmx");
            this.xml.writeAttribute("version", "1.4");
        } else {
            this.xml.writeDTD("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">");
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            this.xml.writeStartElement("tmx");
            this.xml.writeAttribute("version", "1.1");
        }
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        this.writeHeader(sourceLanguage, targetLanguage, sentenceSegmentingEnabled);
        this.xml.writeCharacters("  ");
        this.xml.writeStartElement("body");
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        this.langSrc = sourceLanguage.toString();
        this.langTar = targetLanguage.toString();
        this.tmxDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        this.tmxDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        try {
            this.xml.writeCharacters("  ");
            this.xml.writeEndElement();
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            this.xml.writeEndElement();
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            this.xml.writeEndDocument();
        }
        finally {
            this.xml.close();
            this.out.close();
        }
    }

    public void writeComment(String comment) throws Exception {
        this.xml.writeComment(comment);
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
    }

    public void writeEntries(Map<String, ITMXEntry> entries) throws Exception {
        for (Map.Entry<String, ITMXEntry> en : entries.entrySet()) {
            this.writeEntry(en.getKey(), en.getValue().getTranslationText(), en.getValue(), null);
        }
    }

    public void writeEntry(String source, String translation, ITMXEntry entry, List<String> propValues) throws Exception {
        this.writeEntry(source, translation, entry.getNote(), entry.getCreator(), entry.getCreationDate(), entry.getChanger(), entry.getChangeDate(), propValues);
    }

    public void writeEntry(String source, String translation, String note, String creator, long creationDate, String changer, long changeDate, List<String> propValues) throws Exception {
        this.xml.writeCharacters("    ");
        this.xml.writeStartElement("tu");
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        if (propValues != null) {
            for (int i = 0; i < propValues.size(); i += 2) {
                if (propValues.get(i + 1) == null) continue;
                this.xml.writeCharacters("      ");
                this.xml.writeStartElement("prop");
                this.xml.writeAttribute("type", propValues.get(i));
                this.xml.writeCharacters(propValues.get(i + 1));
                this.xml.writeEndElement();
                this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            }
        }
        if (!StringUtil.isEmpty(note)) {
            note = StringUtil.removeXMLInvalidChars(note);
            if (this.forceValidTMX) {
                note = TagUtil.stripXmlTags(note);
            }
            this.xml.writeCharacters("      ");
            this.xml.writeStartElement("note");
            this.xml.writeCharacters(this.platformLineSeparator(note));
            this.xml.writeEndElement();
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        }
        source = StringUtil.removeXMLInvalidChars(source);
        if (this.forceValidTMX) {
            source = TagUtil.stripXmlTags(source);
        }
        this.xml.writeCharacters("      ");
        this.xml.writeStartElement("tuv");
        if (this.levelTwo) {
            this.xml.writeAttribute("xml", "", "lang", this.langSrc);
        } else {
            this.xml.writeAttribute("lang", this.langSrc);
        }
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        if (this.levelTwo) {
            this.writeLevelTwo(this.platformLineSeparator(source));
        } else {
            this.writeLevelOne(this.platformLineSeparator(source));
        }
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        this.xml.writeCharacters("      ");
        this.xml.writeEndElement();
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        if (translation != null) {
            translation = StringUtil.removeXMLInvalidChars(translation);
            if (this.forceValidTMX) {
                translation = TagUtil.stripXmlTags(translation);
            }
            this.xml.writeCharacters("      ");
            this.xml.writeStartElement("tuv");
            if (this.levelTwo) {
                this.xml.writeAttribute("xml", "", "lang", this.langTar);
            } else {
                this.xml.writeAttribute("lang", this.langTar);
            }
            if (!StringUtil.isEmpty(changer)) {
                this.xml.writeAttribute("changeid", changer);
            }
            if (changeDate > 0L) {
                this.xml.writeAttribute("changedate", this.tmxDateFormat.format(new Date(changeDate)));
            }
            if (!StringUtil.isEmpty(creator)) {
                this.xml.writeAttribute("creationid", creator);
            }
            if (creationDate > 0L) {
                this.xml.writeAttribute("creationdate", this.tmxDateFormat.format(new Date(creationDate)));
            }
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            if (this.levelTwo) {
                this.writeLevelTwo(this.platformLineSeparator(translation));
            } else {
                this.writeLevelOne(this.platformLineSeparator(translation));
            }
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
            this.xml.writeCharacters("      ");
            this.xml.writeEndElement();
            this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
        }
        this.xml.writeCharacters("    ");
        this.xml.writeEndElement();
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
    }

    private void writeHeader(Language sourceLanguage, Language targetLanguage, boolean sentenceSegmentingEnabled) throws Exception {
        this.xml.writeCharacters("  ");
        this.xml.writeEmptyElement("header");
        this.xml.writeAttribute("creationtool", OStrings.getApplicationName());
        this.xml.writeAttribute("o-tmf", "OmegaT TMX");
        this.xml.writeAttribute("adminlang", "EN-US");
        this.xml.writeAttribute("datatype", "plaintext");
        this.xml.writeAttribute("creationtoolversion", OStrings.getVersion());
        this.xml.writeAttribute("segtype", sentenceSegmentingEnabled ? "sentence" : "paragraph");
        this.xml.writeAttribute("srclang", sourceLanguage.toString());
        this.xml.writeCharacters(FileUtil.LINE_SEPARATOR);
    }

    private void writeLevelOne(String segment) throws Exception {
        this.xml.writeCharacters("        ");
        this.xml.writeStartElement("seg");
        this.xml.writeCharacters(segment);
        this.xml.writeEndElement();
    }

    private void writeLevelTwo(String segment) throws Exception {
        this.xml.writeCharacters("        ");
        this.xml.writeStartElement("seg");
        int pos = 0;
        Matcher m = TAGS_ANY.matcher(segment);
        block5: while (m.find(pos)) {
            this.xml.writeCharacters(segment.substring(pos, m.start()));
            pos = m.end();
            TAG_TYPE tagType = !m.group(1).isEmpty() ? TAG_TYPE.END : (!m.group(4).isEmpty() ? TAG_TYPE.SINGLE : TAG_TYPE.START);
            String tagName = m.group(2);
            String tagNumber = m.group(3);
            switch (tagType) {
                case SINGLE: {
                    this.xml.writeStartElement("ph");
                    this.xml.writeAttribute("x", tagNumber);
                    this.xml.writeCharacters(m.group());
                    this.xml.writeEndElement();
                    continue block5;
                }
                case START: {
                    String endTag = "</" + tagName + tagNumber + ">";
                    if (segment.contains(endTag)) {
                        this.xml.writeStartElement("bpt");
                        this.xml.writeAttribute("i", tagNumber);
                        this.xml.writeAttribute("x", tagNumber);
                        this.xml.writeCharacters(m.group());
                        this.xml.writeEndElement();
                        continue block5;
                    }
                    this.xml.writeStartElement("it");
                    this.xml.writeAttribute("pos", "begin");
                    this.xml.writeAttribute("x", tagNumber);
                    this.xml.writeCharacters(m.group());
                    this.xml.writeEndElement();
                    continue block5;
                }
                case END: {
                    String startTag = "<" + tagName + tagNumber + ">";
                    if (segment.contains(startTag)) {
                        this.xml.writeStartElement("ept");
                        this.xml.writeAttribute("i", tagNumber);
                        this.xml.writeCharacters(m.group());
                        this.xml.writeEndElement();
                        continue block5;
                    }
                    this.xml.writeStartElement("it");
                    this.xml.writeAttribute("pos", "end");
                    this.xml.writeAttribute("x", tagNumber);
                    this.xml.writeCharacters(m.group());
                    this.xml.writeEndElement();
                    continue block5;
                }
            }
            throw new RuntimeException("Unknow tag type");
        }
        this.xml.writeCharacters(segment.substring(pos));
        this.xml.writeEndElement();
    }

    private String platformLineSeparator(String text) {
        return text.replace("\n", FileUtil.LINE_SEPARATOR);
    }

    static enum TAG_TYPE {
        SINGLE,
        START,
        END;

    }
}

