/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class PropertiesStore {
    private Properties propList;
    private Cyclotis parent;
    public static final String PROP_ENTRY_NUM = "entry.num";
    public static final String PROP_ENTRY_FILE = "entry.file";
    public static final String PROP_ENTRY_ID = "entry.id";
    public static final String PROP_ENTRY_PATH = "entry.path";
    public static final String PROP_TABLE_NAME = "db.table.name";
    private static final Pattern patternPropertyIf = Pattern.compile("\\.((\\d+)_)?if\\Z");
    private static final Pattern patternPropertyVal = Pattern.compile("\\.((\\d+)_)?value\\Z");
    public static final String expr_split = "\\|([^\\|]+)\\|(\\d+)";
    public static final String expr_substring = "\\:(\\d+)(?:,(\\d+))?";
    public static final String expr_format = "\\!\\%([0-9\\.]*)([dfx])";
    public static final Pattern patternSingleProperty = Pattern.compile("\\@\\{([\\w\\.]+?)(?:\\|([^\\|]+)\\|(\\d+))?(?:\\:(\\d+)(?:,(\\d+))?)?(?:\\!\\%([0-9\\.]*)([dfx]))?\\}");
    public static final Pattern patternSysVariable = Pattern.compile("\\$\\{([\\w\\.]+?)(?:\\|([^\\|]+)\\|(\\d+))?(?:\\:(\\d+)(?:,(\\d+))?)?(?:\\!\\%([0-9\\.]*)([dfx]))?\\}");

    public PropertiesStore(Cyclotis parent, Properties propList) {
        this.parent = parent;
        this.propList = propList;
    }

    public String sysVariable(String name, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        if (PROP_ENTRY_NUM.equals(name)) {
            return Integer.toString(entrySource.entryNum());
        }
        if (PROP_ENTRY_FILE.equals(name)) {
            return entrySource.getKey().file;
        }
        if (PROP_ENTRY_ID.equals(name)) {
            return entrySource.getKey().id == null ? "null" : entrySource.getKey().id;
        }
        if (PROP_ENTRY_PATH.equals(name)) {
            return entrySource.getKey().path == null ? "null" : entrySource.getKey().path;
        }
        if (name.startsWith("tu.")) {
            if ("tu.author".equals(name)) {
                if (entryContents.changer != null) {
                    return entryContents.changer;
                }
                return entryContents.creator;
            }
            if ("tu.creator".equals(name)) {
                return entryContents.creator;
            }
            if ("tu.changer".equals(name)) {
                return entryContents.changer;
            }
            if ("tu.creationDate".equals(name)) {
                return Long.toString(entryContents.creationDate);
            }
            if ("tu.changeDate".equals(name)) {
                return Long.toString(entryContents.changeDate);
            }
            if ("tu.date".equals(name)) {
                if (entryContents.changeDate > 0L) {
                    return Long.toString(entryContents.changeDate);
                }
                return Long.toString(entryContents.creationDate);
            }
        }
        return "";
    }

    public List<TMXProp> toDatabase(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        ArrayList<TMXProp> result = new ArrayList<TMXProp>();
        for (String name : this.propList.stringPropertyNames()) {
            if (!name.startsWith("props.toDatabase")) continue;
            String subname = name.substring(17);
            String val = this.propList.getProperty(name);
            Matcher matchIf = patternPropertyIf.matcher(subname);
            if (matchIf.find()) {
                subname = subname.substring(0, subname.length() - matchIf.group(0).length());
                String condString = val;
                val = matchIf.group(2).length() > 0 ? this.propList.getProperty("props.toDatabase." + subname + "." + matchIf.group(2) + "_value") : this.propList.getProperty("props.toDatabase." + subname + ".value");
                this.parent.logMessage("props2db", "Conditional property: " + condString);
                SaveConditions conditions = SaveConditions.forProperty(condString);
                if (conditions.mustWrite(this.parent, entryContents, entrySource)) {
                    this.parent.logMessage("props2db", "Store property: " + subname + " from " + val);
                    val = this.interpolation(val, result, entryContents, entrySource);
                    this.parent.logMessage("props2db", "Store property: " + subname + " = " + val);
                    result.add(new TMXProp(subname, val));
                    continue;
                }
                this.parent.logMessage("props2db", "Condition is false");
                continue;
            }
            if (patternPropertyVal.matcher(subname).find()) continue;
            this.parent.logMessage("props2db", "Store property: " + subname + " from " + val);
            val = this.interpolation(val, result, entryContents, entrySource);
            this.parent.logMessage("props2db", "Store property: " + subname + " = " + val);
            result.add(new TMXProp(subname, val));
        }
        return result;
    }

    public boolean storesSomeProperties() {
        for (String name : this.propList.stringPropertyNames()) {
            if (!name.startsWith("props.toDatabase")) continue;
            return true;
        }
        return false;
    }

    private String interpolation(String val, List<TMXProp> extractedList) {
        Matcher matcher;
        while ((matcher = patternSingleProperty.matcher(val)).find()) {
            String propName = matcher.group(1);
            String result = null;
            for (TMXProp prop : extractedList) {
                if (!prop.getType().equalsIgnoreCase(propName)) continue;
                result = prop.getValue();
            }
            result = this.findPart(result, matcher);
            val = val.replace(matcher.group(), result == null ? "" : result);
        }
        return val;
    }

    private String interpolation(String val, List<TMXProp> extractedList, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        Matcher matcher;
        val = val.replace("${db.table.name", "@{db.table.name");
        while ((matcher = patternSysVariable.matcher(val)).find()) {
            String propName = matcher.group(1);
            String result = this.sysVariable(propName, entryContents, entrySource);
            result = this.findPart(result, matcher);
            val = val.replace(matcher.group(), result == null ? "" : result);
        }
        val = this.interpolation(val, extractedList);
        return val;
    }

    private String findPart(String result, Matcher matcher) {
        if (matcher.group(2) != null) {
            try {
                String expr = "[" + matcher.group(2) + "]";
                int pos = Integer.parseInt(matcher.group(3));
                String[] split = result.split(expr);
                result = split[pos];
            }
            catch (Exception expr) {
                // empty catch block
            }
        }
        if (matcher.group(4) != null) {
            try {
                int start = Integer.parseInt(matcher.group(4));
                try {
                    int end = Integer.parseInt(matcher.group(5));
                    result = result.substring(start, end);
                }
                catch (Exception e) {
                    result = result.substring(start);
                }
            }
            catch (Exception start) {
                // empty catch block
            }
        }
        if (matcher.group(7) != null) {
            try {
                System.out.println("Format %" + matcher.group(6) + matcher.group(7) + " of " + result);
                char type = matcher.group(7).charAt(0);
                switch (type) {
                    case 'd': {
                        int i = Integer.parseInt(result);
                        System.out.println("result is int");
                        result = String.format("%" + matcher.group(6) + matcher.group(7), i);
                        break;
                    }
                    case 'f': {
                        float i = Float.parseFloat(result);
                        result = String.format("%" + matcher.group(6) + matcher.group(7), Float.valueOf(i));
                        break;
                    }
                    case 'x': {
                        result = String.format("%" + matcher.group(6) + matcher.group(7), result);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public List<TMXProp> fromDatabase(List<TMXProp> extractedList, PrepareTMXEntry entryContents) {
        ArrayList<TMXProp> newList = new ArrayList<TMXProp>();
        if (extractedList == null) {
            extractedList = Collections.emptyList();
        }
        StringBuffer extractedListBuf = new StringBuffer();
        for (TMXProp tMXProp : extractedList) {
            extractedListBuf.append(tMXProp.getType()).append("=").append(tMXProp.getValue()).append(",");
        }
        this.parent.logMessage("props2ui", "DB contents: " + extractedListBuf);
        for (String string : this.propList.stringPropertyNames()) {
            if (!string.startsWith("props.display")) continue;
            String subname = string.substring(14);
            String val = this.propList.getProperty(string);
            Matcher matchIf = patternPropertyIf.matcher(subname);
            if (matchIf.find()) {
                subname = subname.substring(0, subname.length() - matchIf.group(0).length());
                String condString = val;
                val = matchIf.group(2).length() > 0 ? this.propList.getProperty("props.display." + subname + "." + matchIf.group(2) + "_value") : this.propList.getProperty("props.display." + subname + ".value");
                this.parent.logMessage("props2ui", "Conditional property: " + condString);
                SaveConditions conditions = SaveConditions.forProperty(condString);
                if (conditions.mustWrite(this.parent, entryContents, null)) {
                    this.parent.logMessage("props2ui", "Get property: " + subname + " from " + val);
                    val = this.interpolation(val, extractedList, entryContents, null);
                    this.parent.logMessage("props2ui", "Get property: " + subname + " = " + val);
                    newList.add(new TMXProp(subname, val));
                    continue;
                }
                this.parent.logMessage("props2ui", "Condition is false");
                continue;
            }
            if (patternPropertyVal.matcher(subname).find()) continue;
            this.parent.logMessage("props2ui", "Get property: " + subname + " from " + val);
            val = this.interpolation(val, extractedList, entryContents, null);
            this.parent.logMessage("props2ui", "Get property: " + subname + " = " + val);
            newList.add(new TMXProp(subname, val));
        }
        this.doExcludeProperties(newList, extractedList);
        return newList;
    }

    public boolean needsRemap() {
        for (String name : this.propList.stringPropertyNames()) {
            if (!name.startsWith("props.display")) continue;
            return true;
        }
        return false;
    }

    public void doExcludeProperties(List<TMXProp> newList, List<TMXProp> extractedList) {
        if (this.propList.getProperty("props.exclude") != null) {
            HashSet<String> exclude = new HashSet<String>();
            for (String item : this.propList.getProperty("props.exclude").split(",")) {
                exclude.add(item);
            }
            for (TMXProp prop : extractedList) {
                if (exclude.contains(prop.getType())) continue;
                newList.add(prop);
            }
        } else {
            newList.addAll(extractedList);
        }
    }
}

