/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.proj.ContextTMXEntry;
import org.silvestrislab.cyclotis.omegat.proj.ctx.DigestStringContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.EntryNumContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.FullStringContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.HashContextMode;

public abstract class ContextMode<T> {
    public abstract T getValue(ResultSet var1) throws SQLException;

    public abstract T defaultValueForSource(String var1);

    public abstract T nonDefaultValueForEntry(SourceTextEntry var1);

    public abstract boolean isDefault(String var1, T var2);

    public abstract boolean isCorrectKey(SourceTextEntry var1, T var2);

    public abstract EntryKey findEntryKey(T var1) throws Exception;

    public abstract void setStatementValue(PreparedStatement var1, int var2, SourceTextEntry var3, boolean var4) throws SQLException;

    public boolean isUnique() {
        return false;
    }

    public final T toDatabase(int entryNum, boolean isDefault) {
        SourceTextEntry entry = (SourceTextEntry)Core.getProject().getAllEntries().get(entryNum - 1);
        if (isDefault) {
            return this.defaultValueForSource(entry.getKey().sourceText);
        }
        return this.nonDefaultValueForEntry(entry);
    }

    public final T toDatabase(SourceTextEntry entry, boolean isDefault) {
        if (isDefault) {
            return this.defaultValueForSource(entry.getKey().sourceText);
        }
        return this.nonDefaultValueForEntry(entry);
    }

    public void fillEntry(Cyclotis origin, ContextTMXEntry entry, ResultSet data) throws SQLException {
        this.fillEntry(origin, entry, data.getObject("CONTEXT"));
    }

    public void fillEntry(Cyclotis origin, ContextTMXEntry entry, T contextValue) {
        List entries = Core.getProject().getAllEntries();
        if (entry.entryNum > 0) {
            entry.isDefault = this.isDefault(((SourceTextEntry)entries.get((int)(entry.entryNum - 1))).getKey().sourceText, contextValue);
            origin.logMessage("context", "Entry #" + entry.entryNum + " with context " + contextValue + " is " + (entry.isDefault ? "default" : "non-default"));
        } else if (this.isDefault(entry.source, contextValue)) {
            origin.logMessage("context", "" + contextValue + " is for default, searching only entry number");
            entry.entryNum = -1;
            for (SourceTextEntry se : entries) {
                if (!entry.source.equals(se.getSrcText()) || !Core.getProject().getTranslationInfo((SourceTextEntry)se).defaultTranslation) continue;
                entry.entryNum = se.entryNum();
                entry.isDefault = true;
                break;
            }
        } else {
            origin.logMessage("context", "Searching entry for context " + contextValue);
            entry.entryNum = -1;
            for (SourceTextEntry se : entries) {
                if (!entry.source.equals(se.getSrcText())) continue;
                if (this.isCorrectKey(se, contextValue)) {
                    entry.isDefault = this.isDefault(se.getKey().sourceText, contextValue);
                    if (!entry.isDefault || !Core.getProject().getTranslationInfo((SourceTextEntry)se).defaultTranslation) continue;
                    entry.entryNum = se.entryNum();
                    break;
                }
                if (!this.isDefault(se.getKey().sourceText, contextValue)) continue;
                entry.isDefault = true;
                if (!Core.getProject().getTranslationInfo((SourceTextEntry)se).defaultTranslation) continue;
                entry.entryNum = se.entryNum();
            }
            origin.logMessage("context", "From scan : " + entry.entryNum);
            if (entry.entryNum == -1) {
                entry.isDefault = contextValue.equals(this.defaultValueForSource(entry.source));
                origin.logMessage("context-detail", "Default value for '" + entry.source + "' is " + this.defaultValueForSource(entry.source) + "; match = " + entry.isDefault);
            }
        }
    }

    public static ContextMode<?> forProperties(Properties propList) throws Exception {
        String name = propList.getProperty("context.store").toUpperCase().replace(' ', '_');
        if (name.equals("ENTRY_NUM")) {
            return new EntryNumContextMode();
        }
        if (name.equals("HASH_CODE")) {
            return new HashContextMode();
        }
        if (name.equals("FULL_STRING")) {
            return new FullStringContextMode();
        }
        if (name.equals("DIGEST")) {
            String algo = propList.getProperty("context.store.algo").toUpperCase();
            if (algo == null) {
                algo = "MD5";
            }
            return new DigestStringContextMode(algo);
        }
        return null;
    }
}

