/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.security.MessageDigest;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.silvestrislab.cyclotis.omegat.Cyclotis;
import org.silvestrislab.cyclotis.omegat.proj.ctx.EntryCache;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public class DigestStringContextMode
extends StringContextMode
implements Cyclotis.DigestAlgorithm {
    private MessageDigest md;
    private String CONV_DEFAULT;
    private EntryCache<String> cache = new EntryCache<String>(this);

    public DigestStringContextMode(String algo) throws Exception {
        this.md = MessageDigest.getInstance(algo);
        this.CONV_DEFAULT = this.convert("default");
    }

    @Override
    protected String convert(String orig) {
        try {
            byte[] hash = this.md.digest(orig.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return orig;
        }
    }

    @Override
    public String defaultValueForSource(String sourceText) {
        return this.convert(sourceText);
    }

    @Override
    public String nonDefaultValueForEntry(SourceTextEntry key) {
        return this.convert(key.getKey().toString());
    }

    @Override
    public boolean isDefault(String srcText, String value) {
        return value == null || value.equals(this.CONV_DEFAULT) || value.equals(this.convert(srcText));
    }

    @Override
    public boolean isCorrectKey(SourceTextEntry key, String value) {
        return value != null && value.equals(this.convert(key.getKey().toString()));
    }

    public String toString() {
        return "digest(" + this.md.getAlgorithm() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public EntryKey findEntryKey(String value) throws Exception {
        return this.cache.findEntryKey(value);
    }

    @Override
    public String digest(String text) {
        return this.convert(text);
    }
}

