/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.util.WeakHashMap;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;

class EntryCache<T> {
    private WeakHashMap<T, EntryKey> cache = new WeakHashMap();
    private ContextMode<T> mode;

    public EntryCache(ContextMode<T> mode) {
        this.mode = mode;
        CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case CLOSE: 
                    case CREATE: 
                    case LOAD: {
                        EntryCache.this.cache.clear();
                    }
                }
            }
        });
    }

    public EntryKey findEntryKey(T value) throws Exception {
        EntryKey key = this.cache.get(value);
        if (key != null) {
            return key;
        }
        for (SourceTextEntry ste : Core.getProject().getAllEntries()) {
            if (!this.mode.isCorrectKey(ste, value)) continue;
            return ste.getKey();
        }
        throw new Exception("Entry not found");
    }
}

