/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.io;

import java.io.CharArrayReader;
import java.io.IOException;
import net.moraleboost.io.BasicCodePointReader;
import net.moraleboost.io.PushbackCodePointReader;
import org.junit.Assert;
import org.junit.Test;

public class PushbackCodePointReaderTest {
    @Test
    public void testBasic() throws Exception {
        String str = "abc";
        int scp = 66560;
        CharArrayReader car = new CharArrayReader(str.toCharArray());
        BasicCodePointReader base = new BasicCodePointReader(car);
        PushbackCodePointReader reader = new PushbackCodePointReader(base, 2);
        Assert.assertEquals((long)97L, (long)reader.read());
        Assert.assertEquals((long)1L, (long)reader.getPosition());
        Assert.assertEquals((long)98L, (long)reader.read());
        Assert.assertEquals((long)2L, (long)reader.getPosition());
        Assert.assertEquals((long)99L, (long)reader.read());
        Assert.assertEquals((long)3L, (long)reader.getPosition());
        reader.unread(12354, 1);
        Assert.assertEquals((long)2L, (long)reader.getPosition());
        reader.unread(scp, 2);
        Assert.assertEquals((long)0L, (long)reader.getPosition());
        Assert.assertEquals((long)scp, (long)reader.read());
        Assert.assertEquals((long)2L, (long)reader.getPosition());
        Assert.assertEquals((long)12354L, (long)reader.read());
        Assert.assertEquals((long)3L, (long)reader.getPosition());
        Assert.assertEquals((long)-1L, (long)reader.read());
    }

    @Test
    public void testMaxSize() throws Exception {
        String str = "abc";
        CharArrayReader car = new CharArrayReader(str.toCharArray());
        BasicCodePointReader base = new BasicCodePointReader(car);
        PushbackCodePointReader reader = new PushbackCodePointReader(base, 2);
        int i = 0;
        while (i < 3) {
            reader.read();
            ++i;
        }
        i = 0;
        while (i < 2) {
            reader.unread(97, 1);
            ++i;
        }
        try {
            reader.unread(97, 1);
            Assert.fail((String)"\u30b9\u30bf\u30c3\u30af\u30b5\u30a4\u30ba\u4e0a\u9650\u306e\u6307\u5b9a\u304c\u6a5f\u80fd\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

