/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.Collections;
import java.util.Map;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.util.ReflectionUtil;
import org.omegat.core.data.TMXEntry;

public class OmTTuv
implements ITuv {
    private final TMXEntry tmxEntry;
    private final String language;
    private Map<String, String> props;

    public OmTTuv(TMXEntry tmxEntry, String language) {
        this.tmxEntry = tmxEntry;
        this.language = language;
    }

    @Override
    public String getContent() {
        return this.tmxEntry.translation;
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.props == null) {
            this.props = Collections.unmodifiableMap(ReflectionUtil.simpleMembersToMap(this.tmxEntry));
        }
        return this.props;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Object getUnderlyingRepresentation() {
        return this.tmxEntry;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OmTTuv other = (OmTTuv)obj;
        return this.tmxEntry.equals(other.tmxEntry) && this.language.equals(other.language);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.tmxEntry != null ? this.tmxEntry.hashCode() : 0);
        hash = 89 * hash + (this.language != null ? this.language.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equivalentTo(ITuv o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof OmTTuv)) {
            throw new IllegalArgumentException("Cannot check equivalence between OmTTuv and non-OmTTuv");
        }
        OmTTuv other = (OmTTuv)o;
        return this.tmxEntry.equalsTranslation(other.tmxEntry);
    }
}

