/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractPatternRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private String message;
    private String suggestionsOutMsg;
    private List<Match> suggestionMatches;
    private List<Match> suggestionMatchesOutMsg;
    private boolean useList;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage) {
        super(id, description, language, elements, false);
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        if (language == null) {
            throw new NullPointerException("language cannot be null");
        }
        if (elements == null) {
            throw new NullPointerException("elements cannot be null");
        }
        if (description == null) {
            throw new NullPointerException("description/name cannot be null");
        }
        this.message = message;
        this.shortMessage = shortMessage;
        this.elementNo = new ArrayList<Integer>();
        this.suggestionsOutMsg = "";
        String prevName = "";
        String curName = "";
        int cnt = 0;
        int loopCnt = 0;
        for (Element e : this.patternElements) {
            if (e.isPartOfPhrase()) {
                curName = e.getPhraseName();
                if (prevName.equals(curName) || StringTools.isEmpty(prevName)) {
                    ++cnt;
                    this.useList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternElements.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
    }

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage, String suggestionsOutMsg) {
        this(id, language, elements, description, message, shortMessage);
        this.suggestionsOutMsg = suggestionsOutMsg;
    }

    public PatternRule(String id, Language language, List<Element> elements, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, elements, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    public final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    public final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (Element patternElement : this.patternElements) {
            strList.add(patternElement.toString());
        }
        return StringTools.listToString(strList, ", ");
    }

    public final String toXML() {
        PatternRuleXmlCreator xmlCreator = new PatternRuleXmlCreator();
        return xmlCreator.toXML(this);
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence text) throws IOException {
        PatternRuleMatcher matcher = new PatternRuleMatcher(this, this.useList);
        return matcher.match(text);
    }

    public final void addSuggestionMatch(Match m) {
        if (this.suggestionMatches == null) {
            this.suggestionMatches = new ArrayList<Match>();
        }
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        if (this.suggestionMatchesOutMsg == null) {
            this.suggestionMatchesOutMsg = new ArrayList<Match>();
        }
        this.suggestionMatchesOutMsg.add(m);
    }

    public final List<Element> getElements() {
        return this.patternElements;
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    String getShortMessage() {
        return this.shortMessage;
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg;
    }
}

