/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.animation;

import com.vlsolutions.swing.docking.animation.AnimationEvent;
import com.vlsolutions.swing.docking.animation.AnimationListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

public class ComponentAnimator {
    protected Component comp;
    protected Rectangle startBounds;
    protected Rectangle endBounds;
    protected float duration;
    private long start;
    protected float elapsed = 0.0f;
    private Timer timer;
    private ArrayList<AnimationListener> listeners = new ArrayList(3);

    public ComponentAnimator(Component comp, Rectangle startBounds, Rectangle endBounds, float duration, AnimationListener listener) {
        this.comp = comp;
        this.startBounds = startBounds;
        this.endBounds = endBounds;
        this.duration = duration;
        this.addAnimationListener(listener);
        this.start();
    }

    public ComponentAnimator(Component comp, Rectangle startBounds, Rectangle endBounds, float duration) {
        this.comp = comp;
        this.startBounds = startBounds;
        this.endBounds = endBounds;
        this.duration = duration;
    }

    public void start() {
        if (this.duration == 0.0f) {
            this.fireAnimationEvent(new AnimationEvent(this.comp, 0));
            this.comp.setBounds(this.endBounds.x, this.endBounds.y, this.endBounds.width, this.endBounds.height);
            this.comp.invalidate();
            this.comp.validate();
            this.comp.repaint();
            this.fireAnimationEvent(new AnimationEvent(this.comp, 2));
        } else {
            this.comp.setBounds(this.startBounds.x, this.startBounds.y, this.startBounds.width, this.startBounds.height);
            this.comp.validate();
            this.comp.setVisible(true);
            this.timer = new Timer(100, new AnimationActionListener());
            this.start = System.currentTimeMillis();
            this.timer.start();
            this.fireAnimationEvent(new AnimationEvent(this.comp, 0));
        }
    }

    public void cancel() {
        this.timer.stop();
    }

    public void addAnimationListener(AnimationListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void fireAnimationEvent(AnimationEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).animation(e);
            ++i;
        }
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public Rectangle getEndBounds() {
        return this.endBounds;
    }

    public void setEndBounds(Rectangle endBounds) {
        this.endBounds = endBounds;
    }

    public Rectangle getStartBounds() {
        return this.startBounds;
    }

    public void setStartBounds(Rectangle startBounds) {
        this.startBounds = startBounds;
    }

    private class AnimationActionListener
    implements ActionListener {
        private AnimationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long time = System.currentTimeMillis();
            ComponentAnimator.this.elapsed = (float)(time - ComponentAnimator.this.start) / 1000.0f;
            if (ComponentAnimator.this.elapsed < ComponentAnimator.this.duration) {
                float f1 = (ComponentAnimator.this.duration - ComponentAnimator.this.elapsed) / ComponentAnimator.this.duration;
                float f2 = ComponentAnimator.this.elapsed / ComponentAnimator.this.duration;
                Rectangle newBounds = new Rectangle();
                newBounds.x = (int)((float)ComponentAnimator.this.startBounds.x * f1 + (float)ComponentAnimator.this.endBounds.x * f2);
                newBounds.y = (int)((float)ComponentAnimator.this.startBounds.y * f1 + (float)ComponentAnimator.this.endBounds.y * f2);
                newBounds.width = (int)((float)ComponentAnimator.this.startBounds.width * f1 + (float)ComponentAnimator.this.endBounds.width * f2);
                newBounds.height = (int)((float)ComponentAnimator.this.startBounds.height * f1 + (float)ComponentAnimator.this.endBounds.height * f2);
                ComponentAnimator.this.comp.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                ComponentAnimator.this.comp.validate();
                ComponentAnimator.this.fireAnimationEvent(new AnimationEvent(ComponentAnimator.this.comp, 1));
            } else {
                ComponentAnimator.this.comp.setBounds(ComponentAnimator.this.endBounds.x, ComponentAnimator.this.endBounds.y, ComponentAnimator.this.endBounds.width, ComponentAnimator.this.endBounds.height);
                ComponentAnimator.this.comp.validate();
                ComponentAnimator.this.timer.stop();
                ComponentAnimator.this.fireAnimationEvent(new AnimationEvent(ComponentAnimator.this.comp, 2));
            }
        }
    }
}

