/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators.dummy;

import java.util.ArrayList;
import org.omegat.core.Core;
import org.omegat.core.search.PreTranslateSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.Token;

public class SourceTranslate
implements IMachineTranslation {
    private boolean withGlos = false;
    private boolean withGlosOnly = false;

    public SourceTranslate() {
    }

    public SourceTranslate(boolean withGlos, boolean withGlosOnly) {
        this.withGlos = withGlos;
        this.withGlosOnly = withGlosOnly;
    }

    @Override
    public String getName() {
        return "Source" + (this.withGlos ? " with glossaries" : "");
    }

    @Override
    public String getTranslation(Language sLang, Language tLang, String text) {
        if (!this.withGlos) {
            return text;
        }
        String res = EditorUtils.replaceGlossaryEntries(text);
        if (this.withGlosOnly && res.equals(text)) {
            return null;
        }
        return res;
    }

    public void rebuildEntryHighlights(PreTranslateSearchResultEntry entry, String translation, String m_prefix) {
        try {
            ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
            Token[] srcTokens = tokenizer.tokenizeWords(entry.getSrcText(), ITokenizer.StemmingMode.NONE);
            Token[] traTokens = tokenizer.tokenizeWords(translation, ITokenizer.StemmingMode.NONE);
            int i = 0;
            int j = 0;
            ArrayList<SearchMatch> srcMatches = new ArrayList<SearchMatch>();
            ArrayList<SearchMatch> traMatches = new ArrayList<SearchMatch>();
            while (i < srcTokens.length && j < traTokens.length) {
                if (srcTokens[i].equals(traTokens[j])) {
                    ++i;
                    ++j;
                    continue;
                }
                if (i < srcTokens.length - 1 && srcTokens[i + 1].equals(traTokens[j])) {
                    srcMatches.add(new SearchMatch(srcTokens[i].getOffset(), srcTokens[i].getLength() + srcTokens[i].getOffset()));
                    ++i;
                    continue;
                }
                if (j < traTokens.length - 1 && traTokens[j + 1].equals(srcTokens[i])) {
                    traMatches.add(new SearchMatch(traTokens[j].getOffset() + m_prefix.length(), traTokens[j].getLength() + traTokens[j].getOffset() + m_prefix.length()));
                    ++j;
                    continue;
                }
                srcMatches.add(new SearchMatch(srcTokens[i].getOffset(), srcTokens[i].getLength() + srcTokens[i].getOffset()));
                traMatches.add(new SearchMatch(traTokens[j].getOffset() + m_prefix.length(), traTokens[j].getLength() + traTokens[j].getOffset() + m_prefix.length()));
                ++i;
                ++j;
            }
            entry.setAllHighlights(srcMatches, traMatches);
        }
        catch (Exception eSrc) {
            eSrc.printStackTrace();
        }
    }
}

