/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.util.Language;

public class CacheWritableExternalMemory
implements IWritableExternalMemory {
    private IWritableExternalMemory delegate;
    private Map<SourceTextEntry, PrepareTMXEntry> failedEntries = new HashMap<SourceTextEntry, PrepareTMXEntry>();

    public CacheWritableExternalMemory(IWritableExternalMemory delegate) {
        this.delegate = delegate;
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE || eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE) {
                try {
                    Language sLang = Core.getProject().getProjectProperties().getSourceLanguage();
                    Language tLang = Core.getProject().getProjectProperties().getTargetLanguage();
                    delegate.registerTranslations(sLang, tLang, this.failedEntries);
                    this.failedEntries.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public String getProviderName() {
        return this.delegate.getProviderName();
    }

    @Override
    public String getMemoryName() {
        return this.delegate.getMemoryName();
    }

    @Override
    public boolean isWriteMode() {
        return this.delegate.isWriteMode();
    }

    @Override
    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.delegate.mustWrite(entryContents, entrySource);
    }

    @Override
    public void registerTranslations(Language sLang, Language tLang, Map<SourceTextEntry, PrepareTMXEntry> entries) throws Exception {
        this.delegate.registerTranslations(sLang, tLang, entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        try {
            this.delegate.registerTranslations(sLang, tLang, this.failedEntries);
            this.failedEntries.clear();
        }
        finally {
            try {
                this.delegate.registerTranslation(sLang, tLang, entryContents, entrySource);
            }
            catch (Exception e) {
                this.failedEntries.put(entrySource, entryContents);
            }
        }
    }

    public Iterable<ITMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        final Iterator<? extends ITMXEntry> delegateIterator = this.delegate.findMatchingTranslations(sLang, tLang, text, minScore, maxCount).iterator();
        return () -> new Iterator<ITMXEntry>(){
            Iterator cacheIterator;
            {
                this.cacheIterator = CacheWritableExternalMemory.this.failedEntries.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.cacheIterator.hasNext() || delegateIterator.hasNext();
            }

            @Override
            public void remove() {
            }

            @Override
            public ITMXEntry next() {
                if (this.cacheIterator.hasNext()) {
                    return (ITMXEntry)this.cacheIterator.next();
                }
                return (ITMXEntry)delegateIterator.next();
            }
        };
    }
}

