/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.ReaderUtil;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.lucene.LuceneWriter;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.core.search.ISearchable;
import org.omegat.core.search.TextExpression;
import org.omegat.util.Language;

public class LuceneReader
implements IBrowsableMemory,
ISearchable {
    private final NgramAnalyzer analyzer = new NgramAnalyzer();
    private IndexReader indexReader;
    private IndexSearcher searcher;
    private String name;
    private String srcIndex = "src";
    private String traIndex = "tra";
    private static final Pattern LITTERAL = Pattern.compile("(?<!\\\\)[^\\\\\\(\\)\\{\\}\\[\\]\\+\\-\\*]{4}");

    public LuceneReader(Properties prop) throws IOException {
        this(new File(prop.getProperty("dir")));
    }

    public LuceneReader(File indexDirectory) throws IOException {
        System.err.println("Reading Lucene : " + indexDirectory);
        if (!indexDirectory.isDirectory()) {
            indexDirectory = indexDirectory.getParentFile();
        }
        this.name = indexDirectory.getPath();
        this.indexReader = IndexReader.open((Directory)FSDirectory.open((File)indexDirectory));
        this.searcher = new IndexSearcher(this.indexReader);
        Collection fields = ReaderUtil.getIndexedFields((IndexReader)this.indexReader);
        if (!fields.contains("src")) {
            if (fields.contains("x-src.t")) {
                this.srcIndex = "x-src.t";
                this.traIndex = "x-tra.t";
            } else {
                this.srcIndex = Core.getProject().getProjectProperties().getSourceLanguage().toString().toUpperCase() + ".t";
                this.traIndex = Core.getProject().getProjectProperties().getTargetLanguage().toString().toUpperCase() + ".t";
            }
        }
        System.out.println("For indexed TM " + this.name + " : source field = " + this.srcIndex + ", target index = " + this.traIndex);
        File stopFile = new File(indexDirectory, "stop");
        if (stopFile.exists()) {
            this.analyzer.loadstopNgrams(stopFile.getPath(), "src");
        } else {
            stopFile = new File(indexDirectory, "stop.lists");
            if (stopFile.exists()) {
                this.analyzer.loadstopNgrams(stopFile.getPath(), this.srcIndex);
            }
        }
    }

    @Override
    public String getProviderName() {
        if (this.srcIndex.equals("src")) {
            return "Lucene";
        }
        return "Exilis";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    private BooleanQuery buildQuery(String text, BooleanClause.Occur occur) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TokenStream queryTokenStream = this.analyzer.tokenStream(this.srcIndex, new StringReader(text));
        TermAttribute termAtt = (TermAttribute)queryTokenStream.addAttribute(TermAttribute.class);
        queryTokenStream.reset();
        HashSet<String> terms = new HashSet<String>();
        while (queryTokenStream.incrementToken()) {
            terms.add(termAtt.term());
        }
        for (String current : terms) {
            query.add((Query)new TermQuery(new Term(this.srcIndex, current)), occur);
        }
        queryTokenStream.end();
        queryTokenStream.close();
        return query;
    }

    public Iterable<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        BooleanQuery query = this.buildQuery(text, BooleanClause.Occur.SHOULD);
        int minShould = query.clauses().size() * minScore / 200;
        if (minShould > 1) {
            query.setMinimumNumberShouldMatch(minShould);
        }
        return this.executeQuery(query, maxCount);
    }

    private Iterable<PrepareTMXEntry> executeQuery(BooleanQuery query, int maxCount) throws IOException {
        TopScoreDocCollector topCollector = TopScoreDocCollector.create((int)maxCount, (boolean)true);
        this.searcher.search((Query)query, (Collector)topCollector);
        final ArrayList<ScoreDoc> aList = new ArrayList<ScoreDoc>();
        for (ScoreDoc sdoc : topCollector.topDocs().scoreDocs) {
            aList.add(sdoc);
        }
        return () -> new Iterator<PrepareTMXEntry>(){
            private Iterator sdocs;
            {
                this.sdocs = aList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.sdocs.hasNext();
            }

            @Override
            public PrepareTMXEntry next() {
                try {
                    Document doc = LuceneReader.this.searcher.doc(((ScoreDoc)this.sdocs.next()).doc);
                    return LuceneReader.this.toEntry(doc);
                }
                catch (Exception cie) {
                    throw new RuntimeException(cie);
                }
            }
        };
    }

    @Override
    public IEntryCursor browseAllEntries() {
        int max1;
        for (max1 = this.indexReader.maxDoc() - 1; max1 > 0 && this.indexReader.isDeleted(max1); --max1) {
        }
        final int max = max1;
        return new IEntryCursor(){
            private int pos = -1;
            private Document currentDoc;
            private Iterator<Fieldable> propsIterator = null;
            private Fieldable currentField = null;

            @Override
            public boolean next() throws CorruptIndexException, IOException {
                if (this.pos >= max) {
                    return false;
                }
                ++this.pos;
                if (LuceneReader.this.indexReader.isDeleted(this.pos)) {
                    return this.next();
                }
                this.currentDoc = LuceneReader.this.indexReader.document(this.pos);
                this.propsIterator = null;
                return true;
            }

            @Override
            public String getEntrySource() {
                return this.currentDoc.get("src");
            }

            @Override
            public String getEntryTranslation() {
                return this.currentDoc.get("tra");
            }

            @Override
            public String getEntryAuthor() {
                return this.currentDoc.get("author");
            }

            @Override
            public String getEntryLastModifier() {
                return this.currentDoc.get("changer");
            }

            @Override
            public long getEntryCreationDate() throws Exception {
                return LuceneWriter.dateFormat.parse(this.currentDoc.get("creationDate")).getTime();
            }

            @Override
            public long getEntryLastModificationDate() throws Exception {
                return LuceneWriter.dateFormat.parse(this.currentDoc.get("changeDate")).getTime();
            }

            @Override
            public String getEntryNote() {
                return this.currentDoc.get("note");
            }

            @Override
            public boolean nextProperty() {
                if (this.propsIterator == null) {
                    List l1 = this.currentDoc.getFields();
                    ArrayList<Fieldable> l2 = new ArrayList<Fieldable>(l1.size() - 7);
                    for (Fieldable f : l1) {
                        if (!f.name().startsWith("prop.")) continue;
                        l2.add(f);
                    }
                    this.propsIterator = l2.iterator();
                }
                if (this.propsIterator.hasNext()) {
                    this.currentField = this.propsIterator.next();
                    return true;
                }
                return false;
            }

            @Override
            public String getCurrentPropertyName() {
                return this.currentField.name();
            }

            @Override
            public String getCurrentPropertyValue() {
                return this.currentField.stringValue();
            }
        };
    }

    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) throws CorruptIndexException, IOException {
        if (searchSource == null) {
            return this.searchUnindexed(numberOfResults, searchSource, searchTarget, searchNotes, andSearch, author, dateAfter, dateBefore);
        }
        if (!andSearch && searchTarget != null) {
            return this.searchUnindexed(numberOfResults, searchSource, searchTarget, searchNotes, andSearch, author, dateAfter, dateBefore);
        }
        if (!andSearch && searchNotes != null) {
            return this.searchUnindexed(numberOfResults, searchSource, searchTarget, searchNotes, andSearch, author, dateAfter, dateBefore);
        }
        if (searchSource instanceof TextExpression.RegexTextExpression) {
            String pattern = ((TextExpression.RegexTextExpression)searchSource).getPattern().pattern();
            BooleanQuery query = new BooleanQuery();
            Matcher m = LITTERAL.matcher(pattern);
            while (m.find()) {
                query.add((Query)this.buildQuery(m.group(), BooleanClause.Occur.MUST), BooleanClause.Occur.MUST);
            }
            if (query.iterator().hasNext()) {
                return this.executeQuery(query, numberOfResults);
            }
        }
        if (searchSource instanceof TextExpression.WordsTextExpression) {
            BooleanQuery query = new BooleanQuery();
            for (TextExpression.RegexTextExpression word : ((TextExpression.WordsTextExpression)searchSource).split()) {
                String pattern = word.getPattern().pattern();
                Matcher m = LITTERAL.matcher(pattern);
                while (m.find()) {
                    query.add((Query)this.buildQuery(m.group(), BooleanClause.Occur.MUST), BooleanClause.Occur.MUST);
                }
            }
            if (query.iterator().hasNext()) {
                return this.executeQuery(query, numberOfResults);
            }
        }
        return this.searchUnindexed(numberOfResults, searchSource, searchTarget, searchNotes, andSearch, author, dateAfter, dateBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PrepareTMXEntry> searchUnindexed(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) throws CorruptIndexException, IOException {
        ArrayList<PrepareTMXEntry> result = new ArrayList<PrepareTMXEntry>();
        try {
            IEntryCursor entry = this.browseAllEntries();
            while (entry.next()) {
                String au;
                if (author != null && ((au = entry.getEntryLastModifier()) != null ? !author.matchesString(au) : (au = entry.getEntryAuthor()) != null && !author.matchesString(au))) continue;
                int cpt = 0;
                if (searchSource == null || searchSource.matchesString(entry.getEntrySource())) {
                    ++cpt;
                }
                if (searchTarget == null || searchTarget.matchesString(entry.getEntryTranslation())) {
                    ++cpt;
                }
                if (searchNotes == null || searchNotes.matchesString(entry.getEntryNote())) {
                    ++cpt;
                }
                if (andSearch ? cpt < 3 : cpt < 1) continue;
                result.add(entry.toPrepareTMXEntry());
                if (result.size() < numberOfResults) continue;
                ArrayList<PrepareTMXEntry> arrayList = result;
                return arrayList;
            }
        }
        finally {
            return result;
        }
    }

    private PrepareTMXEntry toEntry(Document doc) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = doc.get(this.srcIndex);
        entry.translation = doc.get(this.traIndex);
        entry.creator = doc.get("author");
        entry.changer = doc.get("changer");
        return entry;
    }
}

