/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Properties;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;

public class Client
implements ProjectMemory.IExternalProjectMemory {
    private IDistantExternalMemory remote;
    private long timeStampDiff;

    public Client(Properties propList) throws Exception {
        String url = propList.getProperty("url");
        this.remote = (IDistantExternalMemory)Naming.lookup(url);
        this.timeStampDiff = this.remote.timeStamp() - System.currentTimeMillis();
    }

    @Override
    public IEntryCursor findChanges(final long timeStamp) throws RemoteException {
        return new IEntryCursor(){
            String id;
            {
                this.id = Client.this.remote.findChanges(timeStamp + Client.this.timeStampDiff);
            }

            @Override
            public boolean next() throws RemoteException {
                if (this.id == null) {
                    return false;
                }
                if (this.id.length() == 0) {
                    return false;
                }
                return Client.this.remote.next(this.id);
            }

            @Override
            public String getEntrySource() throws RemoteException {
                return Client.this.remote.getEntrySource(this.id);
            }

            @Override
            public String getEntryTranslation() throws RemoteException {
                return Client.this.remote.getEntryTranslation(this.id);
            }

            @Override
            public String getEntryAuthor() throws RemoteException {
                return Client.this.remote.getEntryAuthor(this.id);
            }

            @Override
            public String getEntryLastModifier() throws RemoteException {
                return Client.this.remote.getEntryLastModifier(this.id);
            }

            @Override
            public long getEntryCreationDate() throws RemoteException {
                return Client.this.remote.getEntryCreationDate(this.id);
            }

            @Override
            public long getEntryLastModificationDate() throws RemoteException {
                return Client.this.remote.getEntryLastModificationDate(this.id);
            }

            @Override
            public String getEntryNote() throws RemoteException {
                return Client.this.remote.getEntryNote(this.id);
            }

            @Override
            public boolean nextProperty() throws RemoteException {
                return false;
            }

            @Override
            public String getCurrentPropertyName() throws RemoteException {
                return "";
            }

            @Override
            public String getCurrentPropertyValue() throws RemoteException {
                return "";
            }

            @Override
            public EntryKey buildEntryKey() throws RemoteException {
                String[] info = Client.this.remote.getEntryKey(this.id);
                if (info == null) {
                    return null;
                }
                return new EntryKey(info[0], info[1], info[2], info[3], info[4], info[5]);
            }
        };
    }

    @Override
    public void registerTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) throws RemoteException {
        if (isDefault) {
            if (te == null) {
                this.remote.registerDefaultTranslation(ste.getSrcText(), null);
            } else {
                this.remote.registerDefaultTranslation(te.source, te.translation);
            }
        } else {
            EntryKey key = ste.getKey();
            if (te == null) {
                this.remote.registerAltTranslation(ste.getSrcText(), null, key.file, key.id, key.path, key.prev, key.next);
            } else {
                this.remote.registerAltTranslation(te.source, te.translation, key.file, key.id, key.path, key.prev, key.next);
            }
        }
    }
}

