/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;

public class Server
extends UnicastRemoteObject
implements IDistantExternalMemory,
IEntryEventListener {
    private Set<Integer> changesFromClients = new HashSet<Integer>();
    private boolean isUpdating = false;
    private Map<String, Iterator<SourceTextEntry>> openedCursors = new HashMap<String, Iterator<SourceTextEntry>>();
    private Map<String, SourceTextEntry> openedEntries = new HashMap<String, SourceTextEntry>();
    private ProjectMemory.ExtendedCheckOrphanedCallback entries;

    private Server() throws RemoteException {
        CoreEvents.registerEntryEventListener(this);
    }

    public static Server open(String portStr, String object) throws Exception {
        int port = 1099;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        LocateRegistry.createRegistry(port);
        System.err.println("Listening server " + port);
        if (!object.startsWith("//") && port != 1099) {
            object = "//localhost:" + port + "/" + object;
        }
        Server res = new Server();
        Naming.bind(object, res);
        System.err.println("Listening server object " + object);
        return res;
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        if (this.isUpdating) {
            return;
        }
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            try {
                if (this.changesFromClients.size() > 0) {
                    Core.getEditor().commitAndDeactivate();
                    Core.getEditor().refreshEntries(this.changesFromClients);
                    Core.getEditor().activateEntry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.changesFromClients.clear();
            }
        }
    }

    @Override
    public String findChanges(long timeStamp) {
        IProject proj = Core.getProject();
        if (!(proj instanceof RealProject)) {
            return null;
        }
        HashSet<SourceTextEntry> usedEntries = new HashSet<SourceTextEntry>();
        for (SourceTextEntry ste : proj.getAllEntries()) {
            TMXEntry te = proj.getTranslationInfo(ste);
            if (!te.isTranslated() || te.changeDate <= timeStamp && te.creationDate <= timeStamp) continue;
            usedEntries.add(ste);
        }
        Iterator iter = usedEntries.iterator();
        this.openedCursors.put(iter.toString(), iter);
        return iter.toString();
    }

    @Override
    public boolean next(String id) throws RemoteException {
        Iterator<SourceTextEntry> iter = this.openedCursors.get(id);
        if (iter == null) {
            throw new RemoteException("Cursor " + id + " does not exist");
        }
        if (iter.hasNext()) {
            this.openedEntries.put(id, iter.next());
            return true;
        }
        this.openedEntries.remove(id);
        this.openedCursors.remove(id);
        return false;
    }

    @Override
    public String getEntrySource(String id) {
        return this.openedEntries.get(id).getSrcText();
    }

    @Override
    public String getEntryTranslation(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return null;
        }
        return te.translation;
    }

    @Override
    public String getEntryAuthor(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return null;
        }
        return te.creator;
    }

    @Override
    public String getEntryLastModifier(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return null;
        }
        return te.changer;
    }

    @Override
    public long getEntryCreationDate(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return 0L;
        }
        return te.creationDate;
    }

    @Override
    public long getEntryLastModificationDate(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return 0L;
        }
        return te.changeDate;
    }

    @Override
    public String getEntryNote(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return null;
        }
        return te.note;
    }

    @Override
    public String[] getEntryKey(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id));
        if (te == null) {
            return null;
        }
        if (te.defaultTranslation) {
            return null;
        }
        EntryKey key = this.openedEntries.get(id).getKey();
        return new String[]{key.file, key.sourceText, key.id, key.prev, key.next, key.path};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDefaultTranslation(String src, String tra) {
        SourceTextEntry ste;
        if (this.entries == null) {
            this.entries = new ProjectMemory.ExtendedCheckOrphanedCallback(Core.getProject().getAllEntries());
        }
        if ((ste = this.entries.existSource.get(src)) == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, true, null);
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            this.isUpdating = true;
            this.changesFromClients.add(ste.entryNum());
            this.isUpdating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAltTranslation(String src, String tra, String file, String id, String path, String prev, String next) {
        SourceTextEntry ste;
        if (this.entries == null) {
            this.entries = new ProjectMemory.ExtendedCheckOrphanedCallback(Core.getProject().getAllEntries());
        }
        if ((ste = this.entries.existKeys.get(new EntryKey(file, src, id, prev, next, path))) == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, false, null);
        Set<Integer> set = this.changesFromClients;
        synchronized (set) {
            this.isUpdating = true;
            this.changesFromClients.add(ste.entryNum());
            this.isUpdating = false;
        }
    }

    @Override
    public long timeStamp() {
        return System.currentTimeMillis();
    }
}

