/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;

public final class Segmenter {
    private ISegmentationData segData;
    private static final Pattern PTN_TAGS_MULTIPLE = Pattern.compile("(<\\/?[a-zA-Z]+[0-9]+\\/?>)+");
    private static final Pattern PTN_TAGS_UNIQUE = Pattern.compile("<\\/?[a-zA-Z]+[0-9]+\\/?>");
    private static Pattern DEFAULT_BEFOREBREAK_PATTERN = Pattern.compile(".", 32);
    private static final Pattern LINE_BREAK_OR_TAB_PATTERN = Pattern.compile("^( *)[\\r\\n\\t]");

    public Segmenter() {
        this.setSegmentationData(ISegmentationData.getDefault());
    }

    public void setSegmentationData(ISegmentationData segData) {
        this.segData = segData;
    }

    public List<String> segment(Language lang, String paragraph, List<StringBuilder> spaces, List<Rule> brules) {
        if (paragraph == null) {
            return null;
        }
        List<String> segments = this.breakParagraph(lang, paragraph, brules);
        ArrayList<String> sentences = new ArrayList<String>(segments.size());
        if (spaces == null) {
            spaces = new ArrayList<StringBuilder>();
        }
        spaces.clear();
        for (String one : segments) {
            int e;
            int cp;
            int b;
            int cp2;
            int len = one.length();
            StringBuilder bs = new StringBuilder();
            for (b = 0; b < len && Character.isWhitespace(cp2 = one.codePointAt(b)); b += Character.charCount(cp2)) {
                bs.appendCodePoint(cp2);
            }
            StringBuilder es = new StringBuilder();
            for (e = len; e > b && Character.isWhitespace(cp = one.codePointBefore(e)); e -= Character.charCount(cp)) {
                es.appendCodePoint(cp);
            }
            es.reverse();
            String trimmed = one.substring(b, e);
            sentences.add(trimmed);
            if (spaces == null) continue;
            spaces.add(bs);
            spaces.add(es);
        }
        return sentences;
    }

    private List<String> breakParagraph(Language lang, String paragraph, List<Rule> brules) {
        if (Core.getProject() == null || Core.getProject().getProjectProperties() == null || Core.getProject().getProjectProperties().getProjectSegmentationData() == null || Core.getProject().getProjectProperties().isTagsFormatHandles() == null ? !Preferences.isPreferenceDefault("seg_use_tags_as_formathandles", false) : Core.getProject().getProjectProperties().isTagsFormatHandles() == false) {
            return this.breakTextParagraph(lang, paragraph, brules);
        }
        Matcher tm = PTN_TAGS_MULTIPLE.matcher(paragraph);
        TreeMap<Integer, String> tags = new TreeMap<Integer, String>();
        while (tm.find()) {
            tags.put(tm.start(), tm.group());
            paragraph = paragraph.substring(0, tm.start()) + paragraph.substring(tm.end());
            tm.reset(paragraph);
        }
        List<String> res = this.breakTextParagraph(lang, paragraph, brules);
        Iterator iterator = tags.descendingKeySet().iterator();
        block1: while (iterator.hasNext()) {
            int tagPos = (Integer)iterator.next();
            int pos = 0;
            for (int ri = 0; ri < res.size(); ++ri) {
                if ((pos += res.get(ri).length()) > tagPos) {
                    String seg = res.get(ri);
                    int pos1 = pos - seg.length();
                    pos1 = tagPos - pos1;
                    seg = seg.substring(0, pos1) + (String)tags.get(tagPos) + seg.substring(pos1);
                    res.set(ri, seg);
                    continue block1;
                }
                if (pos != tagPos) continue;
                boolean before = true;
                tm = PTN_TAGS_UNIQUE.matcher((CharSequence)tags.get(tagPos));
                while (tm.find()) {
                    if (!tm.group().contains("/")) {
                        if (!this.segData.isIncludeStartingTags()) {
                            before = false;
                        }
                    } else if (tm.group().startsWith("</")) {
                        if (!this.segData.isIncludeEndingTags()) {
                            before = false;
                        }
                    } else if (tm.group().endsWith("/>") && !this.segData.isIncludeIsolatedTags()) {
                        before = false;
                    }
                    if (before) {
                        res.set(ri, res.get(ri) + tm.group());
                        continue;
                    }
                    if (ri < res.size() - 1) {
                        res.set(ri + 1, tm.group() + res.get(ri + 1));
                        continue;
                    }
                    res.set(ri, res.get(ri) + tm.group());
                }
                continue block1;
            }
        }
        return res;
    }

    private List<String> breakTextParagraph(Language lang, String paragraph, List<Rule> brules) {
        List<Rule> rules = this.segData.lookupRulesForLanguage(lang);
        if (brules == null) {
            brules = new ArrayList<Rule>();
        }
        TreeSet<BreakPosition> dontbreakpositions = new TreeSet<BreakPosition>();
        TreeSet<BreakPosition> breakpositions = new TreeSet<BreakPosition>();
        for (int i = rules.size() - 1; i >= 0; --i) {
            Rule rule = rules.get(i);
            List<BreakPosition> rulebreaks = Segmenter.getBreaks(paragraph, rule);
            if (rule.isBreakRule()) {
                breakpositions.addAll(rulebreaks);
                dontbreakpositions.removeAll(rulebreaks);
                continue;
            }
            dontbreakpositions.addAll(rulebreaks);
            breakpositions.removeAll(rulebreaks);
        }
        breakpositions.removeAll(dontbreakpositions);
        ArrayList<String> segments = new ArrayList<String>();
        brules.clear();
        int prevpos = 0;
        for (BreakPosition bposition : breakpositions) {
            String oneseg = paragraph.substring(prevpos, bposition.position);
            segments.add(oneseg);
            brules.add(bposition.reason);
            prevpos = bposition.position;
        }
        try {
            String oneseg = paragraph.substring(prevpos);
            if (oneseg.trim().isEmpty() && !segments.isEmpty()) {
                String prev = (String)segments.get(segments.size() - 1);
                prev = prev + oneseg;
                segments.set(segments.size() - 1, prev);
            } else {
                segments.add(oneseg);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return segments;
    }

    private static List<BreakPosition> getBreaks(String paragraph, Rule rule) {
        ArrayList<BreakPosition> res = new ArrayList<BreakPosition>();
        Matcher bbm = null;
        if (rule.getBeforebreak() != null) {
            bbm = rule.getCompiledBeforebreak().matcher(paragraph);
        }
        Matcher abm = null;
        if (rule.getAfterbreak() != null) {
            abm = rule.getCompiledAfterbreak().matcher(paragraph);
        }
        if (bbm == null && abm == null) {
            return res;
        }
        if (abm != null && !abm.find()) {
            return res;
        }
        if (bbm == null) {
            bbm = DEFAULT_BEFOREBREAK_PATTERN.matcher(paragraph);
        }
        while (bbm.find()) {
            int bbe = bbm.end();
            if (abm == null) {
                res.add(new BreakPosition(bbe, rule));
                continue;
            }
            int abs = abm.start();
            while (abs < bbe) {
                boolean found = abm.find();
                if (!found) {
                    return res;
                }
                abs = abm.start();
            }
            if (abs != bbe) continue;
            res.add(new BreakPosition(bbe, rule));
        }
        return res;
    }

    public String glue(Language sourceLang, Language targetLang, List<String> sentences, List<StringBuilder> spaces, List<Rule> brules) {
        if (sentences.size() <= 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        res.append(sentences.get(0));
        for (int i = 1; i < sentences.size(); ++i) {
            StringBuilder sp = new StringBuilder();
            sp.append((CharSequence)spaces.get(2 * i - 1));
            sp.append((CharSequence)spaces.get(2 * i));
            if (!targetLang.isSpaceDelimited()) {
                Rule rule = brules.get(i - 1);
                if (res.length() > 0) {
                    char lastChar = res.charAt(res.length() - 1);
                    Matcher matcher = LINE_BREAK_OR_TAB_PATTERN.matcher(sp.toString());
                    if (matcher.find()) {
                        String leftSpaces = matcher.group(1);
                        if (!leftSpaces.isEmpty()) {
                            sp.replace(0, leftSpaces.length(), "");
                        }
                    } else if (!(lastChar == '.' || PatternConsts.SPACY_REGEX.matcher(rule.getBeforebreak()).matches() && PatternConsts.SPACY_REGEX.matcher(rule.getAfterbreak()).matches())) {
                        sp.setLength(0);
                    }
                }
            } else if (!sourceLang.isSpaceDelimited() && sp.length() == 0) {
                sp.append(" ");
            }
            res.append((CharSequence)sp);
            res.append(sentences.get(i));
        }
        return res.toString();
    }

    public void segmentEntries(boolean needResegment, Language sourceLang, String sourceEntry, Language targetLang, String targetEntry, List<String> sourceSegments, List<String> targetSegments) {
        if (needResegment) {
            List<String> srcSegments = this.segment(sourceLang, sourceEntry, null, null);
            if (targetEntry != null) {
                List<String> tarSegments = this.segment(targetLang, targetEntry, null, null);
                if (srcSegments.size() == tarSegments.size()) {
                    sourceSegments.addAll(srcSegments);
                    targetSegments.addAll(tarSegments);
                    return;
                }
            }
        }
        sourceSegments.add(sourceEntry);
        targetSegments.add(targetEntry);
    }

    static class BreakPosition
    implements Comparable<BreakPosition> {
        int position;
        Rule reason;

        BreakPosition(int position, Rule reason) {
            this.position = position;
            this.reason = reason;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BreakPosition)) {
                return false;
            }
            BreakPosition that = (BreakPosition)obj;
            return this.position == that.position;
        }

        public int hashCode() {
            return this.position;
        }

        @Override
        public int compareTo(BreakPosition that) {
            return this.position - that.position;
        }
    }
}

