/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FindMatches;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.TMXProp;

public class FindMatchesStatistics
extends FindMatches {
    private int resultScore = -1;

    public FindMatchesStatistics(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, memoryPath, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.FUZZY_MATCH_THRESHOLD = 0;
    }

    public FindMatchesStatistics(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        super(sourceTokenizer, externalMemories, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.FUZZY_MATCH_THRESHOLD = 0;
    }

    @Override
    public final int maxCount() {
        return 1;
    }

    public int search(IProject project, String searchText, boolean requiresTranslation, IStopped stop) throws FindMatches.StoppedException {
        this.resultScore = -1;
        try {
            this.doSearch(project, searchText, requiresTranslation, false, stop);
        }
        catch (FindMatches.StoppedException st) {
            if (this.resultScore >= 95) {
                return this.resultScore;
            }
            throw st;
        }
        return this.resultScore;
    }

    @Override
    protected void evalEntry(EntryKey key, String source, String translation, String realSource, int totalPenalty, boolean fuzzy, NearString.MATCH_SOURCE comesFrom, String tmxName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        switch (this.sortKey) {
            case SCORE: {
                this.resultScore = Math.max(this.resultScore, this.calcSimilarityStem(realSource) - totalPenalty);
                break;
            }
            case SCORE_NO_STEM: {
                this.resultScore = Math.max(this.resultScore, this.calcSimilarityNoStem(realSource) - totalPenalty);
                break;
            }
            case ADJUSTED_SCORE: {
                this.resultScore = Math.max(this.resultScore, this.calcSimilarityAdjusted(realSource) - totalPenalty);
            }
        }
        if (this.resultScore >= 95) {
            throw new FindMatches.StoppedException();
        }
    }
}

