/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.File;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.filehooks.ReformatterHook;
import org.omegat.filehooks.RenumXliffHook;
import org.omegat.filehooks.SdlProjectHook;
import org.omegat.filehooks.SdlxliffFileHook;
import org.omegat.filehooks.XliffFileHook;
import org.omegat.filters4.xml.openxml.MsOfficeFileFilter;

public interface IFileHook {
    public static final IFileHook DEFAULT_HOOK = new IFileHook(){};
    public static final XliffFileHook XLIFF_HOOK = new XliffFileHook();
    public static final SdlxliffFileHook SDLXLIFF_HOOK = new SdlxliffFileHook();
    public static final ReformatterHook REFORMAT_HOOK = new ReformatterHook();
    public static final RenumXliffHook RENUM_XLIFF_HOOK = new RenumXliffHook();
    public static final SdlProjectHook SDLPROJ_HOOK = new SdlProjectHook();

    default public String getNativeSourceFile(String currentFile, SourceTextEntry entry) {
        return currentFile;
    }

    default public boolean supportsPseudoTags() {
        return false;
    }

    default public void postCompile(File destDir, String midName) {
    }

    default public boolean isNotToCompile(String midName) {
        return false;
    }

    default public String getNativeTargetFile(String currentFile) {
        return currentFile;
    }

    default public boolean supportsOpenInStudio(String currentFile) {
        return false;
    }

    default public String getTradosTargetFile(String currentFile) {
        return currentFile;
    }

    default public Exception lastCompileException() {
        return null;
    }

    public static Class<?> getFilterClass(String currentFile, IProject project) {
        for (IProject.FileInfo info : project.getProjectFiles()) {
            if (!info.filePath.equals(currentFile)) continue;
            return info.filterClass;
        }
        return null;
    }

    public static IFileHook hookForFile(String currentFile, IProject project) {
        String ext = currentFile.toLowerCase();
        if ((ext = ext.substring(ext.indexOf(46))).endsWith(".renum.xlf")) {
            return RENUM_XLIFF_HOOK;
        }
        if (ext.endsWith(".sdlxliff")) {
            return SDLXLIFF_HOOK;
        }
        if (ext.endsWith(".renum.xlf")) {
            return RENUM_XLIFF_HOOK;
        }
        if (ext.endsWith(".xlf") || ext.endsWith(".xliff")) {
            return XLIFF_HOOK;
        }
        if (ext.endsWith(".htm") || ext.endsWith(".html")) {
            return REFORMAT_HOOK;
        }
        if (ext.endsWith(".docx")) {
            if (MsOfficeFileFilter.class.isAssignableFrom(IFileHook.getFilterClass(currentFile, project))) {
                return new IFileHook(){

                    @Override
                    public boolean supportsPseudoTags() {
                        return true;
                    }
                };
            }
            return REFORMAT_HOOK;
        }
        if (ext.endsWith(".sdlppx")) {
            return SDLPROJ_HOOK;
        }
        return DEFAULT_HOOK;
    }
}

