/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui;

import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.omegat.core.Core;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.tagvalidation.TagValidationFrame;

public class HListener
implements HyperlinkListener {
    private MainWindow m_transFrame;
    private boolean m_grabFocus;
    private TagValidationFrame m_tagValFrame;

    public HListener(MainWindow t, TagValidationFrame f, boolean grabFocus) {
        this.m_transFrame = t;
        this.m_tagValFrame = f;
        this.m_grabFocus = grabFocus;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            final String desc = e.getDescription();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (desc.startsWith("fix:")) {
                            int entry = Integer.parseInt(desc.substring("fix:".length()));
                            String fixedSource = HListener.this.m_tagValFrame.fixEntry(entry);
                            Core.getEditor().gotoEntryAfterFix(entry, fixedSource);
                        } else {
                            Core.getEditor().gotoEntry(Integer.parseInt(desc));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            if (this.m_grabFocus) {
                this.m_transFrame.toFront();
            }
        }
    }
}

